/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBootstrapBrokersResponse extends KafkaResponse implements
        ToCopyableBuilder<GetBootstrapBrokersResponse.Builder, GetBootstrapBrokersResponse> {
    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerString").getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerString))
            .setter(setter(Builder::bootstrapBrokerString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerString").build())
            .build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_TLS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringTls").getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringTls))
            .setter(setter(Builder::bootstrapBrokerStringTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerStringTls").build())
            .build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_SASL_SCRAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringSaslScram")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringSaslScram))
            .setter(setter(Builder::bootstrapBrokerStringSaslScram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerStringSaslScram")
                    .build()).build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_SASL_IAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringSaslIam")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringSaslIam))
            .setter(setter(Builder::bootstrapBrokerStringSaslIam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerStringSaslIam")
                    .build()).build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_PUBLIC_TLS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringPublicTls")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringPublicTls))
            .setter(setter(Builder::bootstrapBrokerStringPublicTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerStringPublicTls")
                    .build()).build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_PUBLIC_SASL_SCRAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringPublicSaslScram")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringPublicSaslScram))
            .setter(setter(Builder::bootstrapBrokerStringPublicSaslScram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bootstrapBrokerStringPublicSaslScram").build()).build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_PUBLIC_SASL_IAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringPublicSaslIam")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringPublicSaslIam))
            .setter(setter(Builder::bootstrapBrokerStringPublicSaslIam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerStringPublicSaslIam")
                    .build()).build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_TLS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringVpcConnectivityTls")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringVpcConnectivityTls))
            .setter(setter(Builder::bootstrapBrokerStringVpcConnectivityTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bootstrapBrokerStringVpcConnectivityTls").build()).build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_SASL_SCRAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringVpcConnectivitySaslScram")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringVpcConnectivitySaslScram))
            .setter(setter(Builder::bootstrapBrokerStringVpcConnectivitySaslScram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bootstrapBrokerStringVpcConnectivitySaslScram").build()).build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_SASL_IAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootstrapBrokerStringVpcConnectivitySaslIam")
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringVpcConnectivitySaslIam))
            .setter(setter(Builder::bootstrapBrokerStringVpcConnectivitySaslIam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bootstrapBrokerStringVpcConnectivitySaslIam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_BROKER_STRING_FIELD,
            BOOTSTRAP_BROKER_STRING_TLS_FIELD, BOOTSTRAP_BROKER_STRING_SASL_SCRAM_FIELD, BOOTSTRAP_BROKER_STRING_SASL_IAM_FIELD,
            BOOTSTRAP_BROKER_STRING_PUBLIC_TLS_FIELD, BOOTSTRAP_BROKER_STRING_PUBLIC_SASL_SCRAM_FIELD,
            BOOTSTRAP_BROKER_STRING_PUBLIC_SASL_IAM_FIELD, BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_TLS_FIELD,
            BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_SASL_SCRAM_FIELD, BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_SASL_IAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("bootstrapBrokerString", BOOTSTRAP_BROKER_STRING_FIELD);
                    put("bootstrapBrokerStringTls", BOOTSTRAP_BROKER_STRING_TLS_FIELD);
                    put("bootstrapBrokerStringSaslScram", BOOTSTRAP_BROKER_STRING_SASL_SCRAM_FIELD);
                    put("bootstrapBrokerStringSaslIam", BOOTSTRAP_BROKER_STRING_SASL_IAM_FIELD);
                    put("bootstrapBrokerStringPublicTls", BOOTSTRAP_BROKER_STRING_PUBLIC_TLS_FIELD);
                    put("bootstrapBrokerStringPublicSaslScram", BOOTSTRAP_BROKER_STRING_PUBLIC_SASL_SCRAM_FIELD);
                    put("bootstrapBrokerStringPublicSaslIam", BOOTSTRAP_BROKER_STRING_PUBLIC_SASL_IAM_FIELD);
                    put("bootstrapBrokerStringVpcConnectivityTls", BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_TLS_FIELD);
                    put("bootstrapBrokerStringVpcConnectivitySaslScram",
                            BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_SASL_SCRAM_FIELD);
                    put("bootstrapBrokerStringVpcConnectivitySaslIam", BOOTSTRAP_BROKER_STRING_VPC_CONNECTIVITY_SASL_IAM_FIELD);
                }
            });

    private final String bootstrapBrokerString;

    private final String bootstrapBrokerStringTls;

    private final String bootstrapBrokerStringSaslScram;

    private final String bootstrapBrokerStringSaslIam;

    private final String bootstrapBrokerStringPublicTls;

    private final String bootstrapBrokerStringPublicSaslScram;

    private final String bootstrapBrokerStringPublicSaslIam;

    private final String bootstrapBrokerStringVpcConnectivityTls;

    private final String bootstrapBrokerStringVpcConnectivitySaslScram;

    private final String bootstrapBrokerStringVpcConnectivitySaslIam;

    private GetBootstrapBrokersResponse(BuilderImpl builder) {
        super(builder);
        this.bootstrapBrokerString = builder.bootstrapBrokerString;
        this.bootstrapBrokerStringTls = builder.bootstrapBrokerStringTls;
        this.bootstrapBrokerStringSaslScram = builder.bootstrapBrokerStringSaslScram;
        this.bootstrapBrokerStringSaslIam = builder.bootstrapBrokerStringSaslIam;
        this.bootstrapBrokerStringPublicTls = builder.bootstrapBrokerStringPublicTls;
        this.bootstrapBrokerStringPublicSaslScram = builder.bootstrapBrokerStringPublicSaslScram;
        this.bootstrapBrokerStringPublicSaslIam = builder.bootstrapBrokerStringPublicSaslIam;
        this.bootstrapBrokerStringVpcConnectivityTls = builder.bootstrapBrokerStringVpcConnectivityTls;
        this.bootstrapBrokerStringVpcConnectivitySaslScram = builder.bootstrapBrokerStringVpcConnectivitySaslScram;
        this.bootstrapBrokerStringVpcConnectivitySaslIam = builder.bootstrapBrokerStringVpcConnectivitySaslIam;
    }

    /**
     *
     * <p>
     * A string containing one or more hostname:port pairs.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more hostname:port pairs.
     *         </p>
     */
    public final String bootstrapBrokerString() {
        return bootstrapBrokerString;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and TLS port pairs.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and TLS port pairs.
     *         </p>
     */
    public final String bootstrapBrokerStringTls() {
        return bootstrapBrokerStringTls;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
     *         </p>
     */
    public final String bootstrapBrokerStringSaslScram() {
        return bootstrapBrokerStringSaslScram;
    }

    /**
     *
     * <p>
     * A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
     * </p>
     * 
     * @return <p>
     *         A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
     *         </p>
     */
    public final String bootstrapBrokerStringSaslIam() {
        return bootstrapBrokerStringSaslIam;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and TLS port pairs.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and TLS port pairs.
     *         </p>
     */
    public final String bootstrapBrokerStringPublicTls() {
        return bootstrapBrokerStringPublicTls;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
     *         </p>
     */
    public final String bootstrapBrokerStringPublicSaslScram() {
        return bootstrapBrokerStringPublicSaslScram;
    }

    /**
     *
     * <p>
     * A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
     * </p>
     * 
     * @return <p>
     *         A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
     *         </p>
     */
    public final String bootstrapBrokerStringPublicSaslIam() {
        return bootstrapBrokerStringPublicSaslIam;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and TLS port pairs for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and TLS port pairs for VPC connectivity.
     *         </p>
     */
    public final String bootstrapBrokerStringVpcConnectivityTls() {
        return bootstrapBrokerStringVpcConnectivityTls;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and SASL/SCRAM port pairs for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and SASL/SCRAM port pairs for VPC connectivity.
     *         </p>
     */
    public final String bootstrapBrokerStringVpcConnectivitySaslScram() {
        return bootstrapBrokerStringVpcConnectivitySaslScram;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and SASL/IAM port pairs for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and SASL/IAM port pairs for VPC connectivity.
     *         </p>
     */
    public final String bootstrapBrokerStringVpcConnectivitySaslIam() {
        return bootstrapBrokerStringVpcConnectivitySaslIam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerString());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringTls());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringSaslScram());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringSaslIam());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringPublicTls());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringPublicSaslScram());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringPublicSaslIam());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringVpcConnectivityTls());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringVpcConnectivitySaslScram());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringVpcConnectivitySaslIam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBootstrapBrokersResponse)) {
            return false;
        }
        GetBootstrapBrokersResponse other = (GetBootstrapBrokersResponse) obj;
        return Objects.equals(bootstrapBrokerString(), other.bootstrapBrokerString())
                && Objects.equals(bootstrapBrokerStringTls(), other.bootstrapBrokerStringTls())
                && Objects.equals(bootstrapBrokerStringSaslScram(), other.bootstrapBrokerStringSaslScram())
                && Objects.equals(bootstrapBrokerStringSaslIam(), other.bootstrapBrokerStringSaslIam())
                && Objects.equals(bootstrapBrokerStringPublicTls(), other.bootstrapBrokerStringPublicTls())
                && Objects.equals(bootstrapBrokerStringPublicSaslScram(), other.bootstrapBrokerStringPublicSaslScram())
                && Objects.equals(bootstrapBrokerStringPublicSaslIam(), other.bootstrapBrokerStringPublicSaslIam())
                && Objects.equals(bootstrapBrokerStringVpcConnectivityTls(), other.bootstrapBrokerStringVpcConnectivityTls())
                && Objects.equals(bootstrapBrokerStringVpcConnectivitySaslScram(),
                        other.bootstrapBrokerStringVpcConnectivitySaslScram())
                && Objects.equals(bootstrapBrokerStringVpcConnectivitySaslIam(),
                        other.bootstrapBrokerStringVpcConnectivitySaslIam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBootstrapBrokersResponse").add("BootstrapBrokerString", bootstrapBrokerString())
                .add("BootstrapBrokerStringTls", bootstrapBrokerStringTls())
                .add("BootstrapBrokerStringSaslScram", bootstrapBrokerStringSaslScram())
                .add("BootstrapBrokerStringSaslIam", bootstrapBrokerStringSaslIam())
                .add("BootstrapBrokerStringPublicTls", bootstrapBrokerStringPublicTls())
                .add("BootstrapBrokerStringPublicSaslScram", bootstrapBrokerStringPublicSaslScram())
                .add("BootstrapBrokerStringPublicSaslIam", bootstrapBrokerStringPublicSaslIam())
                .add("BootstrapBrokerStringVpcConnectivityTls", bootstrapBrokerStringVpcConnectivityTls())
                .add("BootstrapBrokerStringVpcConnectivitySaslScram", bootstrapBrokerStringVpcConnectivitySaslScram())
                .add("BootstrapBrokerStringVpcConnectivitySaslIam", bootstrapBrokerStringVpcConnectivitySaslIam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BootstrapBrokerString":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerString()));
        case "BootstrapBrokerStringTls":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringTls()));
        case "BootstrapBrokerStringSaslScram":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringSaslScram()));
        case "BootstrapBrokerStringSaslIam":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringSaslIam()));
        case "BootstrapBrokerStringPublicTls":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringPublicTls()));
        case "BootstrapBrokerStringPublicSaslScram":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringPublicSaslScram()));
        case "BootstrapBrokerStringPublicSaslIam":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringPublicSaslIam()));
        case "BootstrapBrokerStringVpcConnectivityTls":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringVpcConnectivityTls()));
        case "BootstrapBrokerStringVpcConnectivitySaslScram":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringVpcConnectivitySaslScram()));
        case "BootstrapBrokerStringVpcConnectivitySaslIam":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringVpcConnectivitySaslIam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetBootstrapBrokersResponse, T> g) {
        return obj -> g.apply((GetBootstrapBrokersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBootstrapBrokersResponse> {
        /**
         *
         * <p>
         * A string containing one or more hostname:port pairs.
         * </p>
         * 
         * @param bootstrapBrokerString
         *        <p>
         *        A string containing one or more hostname:port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerString(String bootstrapBrokerString);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and TLS port pairs.
         * </p>
         * 
         * @param bootstrapBrokerStringTls
         *        <p>
         *        A string containing one or more DNS names (or IP) and TLS port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringTls(String bootstrapBrokerStringTls);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
         * </p>
         * 
         * @param bootstrapBrokerStringSaslScram
         *        <p>
         *        A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringSaslScram(String bootstrapBrokerStringSaslScram);

        /**
         *
         * <p>
         * A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
         * </p>
         * 
         * @param bootstrapBrokerStringSaslIam
         *        <p>
         *        A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringSaslIam(String bootstrapBrokerStringSaslIam);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and TLS port pairs.
         * </p>
         * 
         * @param bootstrapBrokerStringPublicTls
         *        <p>
         *        A string containing one or more DNS names (or IP) and TLS port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringPublicTls(String bootstrapBrokerStringPublicTls);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
         * </p>
         * 
         * @param bootstrapBrokerStringPublicSaslScram
         *        <p>
         *        A string containing one or more DNS names (or IP) and Sasl Scram port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringPublicSaslScram(String bootstrapBrokerStringPublicSaslScram);

        /**
         *
         * <p>
         * A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
         * </p>
         * 
         * @param bootstrapBrokerStringPublicSaslIam
         *        <p>
         *        A string that contains one or more DNS names (or IP addresses) and SASL IAM port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringPublicSaslIam(String bootstrapBrokerStringPublicSaslIam);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and TLS port pairs for VPC connectivity.
         * </p>
         * 
         * @param bootstrapBrokerStringVpcConnectivityTls
         *        <p>
         *        A string containing one or more DNS names (or IP) and TLS port pairs for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringVpcConnectivityTls(String bootstrapBrokerStringVpcConnectivityTls);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and SASL/SCRAM port pairs for VPC connectivity.
         * </p>
         * 
         * @param bootstrapBrokerStringVpcConnectivitySaslScram
         *        <p>
         *        A string containing one or more DNS names (or IP) and SASL/SCRAM port pairs for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringVpcConnectivitySaslScram(String bootstrapBrokerStringVpcConnectivitySaslScram);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and SASL/IAM port pairs for VPC connectivity.
         * </p>
         * 
         * @param bootstrapBrokerStringVpcConnectivitySaslIam
         *        <p>
         *        A string containing one or more DNS names (or IP) and SASL/IAM port pairs for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringVpcConnectivitySaslIam(String bootstrapBrokerStringVpcConnectivitySaslIam);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String bootstrapBrokerString;

        private String bootstrapBrokerStringTls;

        private String bootstrapBrokerStringSaslScram;

        private String bootstrapBrokerStringSaslIam;

        private String bootstrapBrokerStringPublicTls;

        private String bootstrapBrokerStringPublicSaslScram;

        private String bootstrapBrokerStringPublicSaslIam;

        private String bootstrapBrokerStringVpcConnectivityTls;

        private String bootstrapBrokerStringVpcConnectivitySaslScram;

        private String bootstrapBrokerStringVpcConnectivitySaslIam;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBootstrapBrokersResponse model) {
            super(model);
            bootstrapBrokerString(model.bootstrapBrokerString);
            bootstrapBrokerStringTls(model.bootstrapBrokerStringTls);
            bootstrapBrokerStringSaslScram(model.bootstrapBrokerStringSaslScram);
            bootstrapBrokerStringSaslIam(model.bootstrapBrokerStringSaslIam);
            bootstrapBrokerStringPublicTls(model.bootstrapBrokerStringPublicTls);
            bootstrapBrokerStringPublicSaslScram(model.bootstrapBrokerStringPublicSaslScram);
            bootstrapBrokerStringPublicSaslIam(model.bootstrapBrokerStringPublicSaslIam);
            bootstrapBrokerStringVpcConnectivityTls(model.bootstrapBrokerStringVpcConnectivityTls);
            bootstrapBrokerStringVpcConnectivitySaslScram(model.bootstrapBrokerStringVpcConnectivitySaslScram);
            bootstrapBrokerStringVpcConnectivitySaslIam(model.bootstrapBrokerStringVpcConnectivitySaslIam);
        }

        public final String getBootstrapBrokerString() {
            return bootstrapBrokerString;
        }

        public final void setBootstrapBrokerString(String bootstrapBrokerString) {
            this.bootstrapBrokerString = bootstrapBrokerString;
        }

        @Override
        public final Builder bootstrapBrokerString(String bootstrapBrokerString) {
            this.bootstrapBrokerString = bootstrapBrokerString;
            return this;
        }

        public final String getBootstrapBrokerStringTls() {
            return bootstrapBrokerStringTls;
        }

        public final void setBootstrapBrokerStringTls(String bootstrapBrokerStringTls) {
            this.bootstrapBrokerStringTls = bootstrapBrokerStringTls;
        }

        @Override
        public final Builder bootstrapBrokerStringTls(String bootstrapBrokerStringTls) {
            this.bootstrapBrokerStringTls = bootstrapBrokerStringTls;
            return this;
        }

        public final String getBootstrapBrokerStringSaslScram() {
            return bootstrapBrokerStringSaslScram;
        }

        public final void setBootstrapBrokerStringSaslScram(String bootstrapBrokerStringSaslScram) {
            this.bootstrapBrokerStringSaslScram = bootstrapBrokerStringSaslScram;
        }

        @Override
        public final Builder bootstrapBrokerStringSaslScram(String bootstrapBrokerStringSaslScram) {
            this.bootstrapBrokerStringSaslScram = bootstrapBrokerStringSaslScram;
            return this;
        }

        public final String getBootstrapBrokerStringSaslIam() {
            return bootstrapBrokerStringSaslIam;
        }

        public final void setBootstrapBrokerStringSaslIam(String bootstrapBrokerStringSaslIam) {
            this.bootstrapBrokerStringSaslIam = bootstrapBrokerStringSaslIam;
        }

        @Override
        public final Builder bootstrapBrokerStringSaslIam(String bootstrapBrokerStringSaslIam) {
            this.bootstrapBrokerStringSaslIam = bootstrapBrokerStringSaslIam;
            return this;
        }

        public final String getBootstrapBrokerStringPublicTls() {
            return bootstrapBrokerStringPublicTls;
        }

        public final void setBootstrapBrokerStringPublicTls(String bootstrapBrokerStringPublicTls) {
            this.bootstrapBrokerStringPublicTls = bootstrapBrokerStringPublicTls;
        }

        @Override
        public final Builder bootstrapBrokerStringPublicTls(String bootstrapBrokerStringPublicTls) {
            this.bootstrapBrokerStringPublicTls = bootstrapBrokerStringPublicTls;
            return this;
        }

        public final String getBootstrapBrokerStringPublicSaslScram() {
            return bootstrapBrokerStringPublicSaslScram;
        }

        public final void setBootstrapBrokerStringPublicSaslScram(String bootstrapBrokerStringPublicSaslScram) {
            this.bootstrapBrokerStringPublicSaslScram = bootstrapBrokerStringPublicSaslScram;
        }

        @Override
        public final Builder bootstrapBrokerStringPublicSaslScram(String bootstrapBrokerStringPublicSaslScram) {
            this.bootstrapBrokerStringPublicSaslScram = bootstrapBrokerStringPublicSaslScram;
            return this;
        }

        public final String getBootstrapBrokerStringPublicSaslIam() {
            return bootstrapBrokerStringPublicSaslIam;
        }

        public final void setBootstrapBrokerStringPublicSaslIam(String bootstrapBrokerStringPublicSaslIam) {
            this.bootstrapBrokerStringPublicSaslIam = bootstrapBrokerStringPublicSaslIam;
        }

        @Override
        public final Builder bootstrapBrokerStringPublicSaslIam(String bootstrapBrokerStringPublicSaslIam) {
            this.bootstrapBrokerStringPublicSaslIam = bootstrapBrokerStringPublicSaslIam;
            return this;
        }

        public final String getBootstrapBrokerStringVpcConnectivityTls() {
            return bootstrapBrokerStringVpcConnectivityTls;
        }

        public final void setBootstrapBrokerStringVpcConnectivityTls(String bootstrapBrokerStringVpcConnectivityTls) {
            this.bootstrapBrokerStringVpcConnectivityTls = bootstrapBrokerStringVpcConnectivityTls;
        }

        @Override
        public final Builder bootstrapBrokerStringVpcConnectivityTls(String bootstrapBrokerStringVpcConnectivityTls) {
            this.bootstrapBrokerStringVpcConnectivityTls = bootstrapBrokerStringVpcConnectivityTls;
            return this;
        }

        public final String getBootstrapBrokerStringVpcConnectivitySaslScram() {
            return bootstrapBrokerStringVpcConnectivitySaslScram;
        }

        public final void setBootstrapBrokerStringVpcConnectivitySaslScram(String bootstrapBrokerStringVpcConnectivitySaslScram) {
            this.bootstrapBrokerStringVpcConnectivitySaslScram = bootstrapBrokerStringVpcConnectivitySaslScram;
        }

        @Override
        public final Builder bootstrapBrokerStringVpcConnectivitySaslScram(String bootstrapBrokerStringVpcConnectivitySaslScram) {
            this.bootstrapBrokerStringVpcConnectivitySaslScram = bootstrapBrokerStringVpcConnectivitySaslScram;
            return this;
        }

        public final String getBootstrapBrokerStringVpcConnectivitySaslIam() {
            return bootstrapBrokerStringVpcConnectivitySaslIam;
        }

        public final void setBootstrapBrokerStringVpcConnectivitySaslIam(String bootstrapBrokerStringVpcConnectivitySaslIam) {
            this.bootstrapBrokerStringVpcConnectivitySaslIam = bootstrapBrokerStringVpcConnectivitySaslIam;
        }

        @Override
        public final Builder bootstrapBrokerStringVpcConnectivitySaslIam(String bootstrapBrokerStringVpcConnectivitySaslIam) {
            this.bootstrapBrokerStringVpcConnectivitySaslIam = bootstrapBrokerStringVpcConnectivitySaslIam;
            return this;
        }

        @Override
        public GetBootstrapBrokersResponse build() {
            return new GetBootstrapBrokersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
