/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarized information about Kafka Cluster used as source / target for replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KafkaClusterSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<KafkaClusterSummary.Builder, KafkaClusterSummary> {
    private static final SdkField<AmazonMskCluster> AMAZON_MSK_CLUSTER_FIELD = SdkField
            .<AmazonMskCluster> builder(MarshallingType.SDK_POJO).memberName("AmazonMskCluster")
            .getter(getter(KafkaClusterSummary::amazonMskCluster)).setter(setter(Builder::amazonMskCluster))
            .constructor(AmazonMskCluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonMskCluster").build()).build();

    private static final SdkField<String> KAFKA_CLUSTER_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KafkaClusterAlias").getter(getter(KafkaClusterSummary::kafkaClusterAlias))
            .setter(setter(Builder::kafkaClusterAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_MSK_CLUSTER_FIELD,
            KAFKA_CLUSTER_ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("amazonMskCluster", AMAZON_MSK_CLUSTER_FIELD);
                    put("kafkaClusterAlias", KAFKA_CLUSTER_ALIAS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AmazonMskCluster amazonMskCluster;

    private final String kafkaClusterAlias;

    private KafkaClusterSummary(BuilderImpl builder) {
        this.amazonMskCluster = builder.amazonMskCluster;
        this.kafkaClusterAlias = builder.kafkaClusterAlias;
    }

    /**
     * <p>
     * Details of an Amazon MSK Cluster.
     * </p>
     * 
     * @return Details of an Amazon MSK Cluster.
     */
    public final AmazonMskCluster amazonMskCluster() {
        return amazonMskCluster;
    }

    /**
     * <p>
     * The alias of the Kafka cluster. Used to prefix names of replicated topics.
     * </p>
     * 
     * @return The alias of the Kafka cluster. Used to prefix names of replicated topics.
     */
    public final String kafkaClusterAlias() {
        return kafkaClusterAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonMskCluster());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaClusterAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaClusterSummary)) {
            return false;
        }
        KafkaClusterSummary other = (KafkaClusterSummary) obj;
        return Objects.equals(amazonMskCluster(), other.amazonMskCluster())
                && Objects.equals(kafkaClusterAlias(), other.kafkaClusterAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KafkaClusterSummary").add("AmazonMskCluster", amazonMskCluster())
                .add("KafkaClusterAlias", kafkaClusterAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonMskCluster":
            return Optional.ofNullable(clazz.cast(amazonMskCluster()));
        case "KafkaClusterAlias":
            return Optional.ofNullable(clazz.cast(kafkaClusterAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KafkaClusterSummary, T> g) {
        return obj -> g.apply((KafkaClusterSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KafkaClusterSummary> {
        /**
         * <p>
         * Details of an Amazon MSK Cluster.
         * </p>
         * 
         * @param amazonMskCluster
         *        Details of an Amazon MSK Cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonMskCluster(AmazonMskCluster amazonMskCluster);

        /**
         * <p>
         * Details of an Amazon MSK Cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmazonMskCluster.Builder} avoiding the
         * need to create one manually via {@link AmazonMskCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonMskCluster.Builder#build()} is called immediately and its
         * result is passed to {@link #amazonMskCluster(AmazonMskCluster)}.
         * 
         * @param amazonMskCluster
         *        a consumer that will call methods on {@link AmazonMskCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonMskCluster(AmazonMskCluster)
         */
        default Builder amazonMskCluster(Consumer<AmazonMskCluster.Builder> amazonMskCluster) {
            return amazonMskCluster(AmazonMskCluster.builder().applyMutation(amazonMskCluster).build());
        }

        /**
         * <p>
         * The alias of the Kafka cluster. Used to prefix names of replicated topics.
         * </p>
         * 
         * @param kafkaClusterAlias
         *        The alias of the Kafka cluster. Used to prefix names of replicated topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusterAlias(String kafkaClusterAlias);
    }

    static final class BuilderImpl implements Builder {
        private AmazonMskCluster amazonMskCluster;

        private String kafkaClusterAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaClusterSummary model) {
            amazonMskCluster(model.amazonMskCluster);
            kafkaClusterAlias(model.kafkaClusterAlias);
        }

        public final AmazonMskCluster.Builder getAmazonMskCluster() {
            return amazonMskCluster != null ? amazonMskCluster.toBuilder() : null;
        }

        public final void setAmazonMskCluster(AmazonMskCluster.BuilderImpl amazonMskCluster) {
            this.amazonMskCluster = amazonMskCluster != null ? amazonMskCluster.build() : null;
        }

        @Override
        public final Builder amazonMskCluster(AmazonMskCluster amazonMskCluster) {
            this.amazonMskCluster = amazonMskCluster;
            return this;
        }

        public final String getKafkaClusterAlias() {
            return kafkaClusterAlias;
        }

        public final void setKafkaClusterAlias(String kafkaClusterAlias) {
            this.kafkaClusterAlias = kafkaClusterAlias;
        }

        @Override
        public final Builder kafkaClusterAlias(String kafkaClusterAlias) {
            this.kafkaClusterAlias = kafkaClusterAlias;
            return this;
        }

        @Override
        public KafkaClusterSummary build() {
            return new KafkaClusterSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
