/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration for replication between a source and target Kafka cluster (sourceKafkaClusterAlias ->
 * targetKafkaClusterAlias)
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationInfoDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationInfoDescription.Builder, ReplicationInfoDescription> {
    private static final SdkField<ConsumerGroupReplication> CONSUMER_GROUP_REPLICATION_FIELD = SdkField
            .<ConsumerGroupReplication> builder(MarshallingType.SDK_POJO).memberName("ConsumerGroupReplication")
            .getter(getter(ReplicationInfoDescription::consumerGroupReplication))
            .setter(setter(Builder::consumerGroupReplication)).constructor(ConsumerGroupReplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupReplication").build())
            .build();

    private static final SdkField<String> SOURCE_KAFKA_CLUSTER_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceKafkaClusterAlias").getter(getter(ReplicationInfoDescription::sourceKafkaClusterAlias))
            .setter(setter(Builder::sourceKafkaClusterAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKafkaClusterAlias").build())
            .build();

    private static final SdkField<String> TARGET_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCompressionType").getter(getter(ReplicationInfoDescription::targetCompressionTypeAsString))
            .setter(setter(Builder::targetCompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCompressionType").build())
            .build();

    private static final SdkField<String> TARGET_KAFKA_CLUSTER_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetKafkaClusterAlias").getter(getter(ReplicationInfoDescription::targetKafkaClusterAlias))
            .setter(setter(Builder::targetKafkaClusterAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKafkaClusterAlias").build())
            .build();

    private static final SdkField<TopicReplication> TOPIC_REPLICATION_FIELD = SdkField
            .<TopicReplication> builder(MarshallingType.SDK_POJO).memberName("TopicReplication")
            .getter(getter(ReplicationInfoDescription::topicReplication)).setter(setter(Builder::topicReplication))
            .constructor(TopicReplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicReplication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSUMER_GROUP_REPLICATION_FIELD, SOURCE_KAFKA_CLUSTER_ALIAS_FIELD, TARGET_COMPRESSION_TYPE_FIELD,
            TARGET_KAFKA_CLUSTER_ALIAS_FIELD, TOPIC_REPLICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("consumerGroupReplication", CONSUMER_GROUP_REPLICATION_FIELD);
                    put("sourceKafkaClusterAlias", SOURCE_KAFKA_CLUSTER_ALIAS_FIELD);
                    put("targetCompressionType", TARGET_COMPRESSION_TYPE_FIELD);
                    put("targetKafkaClusterAlias", TARGET_KAFKA_CLUSTER_ALIAS_FIELD);
                    put("topicReplication", TOPIC_REPLICATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ConsumerGroupReplication consumerGroupReplication;

    private final String sourceKafkaClusterAlias;

    private final String targetCompressionType;

    private final String targetKafkaClusterAlias;

    private final TopicReplication topicReplication;

    private ReplicationInfoDescription(BuilderImpl builder) {
        this.consumerGroupReplication = builder.consumerGroupReplication;
        this.sourceKafkaClusterAlias = builder.sourceKafkaClusterAlias;
        this.targetCompressionType = builder.targetCompressionType;
        this.targetKafkaClusterAlias = builder.targetKafkaClusterAlias;
        this.topicReplication = builder.topicReplication;
    }

    /**
     * <p>
     * Configuration relating to consumer group replication.
     * </p>
     * 
     * @return Configuration relating to consumer group replication.
     */
    public final ConsumerGroupReplication consumerGroupReplication() {
        return consumerGroupReplication;
    }

    /**
     * <p>
     * The alias of the source Kafka cluster.
     * </p>
     * 
     * @return The alias of the source Kafka cluster.
     */
    public final String sourceKafkaClusterAlias() {
        return sourceKafkaClusterAlias;
    }

    /**
     * <p>
     * The compression type to use when producing records to target cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCompressionType} will return {@link TargetCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCompressionTypeAsString}.
     * </p>
     * 
     * @return The compression type to use when producing records to target cluster.
     * @see TargetCompressionType
     */
    public final TargetCompressionType targetCompressionType() {
        return TargetCompressionType.fromValue(targetCompressionType);
    }

    /**
     * <p>
     * The compression type to use when producing records to target cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCompressionType} will return {@link TargetCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCompressionTypeAsString}.
     * </p>
     * 
     * @return The compression type to use when producing records to target cluster.
     * @see TargetCompressionType
     */
    public final String targetCompressionTypeAsString() {
        return targetCompressionType;
    }

    /**
     * <p>
     * The alias of the target Kafka cluster.
     * </p>
     * 
     * @return The alias of the target Kafka cluster.
     */
    public final String targetKafkaClusterAlias() {
        return targetKafkaClusterAlias;
    }

    /**
     * <p>
     * Configuration relating to topic replication.
     * </p>
     * 
     * @return Configuration relating to topic replication.
     */
    public final TopicReplication topicReplication() {
        return topicReplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumerGroupReplication());
        hashCode = 31 * hashCode + Objects.hashCode(sourceKafkaClusterAlias());
        hashCode = 31 * hashCode + Objects.hashCode(targetCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetKafkaClusterAlias());
        hashCode = 31 * hashCode + Objects.hashCode(topicReplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInfoDescription)) {
            return false;
        }
        ReplicationInfoDescription other = (ReplicationInfoDescription) obj;
        return Objects.equals(consumerGroupReplication(), other.consumerGroupReplication())
                && Objects.equals(sourceKafkaClusterAlias(), other.sourceKafkaClusterAlias())
                && Objects.equals(targetCompressionTypeAsString(), other.targetCompressionTypeAsString())
                && Objects.equals(targetKafkaClusterAlias(), other.targetKafkaClusterAlias())
                && Objects.equals(topicReplication(), other.topicReplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationInfoDescription").add("ConsumerGroupReplication", consumerGroupReplication())
                .add("SourceKafkaClusterAlias", sourceKafkaClusterAlias())
                .add("TargetCompressionType", targetCompressionTypeAsString())
                .add("TargetKafkaClusterAlias", targetKafkaClusterAlias()).add("TopicReplication", topicReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerGroupReplication":
            return Optional.ofNullable(clazz.cast(consumerGroupReplication()));
        case "SourceKafkaClusterAlias":
            return Optional.ofNullable(clazz.cast(sourceKafkaClusterAlias()));
        case "TargetCompressionType":
            return Optional.ofNullable(clazz.cast(targetCompressionTypeAsString()));
        case "TargetKafkaClusterAlias":
            return Optional.ofNullable(clazz.cast(targetKafkaClusterAlias()));
        case "TopicReplication":
            return Optional.ofNullable(clazz.cast(topicReplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInfoDescription, T> g) {
        return obj -> g.apply((ReplicationInfoDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationInfoDescription> {
        /**
         * <p>
         * Configuration relating to consumer group replication.
         * </p>
         * 
         * @param consumerGroupReplication
         *        Configuration relating to consumer group replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupReplication(ConsumerGroupReplication consumerGroupReplication);

        /**
         * <p>
         * Configuration relating to consumer group replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumerGroupReplication.Builder}
         * avoiding the need to create one manually via {@link ConsumerGroupReplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumerGroupReplication.Builder#build()} is called immediately
         * and its result is passed to {@link #consumerGroupReplication(ConsumerGroupReplication)}.
         * 
         * @param consumerGroupReplication
         *        a consumer that will call methods on {@link ConsumerGroupReplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumerGroupReplication(ConsumerGroupReplication)
         */
        default Builder consumerGroupReplication(Consumer<ConsumerGroupReplication.Builder> consumerGroupReplication) {
            return consumerGroupReplication(ConsumerGroupReplication.builder().applyMutation(consumerGroupReplication).build());
        }

        /**
         * <p>
         * The alias of the source Kafka cluster.
         * </p>
         * 
         * @param sourceKafkaClusterAlias
         *        The alias of the source Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceKafkaClusterAlias(String sourceKafkaClusterAlias);

        /**
         * <p>
         * The compression type to use when producing records to target cluster.
         * </p>
         * 
         * @param targetCompressionType
         *        The compression type to use when producing records to target cluster.
         * @see TargetCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCompressionType
         */
        Builder targetCompressionType(String targetCompressionType);

        /**
         * <p>
         * The compression type to use when producing records to target cluster.
         * </p>
         * 
         * @param targetCompressionType
         *        The compression type to use when producing records to target cluster.
         * @see TargetCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCompressionType
         */
        Builder targetCompressionType(TargetCompressionType targetCompressionType);

        /**
         * <p>
         * The alias of the target Kafka cluster.
         * </p>
         * 
         * @param targetKafkaClusterAlias
         *        The alias of the target Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetKafkaClusterAlias(String targetKafkaClusterAlias);

        /**
         * <p>
         * Configuration relating to topic replication.
         * </p>
         * 
         * @param topicReplication
         *        Configuration relating to topic replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicReplication(TopicReplication topicReplication);

        /**
         * <p>
         * Configuration relating to topic replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicReplication.Builder} avoiding the
         * need to create one manually via {@link TopicReplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicReplication.Builder#build()} is called immediately and its
         * result is passed to {@link #topicReplication(TopicReplication)}.
         * 
         * @param topicReplication
         *        a consumer that will call methods on {@link TopicReplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicReplication(TopicReplication)
         */
        default Builder topicReplication(Consumer<TopicReplication.Builder> topicReplication) {
            return topicReplication(TopicReplication.builder().applyMutation(topicReplication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConsumerGroupReplication consumerGroupReplication;

        private String sourceKafkaClusterAlias;

        private String targetCompressionType;

        private String targetKafkaClusterAlias;

        private TopicReplication topicReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInfoDescription model) {
            consumerGroupReplication(model.consumerGroupReplication);
            sourceKafkaClusterAlias(model.sourceKafkaClusterAlias);
            targetCompressionType(model.targetCompressionType);
            targetKafkaClusterAlias(model.targetKafkaClusterAlias);
            topicReplication(model.topicReplication);
        }

        public final ConsumerGroupReplication.Builder getConsumerGroupReplication() {
            return consumerGroupReplication != null ? consumerGroupReplication.toBuilder() : null;
        }

        public final void setConsumerGroupReplication(ConsumerGroupReplication.BuilderImpl consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication != null ? consumerGroupReplication.build() : null;
        }

        @Override
        public final Builder consumerGroupReplication(ConsumerGroupReplication consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication;
            return this;
        }

        public final String getSourceKafkaClusterAlias() {
            return sourceKafkaClusterAlias;
        }

        public final void setSourceKafkaClusterAlias(String sourceKafkaClusterAlias) {
            this.sourceKafkaClusterAlias = sourceKafkaClusterAlias;
        }

        @Override
        public final Builder sourceKafkaClusterAlias(String sourceKafkaClusterAlias) {
            this.sourceKafkaClusterAlias = sourceKafkaClusterAlias;
            return this;
        }

        public final String getTargetCompressionType() {
            return targetCompressionType;
        }

        public final void setTargetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
        }

        @Override
        public final Builder targetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
            return this;
        }

        @Override
        public final Builder targetCompressionType(TargetCompressionType targetCompressionType) {
            this.targetCompressionType(targetCompressionType == null ? null : targetCompressionType.toString());
            return this;
        }

        public final String getTargetKafkaClusterAlias() {
            return targetKafkaClusterAlias;
        }

        public final void setTargetKafkaClusterAlias(String targetKafkaClusterAlias) {
            this.targetKafkaClusterAlias = targetKafkaClusterAlias;
        }

        @Override
        public final Builder targetKafkaClusterAlias(String targetKafkaClusterAlias) {
            this.targetKafkaClusterAlias = targetKafkaClusterAlias;
            return this;
        }

        public final TopicReplication.Builder getTopicReplication() {
            return topicReplication != null ? topicReplication.toBuilder() : null;
        }

        public final void setTopicReplication(TopicReplication.BuilderImpl topicReplication) {
            this.topicReplication = topicReplication != null ? topicReplication.build() : null;
        }

        @Override
        public final Builder topicReplication(TopicReplication topicReplication) {
            this.topicReplication = topicReplication;
            return this;
        }

        @Override
        public ReplicationInfoDescription build() {
            return new ReplicationInfoDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
