/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about topic replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicReplication implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicReplication.Builder, TopicReplication> {
    private static final SdkField<Boolean> COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyAccessControlListsForTopics")
            .getter(getter(TopicReplication::copyAccessControlListsForTopics))
            .setter(setter(Builder::copyAccessControlListsForTopics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAccessControlListsForTopics")
                    .build()).build();

    private static final SdkField<Boolean> COPY_TOPIC_CONFIGURATIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTopicConfigurations").getter(getter(TopicReplication::copyTopicConfigurations))
            .setter(setter(Builder::copyTopicConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTopicConfigurations").build())
            .build();

    private static final SdkField<Boolean> DETECT_AND_COPY_NEW_TOPICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DetectAndCopyNewTopics").getter(getter(TopicReplication::detectAndCopyNewTopics))
            .setter(setter(Builder::detectAndCopyNewTopics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectAndCopyNewTopics").build())
            .build();

    private static final SdkField<ReplicationStartingPosition> STARTING_POSITION_FIELD = SdkField
            .<ReplicationStartingPosition> builder(MarshallingType.SDK_POJO).memberName("StartingPosition")
            .getter(getter(TopicReplication::startingPosition)).setter(setter(Builder::startingPosition))
            .constructor(ReplicationStartingPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startingPosition").build()).build();

    private static final SdkField<ReplicationTopicNameConfiguration> TOPIC_NAME_CONFIGURATION_FIELD = SdkField
            .<ReplicationTopicNameConfiguration> builder(MarshallingType.SDK_POJO).memberName("TopicNameConfiguration")
            .getter(getter(TopicReplication::topicNameConfiguration)).setter(setter(Builder::topicNameConfiguration))
            .constructor(ReplicationTopicNameConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicNameConfiguration").build())
            .build();

    private static final SdkField<List<String>> TOPICS_TO_EXCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TopicsToExclude")
            .getter(getter(TopicReplication::topicsToExclude))
            .setter(setter(Builder::topicsToExclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsToExclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TOPICS_TO_REPLICATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TopicsToReplicate")
            .getter(getter(TopicReplication::topicsToReplicate))
            .setter(setter(Builder::topicsToReplicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsToReplicate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD, COPY_TOPIC_CONFIGURATIONS_FIELD, DETECT_AND_COPY_NEW_TOPICS_FIELD,
            STARTING_POSITION_FIELD, TOPIC_NAME_CONFIGURATION_FIELD, TOPICS_TO_EXCLUDE_FIELD, TOPICS_TO_REPLICATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("copyAccessControlListsForTopics", COPY_ACCESS_CONTROL_LISTS_FOR_TOPICS_FIELD);
                    put("copyTopicConfigurations", COPY_TOPIC_CONFIGURATIONS_FIELD);
                    put("detectAndCopyNewTopics", DETECT_AND_COPY_NEW_TOPICS_FIELD);
                    put("startingPosition", STARTING_POSITION_FIELD);
                    put("topicNameConfiguration", TOPIC_NAME_CONFIGURATION_FIELD);
                    put("topicsToExclude", TOPICS_TO_EXCLUDE_FIELD);
                    put("topicsToReplicate", TOPICS_TO_REPLICATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean copyAccessControlListsForTopics;

    private final Boolean copyTopicConfigurations;

    private final Boolean detectAndCopyNewTopics;

    private final ReplicationStartingPosition startingPosition;

    private final ReplicationTopicNameConfiguration topicNameConfiguration;

    private final List<String> topicsToExclude;

    private final List<String> topicsToReplicate;

    private TopicReplication(BuilderImpl builder) {
        this.copyAccessControlListsForTopics = builder.copyAccessControlListsForTopics;
        this.copyTopicConfigurations = builder.copyTopicConfigurations;
        this.detectAndCopyNewTopics = builder.detectAndCopyNewTopics;
        this.startingPosition = builder.startingPosition;
        this.topicNameConfiguration = builder.topicNameConfiguration;
        this.topicsToExclude = builder.topicsToExclude;
        this.topicsToReplicate = builder.topicsToReplicate;
    }

    /**
     * <p>
     * Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
     * </p>
     * 
     * @return Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
     */
    public final Boolean copyAccessControlListsForTopics() {
        return copyAccessControlListsForTopics;
    }

    /**
     * <p>
     * Whether to periodically configure remote topics to match their corresponding upstream topics.
     * </p>
     * 
     * @return Whether to periodically configure remote topics to match their corresponding upstream topics.
     */
    public final Boolean copyTopicConfigurations() {
        return copyTopicConfigurations;
    }

    /**
     * <p>
     * Whether to periodically check for new topics and partitions.
     * </p>
     * 
     * @return Whether to periodically check for new topics and partitions.
     */
    public final Boolean detectAndCopyNewTopics() {
        return detectAndCopyNewTopics;
    }

    /**
     * <p>
     * Configuration for specifying the position in the topics to start replicating from.
     * </p>
     * 
     * @return Configuration for specifying the position in the topics to start replicating from.
     */
    public final ReplicationStartingPosition startingPosition() {
        return startingPosition;
    }

    /**
     * <p>
     * Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or
     * prefixed with source cluster alias.
     * </p>
     * 
     * @return Configuration for specifying replicated topic names should be the same as their corresponding upstream
     *         topics or prefixed with source cluster alias.
     */
    public final ReplicationTopicNameConfiguration topicNameConfiguration() {
        return topicNameConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicsToExclude property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopicsToExclude() {
        return topicsToExclude != null && !(topicsToExclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of regular expression patterns indicating the topics that should not be replicated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicsToExclude} method.
     * </p>
     * 
     * @return List of regular expression patterns indicating the topics that should not be replicated.
     */
    public final List<String> topicsToExclude() {
        return topicsToExclude;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicsToReplicate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopicsToReplicate() {
        return topicsToReplicate != null && !(topicsToReplicate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of regular expression patterns indicating the topics to copy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicsToReplicate} method.
     * </p>
     * 
     * @return List of regular expression patterns indicating the topics to copy.
     */
    public final List<String> topicsToReplicate() {
        return topicsToReplicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(copyAccessControlListsForTopics());
        hashCode = 31 * hashCode + Objects.hashCode(copyTopicConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(detectAndCopyNewTopics());
        hashCode = 31 * hashCode + Objects.hashCode(startingPosition());
        hashCode = 31 * hashCode + Objects.hashCode(topicNameConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicsToExclude() ? topicsToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicsToReplicate() ? topicsToReplicate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicReplication)) {
            return false;
        }
        TopicReplication other = (TopicReplication) obj;
        return Objects.equals(copyAccessControlListsForTopics(), other.copyAccessControlListsForTopics())
                && Objects.equals(copyTopicConfigurations(), other.copyTopicConfigurations())
                && Objects.equals(detectAndCopyNewTopics(), other.detectAndCopyNewTopics())
                && Objects.equals(startingPosition(), other.startingPosition())
                && Objects.equals(topicNameConfiguration(), other.topicNameConfiguration())
                && hasTopicsToExclude() == other.hasTopicsToExclude()
                && Objects.equals(topicsToExclude(), other.topicsToExclude())
                && hasTopicsToReplicate() == other.hasTopicsToReplicate()
                && Objects.equals(topicsToReplicate(), other.topicsToReplicate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicReplication").add("CopyAccessControlListsForTopics", copyAccessControlListsForTopics())
                .add("CopyTopicConfigurations", copyTopicConfigurations())
                .add("DetectAndCopyNewTopics", detectAndCopyNewTopics()).add("StartingPosition", startingPosition())
                .add("TopicNameConfiguration", topicNameConfiguration())
                .add("TopicsToExclude", hasTopicsToExclude() ? topicsToExclude() : null)
                .add("TopicsToReplicate", hasTopicsToReplicate() ? topicsToReplicate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyAccessControlListsForTopics":
            return Optional.ofNullable(clazz.cast(copyAccessControlListsForTopics()));
        case "CopyTopicConfigurations":
            return Optional.ofNullable(clazz.cast(copyTopicConfigurations()));
        case "DetectAndCopyNewTopics":
            return Optional.ofNullable(clazz.cast(detectAndCopyNewTopics()));
        case "StartingPosition":
            return Optional.ofNullable(clazz.cast(startingPosition()));
        case "TopicNameConfiguration":
            return Optional.ofNullable(clazz.cast(topicNameConfiguration()));
        case "TopicsToExclude":
            return Optional.ofNullable(clazz.cast(topicsToExclude()));
        case "TopicsToReplicate":
            return Optional.ofNullable(clazz.cast(topicsToReplicate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopicReplication, T> g) {
        return obj -> g.apply((TopicReplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicReplication> {
        /**
         * <p>
         * Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
         * </p>
         * 
         * @param copyAccessControlListsForTopics
         *        Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyAccessControlListsForTopics(Boolean copyAccessControlListsForTopics);

        /**
         * <p>
         * Whether to periodically configure remote topics to match their corresponding upstream topics.
         * </p>
         * 
         * @param copyTopicConfigurations
         *        Whether to periodically configure remote topics to match their corresponding upstream topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTopicConfigurations(Boolean copyTopicConfigurations);

        /**
         * <p>
         * Whether to periodically check for new topics and partitions.
         * </p>
         * 
         * @param detectAndCopyNewTopics
         *        Whether to periodically check for new topics and partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectAndCopyNewTopics(Boolean detectAndCopyNewTopics);

        /**
         * <p>
         * Configuration for specifying the position in the topics to start replicating from.
         * </p>
         * 
         * @param startingPosition
         *        Configuration for specifying the position in the topics to start replicating from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingPosition(ReplicationStartingPosition startingPosition);

        /**
         * <p>
         * Configuration for specifying the position in the topics to start replicating from.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationStartingPosition.Builder}
         * avoiding the need to create one manually via {@link ReplicationStartingPosition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationStartingPosition.Builder#build()} is called
         * immediately and its result is passed to {@link #startingPosition(ReplicationStartingPosition)}.
         * 
         * @param startingPosition
         *        a consumer that will call methods on {@link ReplicationStartingPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startingPosition(ReplicationStartingPosition)
         */
        default Builder startingPosition(Consumer<ReplicationStartingPosition.Builder> startingPosition) {
            return startingPosition(ReplicationStartingPosition.builder().applyMutation(startingPosition).build());
        }

        /**
         * <p>
         * Configuration for specifying replicated topic names should be the same as their corresponding upstream topics
         * or prefixed with source cluster alias.
         * </p>
         * 
         * @param topicNameConfiguration
         *        Configuration for specifying replicated topic names should be the same as their corresponding upstream
         *        topics or prefixed with source cluster alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicNameConfiguration(ReplicationTopicNameConfiguration topicNameConfiguration);

        /**
         * <p>
         * Configuration for specifying replicated topic names should be the same as their corresponding upstream topics
         * or prefixed with source cluster alias.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReplicationTopicNameConfiguration.Builder} avoiding the need to create one manually via
         * {@link ReplicationTopicNameConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationTopicNameConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #topicNameConfiguration(ReplicationTopicNameConfiguration)}.
         * 
         * @param topicNameConfiguration
         *        a consumer that will call methods on {@link ReplicationTopicNameConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicNameConfiguration(ReplicationTopicNameConfiguration)
         */
        default Builder topicNameConfiguration(Consumer<ReplicationTopicNameConfiguration.Builder> topicNameConfiguration) {
            return topicNameConfiguration(ReplicationTopicNameConfiguration.builder().applyMutation(topicNameConfiguration)
                    .build());
        }

        /**
         * <p>
         * List of regular expression patterns indicating the topics that should not be replicated.
         * </p>
         * 
         * @param topicsToExclude
         *        List of regular expression patterns indicating the topics that should not be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsToExclude(Collection<String> topicsToExclude);

        /**
         * <p>
         * List of regular expression patterns indicating the topics that should not be replicated.
         * </p>
         * 
         * @param topicsToExclude
         *        List of regular expression patterns indicating the topics that should not be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsToExclude(String... topicsToExclude);

        /**
         * <p>
         * List of regular expression patterns indicating the topics to copy.
         * </p>
         * 
         * @param topicsToReplicate
         *        List of regular expression patterns indicating the topics to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsToReplicate(Collection<String> topicsToReplicate);

        /**
         * <p>
         * List of regular expression patterns indicating the topics to copy.
         * </p>
         * 
         * @param topicsToReplicate
         *        List of regular expression patterns indicating the topics to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsToReplicate(String... topicsToReplicate);
    }

    static final class BuilderImpl implements Builder {
        private Boolean copyAccessControlListsForTopics;

        private Boolean copyTopicConfigurations;

        private Boolean detectAndCopyNewTopics;

        private ReplicationStartingPosition startingPosition;

        private ReplicationTopicNameConfiguration topicNameConfiguration;

        private List<String> topicsToExclude = DefaultSdkAutoConstructList.getInstance();

        private List<String> topicsToReplicate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicReplication model) {
            copyAccessControlListsForTopics(model.copyAccessControlListsForTopics);
            copyTopicConfigurations(model.copyTopicConfigurations);
            detectAndCopyNewTopics(model.detectAndCopyNewTopics);
            startingPosition(model.startingPosition);
            topicNameConfiguration(model.topicNameConfiguration);
            topicsToExclude(model.topicsToExclude);
            topicsToReplicate(model.topicsToReplicate);
        }

        public final Boolean getCopyAccessControlListsForTopics() {
            return copyAccessControlListsForTopics;
        }

        public final void setCopyAccessControlListsForTopics(Boolean copyAccessControlListsForTopics) {
            this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
        }

        @Override
        public final Builder copyAccessControlListsForTopics(Boolean copyAccessControlListsForTopics) {
            this.copyAccessControlListsForTopics = copyAccessControlListsForTopics;
            return this;
        }

        public final Boolean getCopyTopicConfigurations() {
            return copyTopicConfigurations;
        }

        public final void setCopyTopicConfigurations(Boolean copyTopicConfigurations) {
            this.copyTopicConfigurations = copyTopicConfigurations;
        }

        @Override
        public final Builder copyTopicConfigurations(Boolean copyTopicConfigurations) {
            this.copyTopicConfigurations = copyTopicConfigurations;
            return this;
        }

        public final Boolean getDetectAndCopyNewTopics() {
            return detectAndCopyNewTopics;
        }

        public final void setDetectAndCopyNewTopics(Boolean detectAndCopyNewTopics) {
            this.detectAndCopyNewTopics = detectAndCopyNewTopics;
        }

        @Override
        public final Builder detectAndCopyNewTopics(Boolean detectAndCopyNewTopics) {
            this.detectAndCopyNewTopics = detectAndCopyNewTopics;
            return this;
        }

        public final ReplicationStartingPosition.Builder getStartingPosition() {
            return startingPosition != null ? startingPosition.toBuilder() : null;
        }

        public final void setStartingPosition(ReplicationStartingPosition.BuilderImpl startingPosition) {
            this.startingPosition = startingPosition != null ? startingPosition.build() : null;
        }

        @Override
        public final Builder startingPosition(ReplicationStartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public final ReplicationTopicNameConfiguration.Builder getTopicNameConfiguration() {
            return topicNameConfiguration != null ? topicNameConfiguration.toBuilder() : null;
        }

        public final void setTopicNameConfiguration(ReplicationTopicNameConfiguration.BuilderImpl topicNameConfiguration) {
            this.topicNameConfiguration = topicNameConfiguration != null ? topicNameConfiguration.build() : null;
        }

        @Override
        public final Builder topicNameConfiguration(ReplicationTopicNameConfiguration topicNameConfiguration) {
            this.topicNameConfiguration = topicNameConfiguration;
            return this;
        }

        public final Collection<String> getTopicsToExclude() {
            if (topicsToExclude instanceof SdkAutoConstructList) {
                return null;
            }
            return topicsToExclude;
        }

        public final void setTopicsToExclude(Collection<String> topicsToExclude) {
            this.topicsToExclude = ___listOf__stringMax249Copier.copy(topicsToExclude);
        }

        @Override
        public final Builder topicsToExclude(Collection<String> topicsToExclude) {
            this.topicsToExclude = ___listOf__stringMax249Copier.copy(topicsToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsToExclude(String... topicsToExclude) {
            topicsToExclude(Arrays.asList(topicsToExclude));
            return this;
        }

        public final Collection<String> getTopicsToReplicate() {
            if (topicsToReplicate instanceof SdkAutoConstructList) {
                return null;
            }
            return topicsToReplicate;
        }

        public final void setTopicsToReplicate(Collection<String> topicsToReplicate) {
            this.topicsToReplicate = ___listOf__stringMax249Copier.copy(topicsToReplicate);
        }

        @Override
        public final Builder topicsToReplicate(Collection<String> topicsToReplicate) {
            this.topicsToReplicate = ___listOf__stringMax249Copier.copy(topicsToReplicate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsToReplicate(String... topicsToReplicate) {
            topicsToReplicate(Arrays.asList(topicsToReplicate));
            return this;
        }

        @Override
        public TopicReplication build() {
            return new TopicReplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
