/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update information relating to replication between a given source and target Kafka cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReplicationInfoRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateReplicationInfoRequest.Builder, UpdateReplicationInfoRequest> {
    private static final SdkField<ConsumerGroupReplicationUpdate> CONSUMER_GROUP_REPLICATION_FIELD = SdkField
            .<ConsumerGroupReplicationUpdate> builder(MarshallingType.SDK_POJO).memberName("ConsumerGroupReplication")
            .getter(getter(UpdateReplicationInfoRequest::consumerGroupReplication))
            .setter(setter(Builder::consumerGroupReplication)).constructor(ConsumerGroupReplicationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupReplication").build())
            .build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateReplicationInfoRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorArn").getter(getter(UpdateReplicationInfoRequest::replicatorArn))
            .setter(setter(Builder::replicatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("replicatorArn").build()).build();

    private static final SdkField<String> SOURCE_KAFKA_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceKafkaClusterArn").getter(getter(UpdateReplicationInfoRequest::sourceKafkaClusterArn))
            .setter(setter(Builder::sourceKafkaClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKafkaClusterArn").build())
            .build();

    private static final SdkField<String> TARGET_KAFKA_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetKafkaClusterArn").getter(getter(UpdateReplicationInfoRequest::targetKafkaClusterArn))
            .setter(setter(Builder::targetKafkaClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKafkaClusterArn").build())
            .build();

    private static final SdkField<TopicReplicationUpdate> TOPIC_REPLICATION_FIELD = SdkField
            .<TopicReplicationUpdate> builder(MarshallingType.SDK_POJO).memberName("TopicReplication")
            .getter(getter(UpdateReplicationInfoRequest::topicReplication)).setter(setter(Builder::topicReplication))
            .constructor(TopicReplicationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicReplication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSUMER_GROUP_REPLICATION_FIELD, CURRENT_VERSION_FIELD, REPLICATOR_ARN_FIELD, SOURCE_KAFKA_CLUSTER_ARN_FIELD,
            TARGET_KAFKA_CLUSTER_ARN_FIELD, TOPIC_REPLICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("consumerGroupReplication", CONSUMER_GROUP_REPLICATION_FIELD);
                    put("currentVersion", CURRENT_VERSION_FIELD);
                    put("replicatorArn", REPLICATOR_ARN_FIELD);
                    put("sourceKafkaClusterArn", SOURCE_KAFKA_CLUSTER_ARN_FIELD);
                    put("targetKafkaClusterArn", TARGET_KAFKA_CLUSTER_ARN_FIELD);
                    put("topicReplication", TOPIC_REPLICATION_FIELD);
                }
            });

    private final ConsumerGroupReplicationUpdate consumerGroupReplication;

    private final String currentVersion;

    private final String replicatorArn;

    private final String sourceKafkaClusterArn;

    private final String targetKafkaClusterArn;

    private final TopicReplicationUpdate topicReplication;

    private UpdateReplicationInfoRequest(BuilderImpl builder) {
        super(builder);
        this.consumerGroupReplication = builder.consumerGroupReplication;
        this.currentVersion = builder.currentVersion;
        this.replicatorArn = builder.replicatorArn;
        this.sourceKafkaClusterArn = builder.sourceKafkaClusterArn;
        this.targetKafkaClusterArn = builder.targetKafkaClusterArn;
        this.topicReplication = builder.topicReplication;
    }

    /**
     * <p>
     * Updated consumer group replication information.
     * </p>
     * 
     * @return Updated consumer group replication information.
     */
    public final ConsumerGroupReplicationUpdate consumerGroupReplication() {
        return consumerGroupReplication;
    }

    /**
     * <p>
     * Current replicator version.
     * </p>
     * 
     * @return Current replicator version.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator to be updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator to be updated.
     */
    public final String replicatorArn() {
        return replicatorArn;
    }

    /**
     * <p>
     * The ARN of the source Kafka cluster.
     * </p>
     * 
     * @return The ARN of the source Kafka cluster.
     */
    public final String sourceKafkaClusterArn() {
        return sourceKafkaClusterArn;
    }

    /**
     * <p>
     * The ARN of the target Kafka cluster.
     * </p>
     * 
     * @return The ARN of the target Kafka cluster.
     */
    public final String targetKafkaClusterArn() {
        return targetKafkaClusterArn;
    }

    /**
     * <p>
     * Updated topic replication information.
     * </p>
     * 
     * @return Updated topic replication information.
     */
    public final TopicReplicationUpdate topicReplication() {
        return topicReplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumerGroupReplication());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(topicReplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationInfoRequest)) {
            return false;
        }
        UpdateReplicationInfoRequest other = (UpdateReplicationInfoRequest) obj;
        return Objects.equals(consumerGroupReplication(), other.consumerGroupReplication())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(replicatorArn(), other.replicatorArn())
                && Objects.equals(sourceKafkaClusterArn(), other.sourceKafkaClusterArn())
                && Objects.equals(targetKafkaClusterArn(), other.targetKafkaClusterArn())
                && Objects.equals(topicReplication(), other.topicReplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReplicationInfoRequest").add("ConsumerGroupReplication", consumerGroupReplication())
                .add("CurrentVersion", currentVersion()).add("ReplicatorArn", replicatorArn())
                .add("SourceKafkaClusterArn", sourceKafkaClusterArn()).add("TargetKafkaClusterArn", targetKafkaClusterArn())
                .add("TopicReplication", topicReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerGroupReplication":
            return Optional.ofNullable(clazz.cast(consumerGroupReplication()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "ReplicatorArn":
            return Optional.ofNullable(clazz.cast(replicatorArn()));
        case "SourceKafkaClusterArn":
            return Optional.ofNullable(clazz.cast(sourceKafkaClusterArn()));
        case "TargetKafkaClusterArn":
            return Optional.ofNullable(clazz.cast(targetKafkaClusterArn()));
        case "TopicReplication":
            return Optional.ofNullable(clazz.cast(topicReplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationInfoRequest, T> g) {
        return obj -> g.apply((UpdateReplicationInfoRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateReplicationInfoRequest> {
        /**
         * <p>
         * Updated consumer group replication information.
         * </p>
         * 
         * @param consumerGroupReplication
         *        Updated consumer group replication information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupReplication(ConsumerGroupReplicationUpdate consumerGroupReplication);

        /**
         * <p>
         * Updated consumer group replication information.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumerGroupReplicationUpdate.Builder}
         * avoiding the need to create one manually via {@link ConsumerGroupReplicationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumerGroupReplicationUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #consumerGroupReplication(ConsumerGroupReplicationUpdate)}.
         * 
         * @param consumerGroupReplication
         *        a consumer that will call methods on {@link ConsumerGroupReplicationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumerGroupReplication(ConsumerGroupReplicationUpdate)
         */
        default Builder consumerGroupReplication(Consumer<ConsumerGroupReplicationUpdate.Builder> consumerGroupReplication) {
            return consumerGroupReplication(ConsumerGroupReplicationUpdate.builder().applyMutation(consumerGroupReplication)
                    .build());
        }

        /**
         * <p>
         * Current replicator version.
         * </p>
         * 
         * @param currentVersion
         *        Current replicator version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator to be updated.
         * </p>
         * 
         * @param replicatorArn
         *        The Amazon Resource Name (ARN) of the replicator to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorArn(String replicatorArn);

        /**
         * <p>
         * The ARN of the source Kafka cluster.
         * </p>
         * 
         * @param sourceKafkaClusterArn
         *        The ARN of the source Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceKafkaClusterArn(String sourceKafkaClusterArn);

        /**
         * <p>
         * The ARN of the target Kafka cluster.
         * </p>
         * 
         * @param targetKafkaClusterArn
         *        The ARN of the target Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetKafkaClusterArn(String targetKafkaClusterArn);

        /**
         * <p>
         * Updated topic replication information.
         * </p>
         * 
         * @param topicReplication
         *        Updated topic replication information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicReplication(TopicReplicationUpdate topicReplication);

        /**
         * <p>
         * Updated topic replication information.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicReplicationUpdate.Builder} avoiding
         * the need to create one manually via {@link TopicReplicationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicReplicationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #topicReplication(TopicReplicationUpdate)}.
         * 
         * @param topicReplication
         *        a consumer that will call methods on {@link TopicReplicationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicReplication(TopicReplicationUpdate)
         */
        default Builder topicReplication(Consumer<TopicReplicationUpdate.Builder> topicReplication) {
            return topicReplication(TopicReplicationUpdate.builder().applyMutation(topicReplication).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private ConsumerGroupReplicationUpdate consumerGroupReplication;

        private String currentVersion;

        private String replicatorArn;

        private String sourceKafkaClusterArn;

        private String targetKafkaClusterArn;

        private TopicReplicationUpdate topicReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationInfoRequest model) {
            super(model);
            consumerGroupReplication(model.consumerGroupReplication);
            currentVersion(model.currentVersion);
            replicatorArn(model.replicatorArn);
            sourceKafkaClusterArn(model.sourceKafkaClusterArn);
            targetKafkaClusterArn(model.targetKafkaClusterArn);
            topicReplication(model.topicReplication);
        }

        public final ConsumerGroupReplicationUpdate.Builder getConsumerGroupReplication() {
            return consumerGroupReplication != null ? consumerGroupReplication.toBuilder() : null;
        }

        public final void setConsumerGroupReplication(ConsumerGroupReplicationUpdate.BuilderImpl consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication != null ? consumerGroupReplication.build() : null;
        }

        @Override
        public final Builder consumerGroupReplication(ConsumerGroupReplicationUpdate consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getReplicatorArn() {
            return replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getSourceKafkaClusterArn() {
            return sourceKafkaClusterArn;
        }

        public final void setSourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
        }

        @Override
        public final Builder sourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
            return this;
        }

        public final String getTargetKafkaClusterArn() {
            return targetKafkaClusterArn;
        }

        public final void setTargetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
        }

        @Override
        public final Builder targetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
            return this;
        }

        public final TopicReplicationUpdate.Builder getTopicReplication() {
            return topicReplication != null ? topicReplication.toBuilder() : null;
        }

        public final void setTopicReplication(TopicReplicationUpdate.BuilderImpl topicReplication) {
            this.topicReplication = topicReplication != null ? topicReplication.build() : null;
        }

        @Override
        public final Builder topicReplication(TopicReplicationUpdate topicReplication) {
            this.topicReplication = topicReplication;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReplicationInfoRequest build() {
            return new UpdateReplicationInfoRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
