/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Description of the VPC connection.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConnectionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConnectionInfo.Builder, VpcConnectionInfo> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectionArn").getter(getter(VpcConnectionInfo::vpcConnectionArn))
            .setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(VpcConnectionInfo::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<UserIdentity> USER_IDENTITY_FIELD = SdkField.<UserIdentity> builder(MarshallingType.SDK_POJO)
            .memberName("UserIdentity").getter(getter(VpcConnectionInfo::userIdentity)).setter(setter(Builder::userIdentity))
            .constructor(UserIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentity").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(VpcConnectionInfo::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD,
            OWNER_FIELD, USER_IDENTITY_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
                    put("owner", OWNER_FIELD);
                    put("userIdentity", USER_IDENTITY_FIELD);
                    put("creationTime", CREATION_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String vpcConnectionArn;

    private final String owner;

    private final UserIdentity userIdentity;

    private final Instant creationTime;

    private VpcConnectionInfo(BuilderImpl builder) {
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.owner = builder.owner;
        this.userIdentity = builder.userIdentity;
        this.creationTime = builder.creationTime;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the VPC connection.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the VPC connection.
     *         </p>
     */
    public final String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    /**
     *
     * <p>
     * The owner of the VPC Connection.
     * </p>
     * 
     * @return <p>
     *         The owner of the VPC Connection.
     *         </p>
     */
    public final String owner() {
        return owner;
    }

    /**
     *
     * <p>
     * Description of the requester that calls the API operation.
     * </p>
     * 
     * @return <p>
     *         Description of the requester that calls the API operation.
     *         </p>
     */
    public final UserIdentity userIdentity() {
        return userIdentity;
    }

    /**
     *
     * <p>
     * The time when Amazon MSK creates the VPC Connnection.
     * </p>
     * 
     * @return <p>
     *         The time when Amazon MSK creates the VPC Connnection.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(userIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnectionInfo)) {
            return false;
        }
        VpcConnectionInfo other = (VpcConnectionInfo) obj;
        return Objects.equals(vpcConnectionArn(), other.vpcConnectionArn()) && Objects.equals(owner(), other.owner())
                && Objects.equals(userIdentity(), other.userIdentity()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConnectionInfo").add("VpcConnectionArn", vpcConnectionArn()).add("Owner", owner())
                .add("UserIdentity", userIdentity()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "UserIdentity":
            return Optional.ofNullable(clazz.cast(userIdentity()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcConnectionInfo, T> g) {
        return obj -> g.apply((VpcConnectionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConnectionInfo> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the VPC connection.
         * </p>
         * 
         * @param vpcConnectionArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);

        /**
         *
         * <p>
         * The owner of the VPC Connection.
         * </p>
         * 
         * @param owner
         *        <p>
         *        The owner of the VPC Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         *
         * <p>
         * Description of the requester that calls the API operation.
         * </p>
         * 
         * @param userIdentity
         *        <p>
         *        Description of the requester that calls the API operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdentity(UserIdentity userIdentity);

        /**
         *
         * <p>
         * Description of the requester that calls the API operation.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link UserIdentity.Builder} avoiding the need
         * to create one manually via {@link UserIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #userIdentity(UserIdentity)}.
         * 
         * @param userIdentity
         *        a consumer that will call methods on {@link UserIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userIdentity(UserIdentity)
         */
        default Builder userIdentity(Consumer<UserIdentity.Builder> userIdentity) {
            return userIdentity(UserIdentity.builder().applyMutation(userIdentity).build());
        }

        /**
         *
         * <p>
         * The time when Amazon MSK creates the VPC Connnection.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time when Amazon MSK creates the VPC Connnection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String vpcConnectionArn;

        private String owner;

        private UserIdentity userIdentity;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnectionInfo model) {
            vpcConnectionArn(model.vpcConnectionArn);
            owner(model.owner);
            userIdentity(model.userIdentity);
            creationTime(model.creationTime);
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final UserIdentity.Builder getUserIdentity() {
            return userIdentity != null ? userIdentity.toBuilder() : null;
        }

        public final void setUserIdentity(UserIdentity.BuilderImpl userIdentity) {
            this.userIdentity = userIdentity != null ? userIdentity.build() : null;
        }

        @Override
        public final Builder userIdentity(UserIdentity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public VpcConnectionInfo build() {
            return new VpcConnectionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
