/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateScramSecretRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, BatchAssociateScramSecretRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(BatchAssociateScramSecretRequest.getter(BatchAssociateScramSecretRequest::clusterArn)).setter(BatchAssociateScramSecretRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<List<String>> SECRET_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecretArnList").getter(BatchAssociateScramSecretRequest.getter(BatchAssociateScramSecretRequest::secretArnList)).setter(BatchAssociateScramSecretRequest.setter(Builder::secretArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, SECRET_ARN_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAssociateScramSecretRequest.memberNameToFieldInitializer();
    private final String clusterArn;
    private final List<String> secretArnList;

    private BatchAssociateScramSecretRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.secretArnList = builder.secretArnList;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final boolean hasSecretArnList() {
        return this.secretArnList != null && !(this.secretArnList instanceof SdkAutoConstructList);
    }

    public final List<String> secretArnList() {
        return this.secretArnList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecretArnList() ? this.secretArnList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateScramSecretRequest)) {
            return false;
        }
        BatchAssociateScramSecretRequest other = (BatchAssociateScramSecretRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && this.hasSecretArnList() == other.hasSecretArnList() && Objects.equals(this.secretArnList(), other.secretArnList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateScramSecretRequest").add("ClusterArn", (Object)this.clusterArn()).add("SecretArnList", this.hasSecretArnList() ? this.secretArnList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "SecretArnList": {
                return Optional.ofNullable(clazz.cast(this.secretArnList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("secretArnList", SECRET_ARN_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateScramSecretRequest, T> g) {
        return obj -> g.apply((BatchAssociateScramSecretRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private List<String> secretArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateScramSecretRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.secretArnList(model.secretArnList);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Collection<String> getSecretArnList() {
            if (this.secretArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.secretArnList;
        }

        public final void setSecretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
        }

        @Override
        public final Builder secretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretArnList(String ... secretArnList) {
            this.secretArnList(Arrays.asList(secretArnList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateScramSecretRequest build() {
            return new BatchAssociateScramSecretRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateScramSecretRequest> {
        public Builder clusterArn(String var1);

        public Builder secretArnList(Collection<String> var1);

        public Builder secretArnList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

