/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ClusterInfo;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.___listOfClusterInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private static final SdkField<List<ClusterInfo>> CLUSTER_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterInfoList").getter(ListClustersResponse.getter(ListClustersResponse::clusterInfoList)).setter(ListClustersResponse.setter(Builder::clusterInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClustersResponse.getter(ListClustersResponse::nextToken)).setter(ListClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListClustersResponse.memberNameToFieldInitializer();
    private final List<ClusterInfo> clusterInfoList;
    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusterInfoList = builder.clusterInfoList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClusterInfoList() {
        return this.clusterInfoList != null && !(this.clusterInfoList instanceof SdkAutoConstructList);
    }

    public final List<ClusterInfo> clusterInfoList() {
        return this.clusterInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterInfoList() ? this.clusterInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        return this.hasClusterInfoList() == other.hasClusterInfoList() && Objects.equals(this.clusterInfoList(), other.clusterInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClustersResponse").add("ClusterInfoList", this.hasClusterInfoList() ? this.clusterInfoList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterInfoList": {
                return Optional.ofNullable(clazz.cast(this.clusterInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterInfoList", CLUSTER_INFO_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private List<ClusterInfo> clusterInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            this.clusterInfoList(model.clusterInfoList);
            this.nextToken(model.nextToken);
        }

        public final List<ClusterInfo.Builder> getClusterInfoList() {
            List<ClusterInfo.Builder> result = ___listOfClusterInfoCopier.copyToBuilder(this.clusterInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterInfoList(Collection<ClusterInfo.BuilderImpl> clusterInfoList) {
            this.clusterInfoList = ___listOfClusterInfoCopier.copyFromBuilder(clusterInfoList);
        }

        @Override
        public final Builder clusterInfoList(Collection<ClusterInfo> clusterInfoList) {
            this.clusterInfoList = ___listOfClusterInfoCopier.copy(clusterInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterInfoList(ClusterInfo ... clusterInfoList) {
            this.clusterInfoList(Arrays.asList(clusterInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterInfoList(Consumer<ClusterInfo.Builder> ... clusterInfoList) {
            this.clusterInfoList(Stream.of(clusterInfoList).map(c -> (ClusterInfo)((ClusterInfo.Builder)ClusterInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClustersResponse> {
        public Builder clusterInfoList(Collection<ClusterInfo> var1);

        public Builder clusterInfoList(ClusterInfo ... var1);

        public Builder clusterInfoList(Consumer<ClusterInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

