/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Information about the current software installed on the cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerSoftwareInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerSoftwareInfo.Builder, BrokerSoftwareInfo> {
    private static final SdkField<String> CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationArn").getter(getter(BrokerSoftwareInfo::configurationArn))
            .setter(setter(Builder::configurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationArn").build()).build();

    private static final SdkField<Long> CONFIGURATION_REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ConfigurationRevision").getter(getter(BrokerSoftwareInfo::configurationRevision))
            .setter(setter(Builder::configurationRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationRevision").build())
            .build();

    private static final SdkField<String> KAFKA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KafkaVersion").getter(getter(BrokerSoftwareInfo::kafkaVersion)).setter(setter(Builder::kafkaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ARN_FIELD,
            CONFIGURATION_REVISION_FIELD, KAFKA_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationArn;

    private final Long configurationRevision;

    private final String kafkaVersion;

    private BrokerSoftwareInfo(BuilderImpl builder) {
        this.configurationArn = builder.configurationArn;
        this.configurationRevision = builder.configurationRevision;
        this.kafkaVersion = builder.kafkaVersion;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the configuration used for the cluster. This field isn't visible in this
     * preview release.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the configuration used for the cluster. This field isn't visible in
     *         this preview release.
     *         </p>
     */
    public final String configurationArn() {
        return configurationArn;
    }

    /**
     *
     * <p>
     * The revision of the configuration to use. This field isn't visible in this preview release.
     * </p>
     * 
     * @return <p>
     *         The revision of the configuration to use. This field isn't visible in this preview release.
     *         </p>
     */
    public final Long configurationRevision() {
        return configurationRevision;
    }

    /**
     *
     * <p>
     * The version of Apache Kafka.
     * </p>
     * 
     * @return <p>
     *         The version of Apache Kafka.
     *         </p>
     */
    public final String kafkaVersion() {
        return kafkaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationRevision());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerSoftwareInfo)) {
            return false;
        }
        BrokerSoftwareInfo other = (BrokerSoftwareInfo) obj;
        return Objects.equals(configurationArn(), other.configurationArn())
                && Objects.equals(configurationRevision(), other.configurationRevision())
                && Objects.equals(kafkaVersion(), other.kafkaVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerSoftwareInfo").add("ConfigurationArn", configurationArn())
                .add("ConfigurationRevision", configurationRevision()).add("KafkaVersion", kafkaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationArn":
            return Optional.ofNullable(clazz.cast(configurationArn()));
        case "ConfigurationRevision":
            return Optional.ofNullable(clazz.cast(configurationRevision()));
        case "KafkaVersion":
            return Optional.ofNullable(clazz.cast(kafkaVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configurationArn", CONFIGURATION_ARN_FIELD);
        map.put("configurationRevision", CONFIGURATION_REVISION_FIELD);
        map.put("kafkaVersion", KAFKA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrokerSoftwareInfo, T> g) {
        return obj -> g.apply((BrokerSoftwareInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerSoftwareInfo> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the configuration used for the cluster. This field isn't visible in this
         * preview release.
         * </p>
         * 
         * @param configurationArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the configuration used for the cluster. This field isn't visible in
         *        this preview release.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationArn(String configurationArn);

        /**
         *
         * <p>
         * The revision of the configuration to use. This field isn't visible in this preview release.
         * </p>
         * 
         * @param configurationRevision
         *        <p>
         *        The revision of the configuration to use. This field isn't visible in this preview release.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRevision(Long configurationRevision);

        /**
         *
         * <p>
         * The version of Apache Kafka.
         * </p>
         * 
         * @param kafkaVersion
         *        <p>
         *        The version of Apache Kafka.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersion(String kafkaVersion);
    }

    static final class BuilderImpl implements Builder {
        private String configurationArn;

        private Long configurationRevision;

        private String kafkaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerSoftwareInfo model) {
            configurationArn(model.configurationArn);
            configurationRevision(model.configurationRevision);
            kafkaVersion(model.kafkaVersion);
        }

        public final String getConfigurationArn() {
            return configurationArn;
        }

        public final void setConfigurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
        }

        @Override
        public final Builder configurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
            return this;
        }

        public final Long getConfigurationRevision() {
            return configurationRevision;
        }

        public final void setConfigurationRevision(Long configurationRevision) {
            this.configurationRevision = configurationRevision;
        }

        @Override
        public final Builder configurationRevision(Long configurationRevision) {
            this.configurationRevision = configurationRevision;
            return this;
        }

        public final String getKafkaVersion() {
            return kafkaVersion;
        }

        public final void setKafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
        }

        @Override
        public final Builder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        @Override
        public BrokerSoftwareInfo build() {
            return new BrokerSoftwareInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
