/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKafkaVersionsResponse extends KafkaResponse implements
        ToCopyableBuilder<ListKafkaVersionsResponse.Builder, ListKafkaVersionsResponse> {
    private static final SdkField<List<KafkaVersion>> KAFKA_VERSIONS_FIELD = SdkField
            .<List<KafkaVersion>> builder(MarshallingType.LIST)
            .memberName("KafkaVersions")
            .getter(getter(ListKafkaVersionsResponse::kafkaVersions))
            .setter(setter(Builder::kafkaVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KafkaVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(KafkaVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListKafkaVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KAFKA_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<KafkaVersion> kafkaVersions;

    private final String nextToken;

    private ListKafkaVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.kafkaVersions = builder.kafkaVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the KafkaVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKafkaVersions() {
        return kafkaVersions != null && !(kafkaVersions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the KafkaVersions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKafkaVersions} method.
     * </p>
     * 
     * @return The value of the KafkaVersions property for this object.
     */
    public final List<KafkaVersion> kafkaVersions() {
        return kafkaVersions;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasKafkaVersions() ? kafkaVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKafkaVersionsResponse)) {
            return false;
        }
        ListKafkaVersionsResponse other = (ListKafkaVersionsResponse) obj;
        return hasKafkaVersions() == other.hasKafkaVersions() && Objects.equals(kafkaVersions(), other.kafkaVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKafkaVersionsResponse").add("KafkaVersions", hasKafkaVersions() ? kafkaVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KafkaVersions":
            return Optional.ofNullable(clazz.cast(kafkaVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kafkaVersions", KAFKA_VERSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKafkaVersionsResponse, T> g) {
        return obj -> g.apply((ListKafkaVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKafkaVersionsResponse> {
        /**
         * Sets the value of the KafkaVersions property for this object.
         *
         * @param kafkaVersions
         *        The new value for the KafkaVersions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersions(Collection<KafkaVersion> kafkaVersions);

        /**
         * Sets the value of the KafkaVersions property for this object.
         *
         * @param kafkaVersions
         *        The new value for the KafkaVersions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersions(KafkaVersion... kafkaVersions);

        /**
         * Sets the value of the KafkaVersions property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.KafkaVersion.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kafka.model.KafkaVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.KafkaVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #kafkaVersions(List<KafkaVersion>)}.
         * 
         * @param kafkaVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.KafkaVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaVersions(java.util.Collection<KafkaVersion>)
         */
        Builder kafkaVersions(Consumer<KafkaVersion.Builder>... kafkaVersions);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private List<KafkaVersion> kafkaVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKafkaVersionsResponse model) {
            super(model);
            kafkaVersions(model.kafkaVersions);
            nextToken(model.nextToken);
        }

        public final List<KafkaVersion.Builder> getKafkaVersions() {
            List<KafkaVersion.Builder> result = ___listOfKafkaVersionCopier.copyToBuilder(this.kafkaVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKafkaVersions(Collection<KafkaVersion.BuilderImpl> kafkaVersions) {
            this.kafkaVersions = ___listOfKafkaVersionCopier.copyFromBuilder(kafkaVersions);
        }

        @Override
        public final Builder kafkaVersions(Collection<KafkaVersion> kafkaVersions) {
            this.kafkaVersions = ___listOfKafkaVersionCopier.copy(kafkaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaVersions(KafkaVersion... kafkaVersions) {
            kafkaVersions(Arrays.asList(kafkaVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaVersions(Consumer<KafkaVersion.Builder>... kafkaVersions) {
            kafkaVersions(Stream.of(kafkaVersions).map(c -> KafkaVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKafkaVersionsResponse build() {
            return new ListKafkaVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
