/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Associates sasl scram secrets to cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateScramSecretRequest extends KafkaRequest implements
        ToCopyableBuilder<BatchAssociateScramSecretRequest.Builder, BatchAssociateScramSecretRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(BatchAssociateScramSecretRequest::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<List<String>> SECRET_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecretArnList")
            .getter(getter(BatchAssociateScramSecretRequest::secretArnList))
            .setter(setter(Builder::secretArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            SECRET_ARN_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterArn;

    private final List<String> secretArnList;

    private BatchAssociateScramSecretRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.secretArnList = builder.secretArnList;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the cluster to be updated.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the cluster to be updated.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecretArnList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecretArnList() {
        return secretArnList != null && !(secretArnList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * List of AWS Secrets Manager secret ARNs.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecretArnList} method.
     * </p>
     * 
     * @return <p>
     *         List of AWS Secrets Manager secret ARNs.
     *         </p>
     */
    public final List<String> secretArnList() {
        return secretArnList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecretArnList() ? secretArnList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateScramSecretRequest)) {
            return false;
        }
        BatchAssociateScramSecretRequest other = (BatchAssociateScramSecretRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && hasSecretArnList() == other.hasSecretArnList()
                && Objects.equals(secretArnList(), other.secretArnList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateScramSecretRequest").add("ClusterArn", clusterArn())
                .add("SecretArnList", hasSecretArnList() ? secretArnList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "SecretArnList":
            return Optional.ofNullable(clazz.cast(secretArnList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("secretArnList", SECRET_ARN_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateScramSecretRequest, T> g) {
        return obj -> g.apply((BatchAssociateScramSecretRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchAssociateScramSecretRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the cluster to be updated.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster to be updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * List of AWS Secrets Manager secret ARNs.
         * </p>
         * 
         * @param secretArnList
         *        <p>
         *        List of AWS Secrets Manager secret ARNs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArnList(Collection<String> secretArnList);

        /**
         *
         * <p>
         * List of AWS Secrets Manager secret ARNs.
         * </p>
         * 
         * @param secretArnList
         *        <p>
         *        List of AWS Secrets Manager secret ARNs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArnList(String... secretArnList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private List<String> secretArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateScramSecretRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            secretArnList(model.secretArnList);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Collection<String> getSecretArnList() {
            if (secretArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return secretArnList;
        }

        public final void setSecretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
        }

        @Override
        public final Builder secretArnList(Collection<String> secretArnList) {
            this.secretArnList = ___listOf__stringCopier.copy(secretArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretArnList(String... secretArnList) {
            secretArnList(Arrays.asList(secretArnList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateScramSecretRequest build() {
            return new BatchAssociateScramSecretRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
