/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterOperationV2Response extends KafkaResponse implements
        ToCopyableBuilder<DescribeClusterOperationV2Response.Builder, DescribeClusterOperationV2Response> {
    private static final SdkField<ClusterOperationV2> CLUSTER_OPERATION_INFO_FIELD = SdkField
            .<ClusterOperationV2> builder(MarshallingType.SDK_POJO).memberName("ClusterOperationInfo")
            .getter(getter(DescribeClusterOperationV2Response::clusterOperationInfo))
            .setter(setter(Builder::clusterOperationInfo)).constructor(ClusterOperationV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterOperationInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_OPERATION_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ClusterOperationV2 clusterOperationInfo;

    private DescribeClusterOperationV2Response(BuilderImpl builder) {
        super(builder);
        this.clusterOperationInfo = builder.clusterOperationInfo;
    }

    /**
     *
     * <p>
     * Cluster operation information
     * </p>
     * 
     * @return <p>
     *         Cluster operation information
     *         </p>
     */
    public final ClusterOperationV2 clusterOperationInfo() {
        return clusterOperationInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterOperationInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterOperationV2Response)) {
            return false;
        }
        DescribeClusterOperationV2Response other = (DescribeClusterOperationV2Response) obj;
        return Objects.equals(clusterOperationInfo(), other.clusterOperationInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterOperationV2Response").add("ClusterOperationInfo", clusterOperationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterOperationInfo":
            return Optional.ofNullable(clazz.cast(clusterOperationInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterOperationInfo", CLUSTER_OPERATION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterOperationV2Response, T> g) {
        return obj -> g.apply((DescribeClusterOperationV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterOperationV2Response> {
        /**
         *
         * <p>
         * Cluster operation information
         * </p>
         * 
         * @param clusterOperationInfo
         *        <p>
         *        Cluster operation information
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationInfo(ClusterOperationV2 clusterOperationInfo);

        /**
         *
         * <p>
         * Cluster operation information
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterOperationV2.Builder} avoiding the
         * need to create one manually via {@link ClusterOperationV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterOperationV2.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterOperationInfo(ClusterOperationV2)}.
         * 
         * @param clusterOperationInfo
         *        a consumer that will call methods on {@link ClusterOperationV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterOperationInfo(ClusterOperationV2)
         */
        default Builder clusterOperationInfo(Consumer<ClusterOperationV2.Builder> clusterOperationInfo) {
            return clusterOperationInfo(ClusterOperationV2.builder().applyMutation(clusterOperationInfo).build());
        }
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private ClusterOperationV2 clusterOperationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterOperationV2Response model) {
            super(model);
            clusterOperationInfo(model.clusterOperationInfo);
        }

        public final ClusterOperationV2.Builder getClusterOperationInfo() {
            return clusterOperationInfo != null ? clusterOperationInfo.toBuilder() : null;
        }

        public final void setClusterOperationInfo(ClusterOperationV2.BuilderImpl clusterOperationInfo) {
            this.clusterOperationInfo = clusterOperationInfo != null ? clusterOperationInfo.build() : null;
        }

        @Override
        public final Builder clusterOperationInfo(ClusterOperationV2 clusterOperationInfo) {
            this.clusterOperationInfo = clusterOperationInfo;
            return this;
        }

        @Override
        public DescribeClusterOperationV2Response build() {
            return new DescribeClusterOperationV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
