/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterOperationsV2Response extends KafkaResponse implements
        ToCopyableBuilder<ListClusterOperationsV2Response.Builder, ListClusterOperationsV2Response> {
    private static final SdkField<List<ClusterOperationV2Summary>> CLUSTER_OPERATION_INFO_LIST_FIELD = SdkField
            .<List<ClusterOperationV2Summary>> builder(MarshallingType.LIST)
            .memberName("ClusterOperationInfoList")
            .getter(getter(ListClusterOperationsV2Response::clusterOperationInfoList))
            .setter(setter(Builder::clusterOperationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterOperationInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterOperationV2Summary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterOperationV2Summary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClusterOperationsV2Response::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_OPERATION_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ClusterOperationV2Summary> clusterOperationInfoList;

    private final String nextToken;

    private ListClusterOperationsV2Response(BuilderImpl builder) {
        super(builder);
        this.clusterOperationInfoList = builder.clusterOperationInfoList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterOperationInfoList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClusterOperationInfoList() {
        return clusterOperationInfoList != null && !(clusterOperationInfoList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * An array of cluster operation information objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterOperationInfoList} method.
     * </p>
     * 
     * @return <p>
     *         An array of cluster operation information objects.
     *         </p>
     */
    public final List<ClusterOperationV2Summary> clusterOperationInfoList() {
        return clusterOperationInfoList;
    }

    /**
     *
     * <p>
     * If the response of ListClusterOperationsV2 is truncated, it returns a NextToken in the response. This NextToken
     * should be sent in the subsequent request to ListClusterOperationsV2.
     * </p>
     * 
     * @return <p>
     *         If the response of ListClusterOperationsV2 is truncated, it returns a NextToken in the response. This
     *         NextToken should be sent in the subsequent request to ListClusterOperationsV2.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterOperationInfoList() ? clusterOperationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterOperationsV2Response)) {
            return false;
        }
        ListClusterOperationsV2Response other = (ListClusterOperationsV2Response) obj;
        return hasClusterOperationInfoList() == other.hasClusterOperationInfoList()
                && Objects.equals(clusterOperationInfoList(), other.clusterOperationInfoList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClusterOperationsV2Response")
                .add("ClusterOperationInfoList", hasClusterOperationInfoList() ? clusterOperationInfoList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterOperationInfoList":
            return Optional.ofNullable(clazz.cast(clusterOperationInfoList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterOperationInfoList", CLUSTER_OPERATION_INFO_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClusterOperationsV2Response, T> g) {
        return obj -> g.apply((ListClusterOperationsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClusterOperationsV2Response> {
        /**
         *
         * <p>
         * An array of cluster operation information objects.
         * </p>
         * 
         * @param clusterOperationInfoList
         *        <p>
         *        An array of cluster operation information objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationInfoList(Collection<ClusterOperationV2Summary> clusterOperationInfoList);

        /**
         *
         * <p>
         * An array of cluster operation information objects.
         * </p>
         * 
         * @param clusterOperationInfoList
         *        <p>
         *        An array of cluster operation information objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationInfoList(ClusterOperationV2Summary... clusterOperationInfoList);

        /**
         *
         * <p>
         * An array of cluster operation information objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary.Builder#build()} is called
         * immediately and its result is passed to {@link #clusterOperationInfoList(List<ClusterOperationV2Summary>)}.
         * 
         * @param clusterOperationInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterOperationInfoList(java.util.Collection<ClusterOperationV2Summary>)
         */
        Builder clusterOperationInfoList(Consumer<ClusterOperationV2Summary.Builder>... clusterOperationInfoList);

        /**
         *
         * <p>
         * If the response of ListClusterOperationsV2 is truncated, it returns a NextToken in the response. This
         * NextToken should be sent in the subsequent request to ListClusterOperationsV2.
         * </p>
         * 
         * @param nextToken
         *        <p>
         *        If the response of ListClusterOperationsV2 is truncated, it returns a NextToken in the response. This
         *        NextToken should be sent in the subsequent request to ListClusterOperationsV2.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private List<ClusterOperationV2Summary> clusterOperationInfoList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterOperationsV2Response model) {
            super(model);
            clusterOperationInfoList(model.clusterOperationInfoList);
            nextToken(model.nextToken);
        }

        public final List<ClusterOperationV2Summary.Builder> getClusterOperationInfoList() {
            List<ClusterOperationV2Summary.Builder> result = ___listOfClusterOperationV2SummaryCopier
                    .copyToBuilder(this.clusterOperationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterOperationInfoList(Collection<ClusterOperationV2Summary.BuilderImpl> clusterOperationInfoList) {
            this.clusterOperationInfoList = ___listOfClusterOperationV2SummaryCopier.copyFromBuilder(clusterOperationInfoList);
        }

        @Override
        public final Builder clusterOperationInfoList(Collection<ClusterOperationV2Summary> clusterOperationInfoList) {
            this.clusterOperationInfoList = ___listOfClusterOperationV2SummaryCopier.copy(clusterOperationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterOperationInfoList(ClusterOperationV2Summary... clusterOperationInfoList) {
            clusterOperationInfoList(Arrays.asList(clusterOperationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterOperationInfoList(Consumer<ClusterOperationV2Summary.Builder>... clusterOperationInfoList) {
            clusterOperationInfoList(Stream.of(clusterOperationInfoList)
                    .map(c -> ClusterOperationV2Summary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClusterOperationsV2Response build() {
            return new ListClusterOperationsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
