/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Provisioned cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class Provisioned implements SdkPojo, Serializable, ToCopyableBuilder<Provisioned.Builder, Provisioned> {
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField
            .<BrokerNodeGroupInfo> builder(MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo")
            .getter(getter(Provisioned::brokerNodeGroupInfo)).setter(setter(Builder::brokerNodeGroupInfo))
            .constructor(BrokerNodeGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build())
            .build();

    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField
            .<BrokerSoftwareInfo> builder(MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo")
            .getter(getter(Provisioned::currentBrokerSoftwareInfo)).setter(setter(Builder::currentBrokerSoftwareInfo))
            .constructor(BrokerSoftwareInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build())
            .build();

    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<ClientAuthentication> builder(MarshallingType.SDK_POJO).memberName("ClientAuthentication")
            .getter(getter(Provisioned::clientAuthentication)).setter(setter(Builder::clientAuthentication))
            .constructor(ClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField
            .<EncryptionInfo> builder(MarshallingType.SDK_POJO).memberName("EncryptionInfo")
            .getter(getter(Provisioned::encryptionInfo)).setter(setter(Builder::encryptionInfo))
            .constructor(EncryptionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()).build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoring").getter(getter(Provisioned::enhancedMonitoringAsString))
            .setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build())
            .build();

    private static final SdkField<OpenMonitoringInfo> OPEN_MONITORING_FIELD = SdkField
            .<OpenMonitoringInfo> builder(MarshallingType.SDK_POJO).memberName("OpenMonitoring")
            .getter(getter(Provisioned::openMonitoring)).setter(setter(Builder::openMonitoring))
            .constructor(OpenMonitoringInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(Provisioned::loggingInfo)).setter(setter(Builder::loggingInfo))
            .constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBrokerNodes").getter(getter(Provisioned::numberOfBrokerNodes))
            .setter(setter(Builder::numberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build())
            .build();

    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZookeeperConnectString").getter(getter(Provisioned::zookeeperConnectString))
            .setter(setter(Builder::zookeeperConnectString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build())
            .build();

    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_TLS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZookeeperConnectStringTls").getter(getter(Provisioned::zookeeperConnectStringTls))
            .setter(setter(Builder::zookeeperConnectStringTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectStringTls").build())
            .build();

    private static final SdkField<String> STORAGE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageMode").getter(getter(Provisioned::storageModeAsString)).setter(setter(Builder::storageMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMode").build()).build();

    private static final SdkField<String> CUSTOMER_ACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerActionStatus").getter(getter(Provisioned::customerActionStatusAsString))
            .setter(setter(Builder::customerActionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerActionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_NODE_GROUP_INFO_FIELD,
            CURRENT_BROKER_SOFTWARE_INFO_FIELD, CLIENT_AUTHENTICATION_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD,
            OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, ZOOKEEPER_CONNECT_STRING_FIELD,
            ZOOKEEPER_CONNECT_STRING_TLS_FIELD, STORAGE_MODE_FIELD, CUSTOMER_ACTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BrokerNodeGroupInfo brokerNodeGroupInfo;

    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;

    private final ClientAuthentication clientAuthentication;

    private final EncryptionInfo encryptionInfo;

    private final String enhancedMonitoring;

    private final OpenMonitoringInfo openMonitoring;

    private final LoggingInfo loggingInfo;

    private final Integer numberOfBrokerNodes;

    private final String zookeeperConnectString;

    private final String zookeeperConnectStringTls;

    private final String storageMode;

    private final String customerActionStatus;

    private Provisioned(BuilderImpl builder) {
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.clientAuthentication = builder.clientAuthentication;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.zookeeperConnectString = builder.zookeeperConnectString;
        this.zookeeperConnectStringTls = builder.zookeeperConnectStringTls;
        this.storageMode = builder.storageMode;
        this.customerActionStatus = builder.customerActionStatus;
    }

    /**
     *
     * <p>
     * Information about the brokers.
     * </p>
     * 
     * @return <p>
     *         Information about the brokers.
     *         </p>
     */
    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return brokerNodeGroupInfo;
    }

    /**
     *
     * <p>
     * Information about the Apache Kafka version deployed on the brokers.
     * </p>
     * 
     * @return <p>
     *         Information about the Apache Kafka version deployed on the brokers.
     *         </p>
     */
    public final BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return currentBrokerSoftwareInfo;
    }

    /**
     *
     * <p>
     * Includes all client authentication information.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication information.
     *         </p>
     */
    public final ClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    /**
     *
     * <p>
     * Includes all encryption-related information.
     * </p>
     * 
     * @return <p>
     *         Includes all encryption-related information.
     *         </p>
     */
    public final EncryptionInfo encryptionInfo() {
        return encryptionInfo;
    }

    /**
     *
     * <p>
     * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     *         PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(enhancedMonitoring);
    }

    /**
     *
     * <p>
     * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     *         PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final String enhancedMonitoringAsString() {
        return enhancedMonitoring;
    }

    /**
     *
     * <p>
     * The settings for open monitoring.
     * </p>
     * 
     * @return <p>
     *         The settings for open monitoring.
     *         </p>
     */
    public final OpenMonitoringInfo openMonitoring() {
        return openMonitoring;
    }

    /**
     *
     * <p>
     * Log delivery information for the cluster.
     * </p>
     * 
     * @return <p>
     *         Log delivery information for the cluster.
     *         </p>
     */
    public final LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     *
     * <p>
     * The number of broker nodes in the cluster.
     * </p>
     * 
     * @return <p>
     *         The number of broker nodes in the cluster.
     *         </p>
     */
    public final Integer numberOfBrokerNodes() {
        return numberOfBrokerNodes;
    }

    /**
     *
     * <p>
     * The connection string to use to connect to the Apache ZooKeeper cluster.
     * </p>
     * 
     * @return <p>
     *         The connection string to use to connect to the Apache ZooKeeper cluster.
     *         </p>
     */
    public final String zookeeperConnectString() {
        return zookeeperConnectString;
    }

    /**
     *
     * <p>
     * The connection string to use to connect to the Apache ZooKeeper cluster on a TLS port.
     * </p>
     * 
     * @return <p>
     *         The connection string to use to connect to the Apache ZooKeeper cluster on a TLS port.
     *         </p>
     */
    public final String zookeeperConnectStringTls() {
        return zookeeperConnectStringTls;
    }

    /**
     *
     * <p>
     * This controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         This controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final StorageMode storageMode() {
        return StorageMode.fromValue(storageMode);
    }

    /**
     *
     * <p>
     * This controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         This controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final String storageModeAsString() {
        return storageMode;
    }

    /**
     *
     * <p>
     * Determines if there is an action required from the customer.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #customerActionStatus} will return {@link CustomerActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #customerActionStatusAsString}.
     * </p>
     * 
     * @return <p>
     *         Determines if there is an action required from the customer.
     *         </p>
     * @see CustomerActionStatus
     */
    public final CustomerActionStatus customerActionStatus() {
        return CustomerActionStatus.fromValue(customerActionStatus);
    }

    /**
     *
     * <p>
     * Determines if there is an action required from the customer.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #customerActionStatus} will return {@link CustomerActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #customerActionStatusAsString}.
     * </p>
     * 
     * @return <p>
     *         Determines if there is an action required from the customer.
     *         </p>
     * @see CustomerActionStatus
     */
    public final String customerActionStatusAsString() {
        return customerActionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperConnectString());
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperConnectStringTls());
        hashCode = 31 * hashCode + Objects.hashCode(storageModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customerActionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Provisioned)) {
            return false;
        }
        Provisioned other = (Provisioned) obj;
        return Objects.equals(brokerNodeGroupInfo(), other.brokerNodeGroupInfo())
                && Objects.equals(currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo())
                && Objects.equals(clientAuthentication(), other.clientAuthentication())
                && Objects.equals(encryptionInfo(), other.encryptionInfo())
                && Objects.equals(enhancedMonitoringAsString(), other.enhancedMonitoringAsString())
                && Objects.equals(openMonitoring(), other.openMonitoring()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(numberOfBrokerNodes(), other.numberOfBrokerNodes())
                && Objects.equals(zookeeperConnectString(), other.zookeeperConnectString())
                && Objects.equals(zookeeperConnectStringTls(), other.zookeeperConnectStringTls())
                && Objects.equals(storageModeAsString(), other.storageModeAsString())
                && Objects.equals(customerActionStatusAsString(), other.customerActionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Provisioned").add("BrokerNodeGroupInfo", brokerNodeGroupInfo())
                .add("CurrentBrokerSoftwareInfo", currentBrokerSoftwareInfo())
                .add("ClientAuthentication", clientAuthentication()).add("EncryptionInfo", encryptionInfo())
                .add("EnhancedMonitoring", enhancedMonitoringAsString()).add("OpenMonitoring", openMonitoring())
                .add("LoggingInfo", loggingInfo()).add("NumberOfBrokerNodes", numberOfBrokerNodes())
                .add("ZookeeperConnectString", zookeeperConnectString())
                .add("ZookeeperConnectStringTls", zookeeperConnectStringTls()).add("StorageMode", storageModeAsString())
                .add("CustomerActionStatus", customerActionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerNodeGroupInfo":
            return Optional.ofNullable(clazz.cast(brokerNodeGroupInfo()));
        case "CurrentBrokerSoftwareInfo":
            return Optional.ofNullable(clazz.cast(currentBrokerSoftwareInfo()));
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        case "EncryptionInfo":
            return Optional.ofNullable(clazz.cast(encryptionInfo()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringAsString()));
        case "OpenMonitoring":
            return Optional.ofNullable(clazz.cast(openMonitoring()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        case "NumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(numberOfBrokerNodes()));
        case "ZookeeperConnectString":
            return Optional.ofNullable(clazz.cast(zookeeperConnectString()));
        case "ZookeeperConnectStringTls":
            return Optional.ofNullable(clazz.cast(zookeeperConnectStringTls()));
        case "StorageMode":
            return Optional.ofNullable(clazz.cast(storageModeAsString()));
        case "CustomerActionStatus":
            return Optional.ofNullable(clazz.cast(customerActionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("brokerNodeGroupInfo", BROKER_NODE_GROUP_INFO_FIELD);
        map.put("currentBrokerSoftwareInfo", CURRENT_BROKER_SOFTWARE_INFO_FIELD);
        map.put("clientAuthentication", CLIENT_AUTHENTICATION_FIELD);
        map.put("encryptionInfo", ENCRYPTION_INFO_FIELD);
        map.put("enhancedMonitoring", ENHANCED_MONITORING_FIELD);
        map.put("openMonitoring", OPEN_MONITORING_FIELD);
        map.put("loggingInfo", LOGGING_INFO_FIELD);
        map.put("numberOfBrokerNodes", NUMBER_OF_BROKER_NODES_FIELD);
        map.put("zookeeperConnectString", ZOOKEEPER_CONNECT_STRING_FIELD);
        map.put("zookeeperConnectStringTls", ZOOKEEPER_CONNECT_STRING_TLS_FIELD);
        map.put("storageMode", STORAGE_MODE_FIELD);
        map.put("customerActionStatus", CUSTOMER_ACTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Provisioned, T> g) {
        return obj -> g.apply((Provisioned) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Provisioned> {
        /**
         *
         * <p>
         * Information about the brokers.
         * </p>
         * 
         * @param brokerNodeGroupInfo
         *        <p>
         *        Information about the brokers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo);

        /**
         *
         * <p>
         * Information about the brokers.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link BrokerNodeGroupInfo.Builder} avoiding the
         * need to create one manually via {@link BrokerNodeGroupInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrokerNodeGroupInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #brokerNodeGroupInfo(BrokerNodeGroupInfo)}.
         * 
         * @param brokerNodeGroupInfo
         *        a consumer that will call methods on {@link BrokerNodeGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerNodeGroupInfo(BrokerNodeGroupInfo)
         */
        default Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return brokerNodeGroupInfo(BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo).build());
        }

        /**
         *
         * <p>
         * Information about the Apache Kafka version deployed on the brokers.
         * </p>
         * 
         * @param currentBrokerSoftwareInfo
         *        <p>
         *        Information about the Apache Kafka version deployed on the brokers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo);

        /**
         *
         * <p>
         * Information about the Apache Kafka version deployed on the brokers.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link BrokerSoftwareInfo.Builder} avoiding the
         * need to create one manually via {@link BrokerSoftwareInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrokerSoftwareInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #currentBrokerSoftwareInfo(BrokerSoftwareInfo)}.
         * 
         * @param currentBrokerSoftwareInfo
         *        a consumer that will call methods on {@link BrokerSoftwareInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentBrokerSoftwareInfo(BrokerSoftwareInfo)
         */
        default Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return currentBrokerSoftwareInfo(BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo).build());
        }

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(ClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ClientAuthentication.Builder} avoiding
         * the need to create one manually via {@link ClientAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #clientAuthentication(ClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link ClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(ClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(ClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * @param encryptionInfo
         *        <p>
         *        Includes all encryption-related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInfo(EncryptionInfo encryptionInfo);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link EncryptionInfo.Builder} avoiding the need
         * to create one manually via {@link EncryptionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionInfo(EncryptionInfo)}.
         * 
         * @param encryptionInfo
         *        a consumer that will call methods on {@link EncryptionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInfo(EncryptionInfo)
         */
        default Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return encryptionInfo(EncryptionInfo.builder().applyMutation(encryptionInfo).build());
        }

        /**
         *
         * <p>
         * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         *        PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(String enhancedMonitoring);

        /**
         *
         * <p>
         * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         *        PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * @param openMonitoring
         *        <p>
         *        The settings for open monitoring.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openMonitoring(OpenMonitoringInfo openMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link OpenMonitoringInfo.Builder} avoiding the
         * need to create one manually via {@link OpenMonitoringInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenMonitoringInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #openMonitoring(OpenMonitoringInfo)}.
         * 
         * @param openMonitoring
         *        a consumer that will call methods on {@link OpenMonitoringInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openMonitoring(OpenMonitoringInfo)
         */
        default Builder openMonitoring(Consumer<OpenMonitoringInfo.Builder> openMonitoring) {
            return openMonitoring(OpenMonitoringInfo.builder().applyMutation(openMonitoring).build());
        }

        /**
         *
         * <p>
         * Log delivery information for the cluster.
         * </p>
         * 
         * @param loggingInfo
         *        <p>
         *        Log delivery information for the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         *
         * <p>
         * Log delivery information for the cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to
         * create one manually via {@link LoggingInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        /**
         *
         * <p>
         * The number of broker nodes in the cluster.
         * </p>
         * 
         * @param numberOfBrokerNodes
         *        <p>
         *        The number of broker nodes in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBrokerNodes(Integer numberOfBrokerNodes);

        /**
         *
         * <p>
         * The connection string to use to connect to the Apache ZooKeeper cluster.
         * </p>
         * 
         * @param zookeeperConnectString
         *        <p>
         *        The connection string to use to connect to the Apache ZooKeeper cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperConnectString(String zookeeperConnectString);

        /**
         *
         * <p>
         * The connection string to use to connect to the Apache ZooKeeper cluster on a TLS port.
         * </p>
         * 
         * @param zookeeperConnectStringTls
         *        <p>
         *        The connection string to use to connect to the Apache ZooKeeper cluster on a TLS port.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperConnectStringTls(String zookeeperConnectStringTls);

        /**
         *
         * <p>
         * This controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        This controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(String storageMode);

        /**
         *
         * <p>
         * This controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        This controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(StorageMode storageMode);

        /**
         *
         * <p>
         * Determines if there is an action required from the customer.
         * </p>
         * 
         * @param customerActionStatus
         *        <p>
         *        Determines if there is an action required from the customer.
         *        </p>
         * @see CustomerActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerActionStatus
         */
        Builder customerActionStatus(String customerActionStatus);

        /**
         *
         * <p>
         * Determines if there is an action required from the customer.
         * </p>
         * 
         * @param customerActionStatus
         *        <p>
         *        Determines if there is an action required from the customer.
         *        </p>
         * @see CustomerActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerActionStatus
         */
        Builder customerActionStatus(CustomerActionStatus customerActionStatus);
    }

    static final class BuilderImpl implements Builder {
        private BrokerNodeGroupInfo brokerNodeGroupInfo;

        private BrokerSoftwareInfo currentBrokerSoftwareInfo;

        private ClientAuthentication clientAuthentication;

        private EncryptionInfo encryptionInfo;

        private String enhancedMonitoring;

        private OpenMonitoringInfo openMonitoring;

        private LoggingInfo loggingInfo;

        private Integer numberOfBrokerNodes;

        private String zookeeperConnectString;

        private String zookeeperConnectStringTls;

        private String storageMode;

        private String customerActionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Provisioned model) {
            brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            clientAuthentication(model.clientAuthentication);
            encryptionInfo(model.encryptionInfo);
            enhancedMonitoring(model.enhancedMonitoring);
            openMonitoring(model.openMonitoring);
            loggingInfo(model.loggingInfo);
            numberOfBrokerNodes(model.numberOfBrokerNodes);
            zookeeperConnectString(model.zookeeperConnectString);
            zookeeperConnectStringTls(model.zookeeperConnectStringTls);
            storageMode(model.storageMode);
            customerActionStatus(model.customerActionStatus);
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return brokerNodeGroupInfo != null ? brokerNodeGroupInfo.toBuilder() : null;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.toBuilder() : null;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return encryptionInfo != null ? encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoringInfo.Builder getOpenMonitoring() {
            return openMonitoring != null ? openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoringInfo.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoringInfo openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final String getZookeeperConnectString() {
            return zookeeperConnectString;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        @Override
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final String getZookeeperConnectStringTls() {
            return zookeeperConnectStringTls;
        }

        public final void setZookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
        }

        @Override
        public final Builder zookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
            return this;
        }

        public final String getStorageMode() {
            return storageMode;
        }

        public final void setStorageMode(String storageMode) {
            this.storageMode = storageMode;
        }

        @Override
        public final Builder storageMode(String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @Override
        public final Builder storageMode(StorageMode storageMode) {
            this.storageMode(storageMode == null ? null : storageMode.toString());
            return this;
        }

        public final String getCustomerActionStatus() {
            return customerActionStatus;
        }

        public final void setCustomerActionStatus(String customerActionStatus) {
            this.customerActionStatus = customerActionStatus;
        }

        @Override
        public final Builder customerActionStatus(String customerActionStatus) {
            this.customerActionStatus = customerActionStatus;
            return this;
        }

        @Override
        public final Builder customerActionStatus(CustomerActionStatus customerActionStatus) {
            this.customerActionStatus(customerActionStatus == null ? null : customerActionStatus.toString());
            return this;
        }

        @Override
        public Provisioned build() {
            return new Provisioned(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
