/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrokerStorageResponse extends KafkaResponse implements
        ToCopyableBuilder<UpdateBrokerStorageResponse.Builder, UpdateBrokerStorageResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateBrokerStorageResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterOperationArn").getter(getter(UpdateBrokerStorageResponse::clusterOperationArn))
            .setter(setter(Builder::clusterOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterOperationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_OPERATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterArn;

    private final String clusterOperationArn;

    private UpdateBrokerStorageResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.clusterOperationArn = builder.clusterOperationArn;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the cluster operation.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the cluster operation.
     *         </p>
     */
    public final String clusterOperationArn() {
        return clusterOperationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterOperationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerStorageResponse)) {
            return false;
        }
        UpdateBrokerStorageResponse other = (UpdateBrokerStorageResponse) obj;
        return Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(clusterOperationArn(), other.clusterOperationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrokerStorageResponse").add("ClusterArn", clusterArn())
                .add("ClusterOperationArn", clusterOperationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterOperationArn":
            return Optional.ofNullable(clazz.cast(clusterOperationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("clusterOperationArn", CLUSTER_OPERATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerStorageResponse, T> g) {
        return obj -> g.apply((UpdateBrokerStorageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBrokerStorageResponse> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the cluster operation.
         * </p>
         * 
         * @param clusterOperationArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationArn(String clusterOperationArn);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String clusterArn;

        private String clusterOperationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerStorageResponse model) {
            super(model);
            clusterArn(model.clusterArn);
            clusterOperationArn(model.clusterOperationArn);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterOperationArn() {
            return clusterOperationArn;
        }

        public final void setClusterOperationArn(String clusterOperationArn) {
            this.clusterOperationArn = clusterOperationArn;
        }

        @Override
        public final Builder clusterOperationArn(String clusterOperationArn) {
            this.clusterOperationArn = clusterOperationArn;
            return this;
        }

        @Override
        public UpdateBrokerStorageResponse build() {
            return new UpdateBrokerStorageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
