/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Details for SASL client authentication for VPC connectivity.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConnectivitySasl implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConnectivitySasl.Builder, VpcConnectivitySasl> {
    private static final SdkField<VpcConnectivityScram> SCRAM_FIELD = SdkField
            .<VpcConnectivityScram> builder(MarshallingType.SDK_POJO).memberName("Scram")
            .getter(getter(VpcConnectivitySasl::scram)).setter(setter(Builder::scram)).constructor(VpcConnectivityScram::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scram").build()).build();

    private static final SdkField<VpcConnectivityIam> IAM_FIELD = SdkField.<VpcConnectivityIam> builder(MarshallingType.SDK_POJO)
            .memberName("Iam").getter(getter(VpcConnectivitySasl::iam)).setter(setter(Builder::iam))
            .constructor(VpcConnectivityIam::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRAM_FIELD, IAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VpcConnectivityScram scram;

    private final VpcConnectivityIam iam;

    private VpcConnectivitySasl(BuilderImpl builder) {
        this.scram = builder.scram;
        this.iam = builder.iam;
    }

    /**
     *
     * <p>
     * Details for SASL/SCRAM client authentication for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         Details for SASL/SCRAM client authentication for VPC connectivity.
     *         </p>
     */
    public final VpcConnectivityScram scram() {
        return scram;
    }

    /**
     *
     * <p>
     * Details for SASL/IAM client authentication for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         Details for SASL/IAM client authentication for VPC connectivity.
     *         </p>
     */
    public final VpcConnectivityIam iam() {
        return iam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scram());
        hashCode = 31 * hashCode + Objects.hashCode(iam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnectivitySasl)) {
            return false;
        }
        VpcConnectivitySasl other = (VpcConnectivitySasl) obj;
        return Objects.equals(scram(), other.scram()) && Objects.equals(iam(), other.iam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConnectivitySasl").add("Scram", scram()).add("Iam", iam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scram":
            return Optional.ofNullable(clazz.cast(scram()));
        case "Iam":
            return Optional.ofNullable(clazz.cast(iam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scram", SCRAM_FIELD);
        map.put("iam", IAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcConnectivitySasl, T> g) {
        return obj -> g.apply((VpcConnectivitySasl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConnectivitySasl> {
        /**
         *
         * <p>
         * Details for SASL/SCRAM client authentication for VPC connectivity.
         * </p>
         * 
         * @param scram
         *        <p>
         *        Details for SASL/SCRAM client authentication for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scram(VpcConnectivityScram scram);

        /**
         *
         * <p>
         * Details for SASL/SCRAM client authentication for VPC connectivity.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link VpcConnectivityScram.Builder} avoiding
         * the need to create one manually via {@link VpcConnectivityScram#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectivityScram.Builder#build()} is called immediately and
         * its result is passed to {@link #scram(VpcConnectivityScram)}.
         * 
         * @param scram
         *        a consumer that will call methods on {@link VpcConnectivityScram.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scram(VpcConnectivityScram)
         */
        default Builder scram(Consumer<VpcConnectivityScram.Builder> scram) {
            return scram(VpcConnectivityScram.builder().applyMutation(scram).build());
        }

        /**
         *
         * <p>
         * Details for SASL/IAM client authentication for VPC connectivity.
         * </p>
         * 
         * @param iam
         *        <p>
         *        Details for SASL/IAM client authentication for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iam(VpcConnectivityIam iam);

        /**
         *
         * <p>
         * Details for SASL/IAM client authentication for VPC connectivity.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link VpcConnectivityIam.Builder} avoiding the
         * need to create one manually via {@link VpcConnectivityIam#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectivityIam.Builder#build()} is called immediately and its
         * result is passed to {@link #iam(VpcConnectivityIam)}.
         * 
         * @param iam
         *        a consumer that will call methods on {@link VpcConnectivityIam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iam(VpcConnectivityIam)
         */
        default Builder iam(Consumer<VpcConnectivityIam.Builder> iam) {
            return iam(VpcConnectivityIam.builder().applyMutation(iam).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VpcConnectivityScram scram;

        private VpcConnectivityIam iam;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnectivitySasl model) {
            scram(model.scram);
            iam(model.iam);
        }

        public final VpcConnectivityScram.Builder getScram() {
            return scram != null ? scram.toBuilder() : null;
        }

        public final void setScram(VpcConnectivityScram.BuilderImpl scram) {
            this.scram = scram != null ? scram.build() : null;
        }

        @Override
        public final Builder scram(VpcConnectivityScram scram) {
            this.scram = scram;
            return this;
        }

        public final VpcConnectivityIam.Builder getIam() {
            return iam != null ? iam.toBuilder() : null;
        }

        public final void setIam(VpcConnectivityIam.BuilderImpl iam) {
            this.iam = iam != null ? iam.build() : null;
        }

        @Override
        public final Builder iam(VpcConnectivityIam iam) {
            this.iam = iam;
            return this;
        }

        @Override
        public VpcConnectivitySasl build() {
            return new VpcConnectivitySasl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
