/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Describes the setup to be used for Apache Kafka broker nodes in the cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerNodeGroupInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerNodeGroupInfo.Builder, BrokerNodeGroupInfo> {
    private static final SdkField<String> BROKER_AZ_DISTRIBUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerAZDistribution").getter(getter(BrokerNodeGroupInfo::brokerAZDistributionAsString))
            .setter(setter(Builder::brokerAZDistribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerAZDistribution").build())
            .build();

    private static final SdkField<List<String>> CLIENT_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClientSubnets")
            .getter(getter(BrokerNodeGroupInfo::clientSubnets))
            .setter(setter(Builder::clientSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(BrokerNodeGroupInfo::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(BrokerNodeGroupInfo::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StorageInfo> STORAGE_INFO_FIELD = SdkField.<StorageInfo> builder(MarshallingType.SDK_POJO)
            .memberName("StorageInfo").getter(getter(BrokerNodeGroupInfo::storageInfo)).setter(setter(Builder::storageInfo))
            .constructor(StorageInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageInfo").build()).build();

    private static final SdkField<ConnectivityInfo> CONNECTIVITY_INFO_FIELD = SdkField
            .<ConnectivityInfo> builder(MarshallingType.SDK_POJO).memberName("ConnectivityInfo")
            .getter(getter(BrokerNodeGroupInfo::connectivityInfo)).setter(setter(Builder::connectivityInfo))
            .constructor(ConnectivityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityInfo").build()).build();

    private static final SdkField<List<String>> ZONE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ZoneIds")
            .getter(getter(BrokerNodeGroupInfo::zoneIds))
            .setter(setter(Builder::zoneIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zoneIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_AZ_DISTRIBUTION_FIELD,
            CLIENT_SUBNETS_FIELD, INSTANCE_TYPE_FIELD, SECURITY_GROUPS_FIELD, STORAGE_INFO_FIELD, CONNECTIVITY_INFO_FIELD,
            ZONE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String brokerAZDistribution;

    private final List<String> clientSubnets;

    private final String instanceType;

    private final List<String> securityGroups;

    private final StorageInfo storageInfo;

    private final ConnectivityInfo connectivityInfo;

    private final List<String> zoneIds;

    private BrokerNodeGroupInfo(BuilderImpl builder) {
        this.brokerAZDistribution = builder.brokerAZDistribution;
        this.clientSubnets = builder.clientSubnets;
        this.instanceType = builder.instanceType;
        this.securityGroups = builder.securityGroups;
        this.storageInfo = builder.storageInfo;
        this.connectivityInfo = builder.connectivityInfo;
        this.zoneIds = builder.zoneIds;
    }

    /**
     *
     * <p>
     * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify
     * it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No
     * other values are currently allowed.
     * </p>
     * <p>
     * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you
     * provide when you create the cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #brokerAZDistribution} will return {@link BrokerAZDistribution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #brokerAZDistributionAsString}.
     * </p>
     * 
     * @return <p>
     *         The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't
     *         specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the
     *         value DEFAULT. No other values are currently allowed.
     *         </p>
     *         <p>
     *         Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the
     *         subnets you provide when you create the cluster.
     *         </p>
     * @see BrokerAZDistribution
     */
    public final BrokerAZDistribution brokerAZDistribution() {
        return BrokerAZDistribution.fromValue(brokerAZDistribution);
    }

    /**
     *
     * <p>
     * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify
     * it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No
     * other values are currently allowed.
     * </p>
     * <p>
     * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you
     * provide when you create the cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #brokerAZDistribution} will return {@link BrokerAZDistribution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #brokerAZDistributionAsString}.
     * </p>
     * 
     * @return <p>
     *         The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't
     *         specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the
     *         value DEFAULT. No other values are currently allowed.
     *         </p>
     *         <p>
     *         Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the
     *         subnets you provide when you create the cluster.
     *         </p>
     * @see BrokerAZDistribution
     */
    public final String brokerAZDistributionAsString() {
        return brokerAZDistribution;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientSubnets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientSubnets() {
        return clientSubnets != null && !(clientSubnets instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network
     * interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data.
     * Client subnets can't occupy the Availability Zone with ID use use1-az3.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientSubnets} method.
     * </p>
     * 
     * @return <p>
     *         The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network
     *         interfaces inside these subnets. Client applications use elastic network interfaces to produce and
     *         consume data. Client subnets can't occupy the Availability Zone with ID use use1-az3.
     *         </p>
     */
    public final List<String> clientSubnets() {
        return clientSubnets;
    }

    /**
     *
     * <p>
     * The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are allowed:
     * kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
     * </p>
     * 
     * @return <p>
     *         The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are
     *         allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and
     *         kafka.m5.24xlarge.
     *         </p>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to
     * and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default
     * security group associated with the VPC.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return <p>
     *         The AWS security groups to associate with the elastic network interfaces in order to specify who can
     *         connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK
     *         uses the default security group associated with the VPC.
     *         </p>
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     *
     * <p>
     * Contains information about storage volumes attached to MSK broker nodes.
     * </p>
     * 
     * @return <p>
     *         Contains information about storage volumes attached to MSK broker nodes.
     *         </p>
     */
    public final StorageInfo storageInfo() {
        return storageInfo;
    }

    /**
     *
     * <p>
     * Information about the broker access configuration.
     * </p>
     * 
     * @return <p>
     *         Information about the broker access configuration.
     *         </p>
     */
    public final ConnectivityInfo connectivityInfo() {
        return connectivityInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the ZoneIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasZoneIds() {
        return zoneIds != null && !(zoneIds instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of zoneIds for the cluster in the virtual private cloud (VPC).
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZoneIds} method.
     * </p>
     * 
     * @return <p>
     *         The list of zoneIds for the cluster in the virtual private cloud (VPC).
     *         </p>
     */
    public final List<String> zoneIds() {
        return zoneIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brokerAZDistributionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientSubnets() ? clientSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageInfo());
        hashCode = 31 * hashCode + Objects.hashCode(connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasZoneIds() ? zoneIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerNodeGroupInfo)) {
            return false;
        }
        BrokerNodeGroupInfo other = (BrokerNodeGroupInfo) obj;
        return Objects.equals(brokerAZDistributionAsString(), other.brokerAZDistributionAsString())
                && hasClientSubnets() == other.hasClientSubnets() && Objects.equals(clientSubnets(), other.clientSubnets())
                && Objects.equals(instanceType(), other.instanceType()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(storageInfo(), other.storageInfo())
                && Objects.equals(connectivityInfo(), other.connectivityInfo()) && hasZoneIds() == other.hasZoneIds()
                && Objects.equals(zoneIds(), other.zoneIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerNodeGroupInfo").add("BrokerAZDistribution", brokerAZDistributionAsString())
                .add("ClientSubnets", hasClientSubnets() ? clientSubnets() : null).add("InstanceType", instanceType())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("StorageInfo", storageInfo())
                .add("ConnectivityInfo", connectivityInfo()).add("ZoneIds", hasZoneIds() ? zoneIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerAZDistribution":
            return Optional.ofNullable(clazz.cast(brokerAZDistributionAsString()));
        case "ClientSubnets":
            return Optional.ofNullable(clazz.cast(clientSubnets()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "StorageInfo":
            return Optional.ofNullable(clazz.cast(storageInfo()));
        case "ConnectivityInfo":
            return Optional.ofNullable(clazz.cast(connectivityInfo()));
        case "ZoneIds":
            return Optional.ofNullable(clazz.cast(zoneIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("brokerAZDistribution", BROKER_AZ_DISTRIBUTION_FIELD);
        map.put("clientSubnets", CLIENT_SUBNETS_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("securityGroups", SECURITY_GROUPS_FIELD);
        map.put("storageInfo", STORAGE_INFO_FIELD);
        map.put("connectivityInfo", CONNECTIVITY_INFO_FIELD);
        map.put("zoneIds", ZONE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrokerNodeGroupInfo, T> g) {
        return obj -> g.apply((BrokerNodeGroupInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerNodeGroupInfo> {
        /**
         *
         * <p>
         * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't
         * specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value
         * DEFAULT. No other values are currently allowed.
         * </p>
         * <p>
         * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets
         * you provide when you create the cluster.
         * </p>
         * 
         * @param brokerAZDistribution
         *        <p>
         *        The distribution of broker nodes across Availability Zones. This is an optional parameter. If you
         *        don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to
         *        the value DEFAULT. No other values are currently allowed.
         *        </p>
         *        <p>
         *        Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the
         *        subnets you provide when you create the cluster.
         *        </p>
         * @see BrokerAZDistribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerAZDistribution
         */
        Builder brokerAZDistribution(String brokerAZDistribution);

        /**
         *
         * <p>
         * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't
         * specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value
         * DEFAULT. No other values are currently allowed.
         * </p>
         * <p>
         * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets
         * you provide when you create the cluster.
         * </p>
         * 
         * @param brokerAZDistribution
         *        <p>
         *        The distribution of broker nodes across Availability Zones. This is an optional parameter. If you
         *        don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to
         *        the value DEFAULT. No other values are currently allowed.
         *        </p>
         *        <p>
         *        Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the
         *        subnets you provide when you create the cluster.
         *        </p>
         * @see BrokerAZDistribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerAZDistribution
         */
        Builder brokerAZDistribution(BrokerAZDistribution brokerAZDistribution);

        /**
         *
         * <p>
         * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network
         * interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume
         * data. Client subnets can't occupy the Availability Zone with ID use use1-az3.
         * </p>
         * 
         * @param clientSubnets
         *        <p>
         *        The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic
         *        network interfaces inside these subnets. Client applications use elastic network interfaces to produce
         *        and consume data. Client subnets can't occupy the Availability Zone with ID use use1-az3.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnets(Collection<String> clientSubnets);

        /**
         *
         * <p>
         * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network
         * interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume
         * data. Client subnets can't occupy the Availability Zone with ID use use1-az3.
         * </p>
         * 
         * @param clientSubnets
         *        <p>
         *        The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic
         *        network interfaces inside these subnets. Client applications use elastic network interfaces to produce
         *        and consume data. Client subnets can't occupy the Availability Zone with ID use use1-az3.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnets(String... clientSubnets);

        /**
         *
         * <p>
         * The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are allowed:
         * kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and
         * kafka.m5.24xlarge.
         * </p>
         * 
         * @param instanceType
         *        <p>
         *        The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are
         *        allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and
         *        kafka.m5.24xlarge.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         *
         * <p>
         * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect
         * to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the
         * default security group associated with the VPC.
         * </p>
         * 
         * @param securityGroups
         *        <p>
         *        The AWS security groups to associate with the elastic network interfaces in order to specify who can
         *        connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon
         *        MSK uses the default security group associated with the VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         *
         * <p>
         * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect
         * to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the
         * default security group associated with the VPC.
         * </p>
         * 
         * @param securityGroups
         *        <p>
         *        The AWS security groups to associate with the elastic network interfaces in order to specify who can
         *        connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon
         *        MSK uses the default security group associated with the VPC.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         *
         * <p>
         * Contains information about storage volumes attached to MSK broker nodes.
         * </p>
         * 
         * @param storageInfo
         *        <p>
         *        Contains information about storage volumes attached to MSK broker nodes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageInfo(StorageInfo storageInfo);

        /**
         *
         * <p>
         * Contains information about storage volumes attached to MSK broker nodes.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link StorageInfo.Builder} avoiding the need to
         * create one manually via {@link StorageInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #storageInfo(StorageInfo)}.
         * 
         * @param storageInfo
         *        a consumer that will call methods on {@link StorageInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageInfo(StorageInfo)
         */
        default Builder storageInfo(Consumer<StorageInfo.Builder> storageInfo) {
            return storageInfo(StorageInfo.builder().applyMutation(storageInfo).build());
        }

        /**
         *
         * <p>
         * Information about the broker access configuration.
         * </p>
         * 
         * @param connectivityInfo
         *        <p>
         *        Information about the broker access configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(ConnectivityInfo connectivityInfo);

        /**
         *
         * <p>
         * Information about the broker access configuration.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ConnectivityInfo.Builder} avoiding the
         * need to create one manually via {@link ConnectivityInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectivityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #connectivityInfo(ConnectivityInfo)}.
         * 
         * @param connectivityInfo
         *        a consumer that will call methods on {@link ConnectivityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivityInfo(ConnectivityInfo)
         */
        default Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> connectivityInfo) {
            return connectivityInfo(ConnectivityInfo.builder().applyMutation(connectivityInfo).build());
        }

        /**
         *
         * <p>
         * The list of zoneIds for the cluster in the virtual private cloud (VPC).
         * </p>
         * 
         * @param zoneIds
         *        <p>
         *        The list of zoneIds for the cluster in the virtual private cloud (VPC).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneIds(Collection<String> zoneIds);

        /**
         *
         * <p>
         * The list of zoneIds for the cluster in the virtual private cloud (VPC).
         * </p>
         * 
         * @param zoneIds
         *        <p>
         *        The list of zoneIds for the cluster in the virtual private cloud (VPC).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneIds(String... zoneIds);
    }

    static final class BuilderImpl implements Builder {
        private String brokerAZDistribution;

        private List<String> clientSubnets = DefaultSdkAutoConstructList.getInstance();

        private String instanceType;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private StorageInfo storageInfo;

        private ConnectivityInfo connectivityInfo;

        private List<String> zoneIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerNodeGroupInfo model) {
            brokerAZDistribution(model.brokerAZDistribution);
            clientSubnets(model.clientSubnets);
            instanceType(model.instanceType);
            securityGroups(model.securityGroups);
            storageInfo(model.storageInfo);
            connectivityInfo(model.connectivityInfo);
            zoneIds(model.zoneIds);
        }

        public final String getBrokerAZDistribution() {
            return brokerAZDistribution;
        }

        public final void setBrokerAZDistribution(String brokerAZDistribution) {
            this.brokerAZDistribution = brokerAZDistribution;
        }

        @Override
        public final Builder brokerAZDistribution(String brokerAZDistribution) {
            this.brokerAZDistribution = brokerAZDistribution;
            return this;
        }

        @Override
        public final Builder brokerAZDistribution(BrokerAZDistribution brokerAZDistribution) {
            this.brokerAZDistribution(brokerAZDistribution == null ? null : brokerAZDistribution.toString());
            return this;
        }

        public final Collection<String> getClientSubnets() {
            if (clientSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return clientSubnets;
        }

        public final void setClientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
        }

        @Override
        public final Builder clientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientSubnets(String... clientSubnets) {
            clientSubnets(Arrays.asList(clientSubnets));
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final StorageInfo.Builder getStorageInfo() {
            return storageInfo != null ? storageInfo.toBuilder() : null;
        }

        public final void setStorageInfo(StorageInfo.BuilderImpl storageInfo) {
            this.storageInfo = storageInfo != null ? storageInfo.build() : null;
        }

        @Override
        public final Builder storageInfo(StorageInfo storageInfo) {
            this.storageInfo = storageInfo;
            return this;
        }

        public final ConnectivityInfo.Builder getConnectivityInfo() {
            return connectivityInfo != null ? connectivityInfo.toBuilder() : null;
        }

        public final void setConnectivityInfo(ConnectivityInfo.BuilderImpl connectivityInfo) {
            this.connectivityInfo = connectivityInfo != null ? connectivityInfo.build() : null;
        }

        @Override
        public final Builder connectivityInfo(ConnectivityInfo connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        public final Collection<String> getZoneIds() {
            if (zoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return zoneIds;
        }

        public final void setZoneIds(Collection<String> zoneIds) {
            this.zoneIds = ___listOf__stringCopier.copy(zoneIds);
        }

        @Override
        public final Builder zoneIds(Collection<String> zoneIds) {
            this.zoneIds = ___listOf__stringCopier.copy(zoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneIds(String... zoneIds) {
            zoneIds(Arrays.asList(zoneIds));
            return this;
        }

        @Override
        public BrokerNodeGroupInfo build() {
            return new BrokerNodeGroupInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
