/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Request object for UpdateStorage api. Its used to update the storage attributes for the cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStorageRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateStorageRequest.Builder, UpdateStorageRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateStorageRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateStorageRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(UpdateStorageRequest::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedThroughput").build())
            .build();

    private static final SdkField<String> STORAGE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageMode").getter(getter(UpdateStorageRequest::storageModeAsString))
            .setter(setter(Builder::storageMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMode").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeGB").getter(getter(UpdateStorageRequest::volumeSizeGB)).setter(setter(Builder::volumeSizeGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeGB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CURRENT_VERSION_FIELD, PROVISIONED_THROUGHPUT_FIELD, STORAGE_MODE_FIELD, VOLUME_SIZE_GB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterArn;

    private final String currentVersion;

    private final ProvisionedThroughput provisionedThroughput;

    private final String storageMode;

    private final Integer volumeSizeGB;

    private UpdateStorageRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.storageMode = builder.storageMode;
        this.volumeSizeGB = builder.volumeSizeGB;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the cluster to be updated.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the cluster to be updated.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The version of cluster to update from. A successful operation will then generate a new version.
     * </p>
     * 
     * @return <p>
     *         The version of cluster to update from. A successful operation will then generate a new version.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * EBS volume provisioned throughput information.
     * </p>
     * 
     * @return <p>
     *         EBS volume provisioned throughput information.
     *         </p>
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     *
     * <p>
     * Controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         Controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final StorageMode storageMode() {
        return StorageMode.fromValue(storageMode);
    }

    /**
     *
     * <p>
     * Controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         Controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final String storageModeAsString() {
        return storageMode;
    }

    /**
     *
     * <p>
     * size of the EBS volume to update.
     * </p>
     * 
     * @return <p>
     *         size of the EBS volume to update.
     *         </p>
     */
    public final Integer volumeSizeGB() {
        return volumeSizeGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(storageModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeGB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageRequest)) {
            return false;
        }
        UpdateStorageRequest other = (UpdateStorageRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(storageModeAsString(), other.storageModeAsString())
                && Objects.equals(volumeSizeGB(), other.volumeSizeGB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStorageRequest").add("ClusterArn", clusterArn()).add("CurrentVersion", currentVersion())
                .add("ProvisionedThroughput", provisionedThroughput()).add("StorageMode", storageModeAsString())
                .add("VolumeSizeGB", volumeSizeGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "StorageMode":
            return Optional.ofNullable(clazz.cast(storageModeAsString()));
        case "VolumeSizeGB":
            return Optional.ofNullable(clazz.cast(volumeSizeGB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("provisionedThroughput", PROVISIONED_THROUGHPUT_FIELD);
        map.put("storageMode", STORAGE_MODE_FIELD);
        map.put("volumeSizeGB", VOLUME_SIZE_GB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageRequest, T> g) {
        return obj -> g.apply((UpdateStorageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStorageRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the cluster to be updated.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster to be updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The version of cluster to update from. A successful operation will then generate a new version.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of cluster to update from. A successful operation will then generate a new version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * EBS volume provisioned throughput information.
         * </p>
         * 
         * @param provisionedThroughput
         *        <p>
         *        EBS volume provisioned throughput information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         *
         * <p>
         * EBS volume provisioned throughput information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         *
         * <p>
         * Controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        Controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(String storageMode);

        /**
         *
         * <p>
         * Controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        Controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(StorageMode storageMode);

        /**
         *
         * <p>
         * size of the EBS volume to update.
         * </p>
         * 
         * @param volumeSizeGB
         *        <p>
         *        size of the EBS volume to update.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeGB(Integer volumeSizeGB);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private String currentVersion;

        private ProvisionedThroughput provisionedThroughput;

        private String storageMode;

        private Integer volumeSizeGB;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            currentVersion(model.currentVersion);
            provisionedThroughput(model.provisionedThroughput);
            storageMode(model.storageMode);
            volumeSizeGB(model.volumeSizeGB);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final String getStorageMode() {
            return storageMode;
        }

        public final void setStorageMode(String storageMode) {
            this.storageMode = storageMode;
        }

        @Override
        public final Builder storageMode(String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @Override
        public final Builder storageMode(StorageMode storageMode) {
            this.storageMode(storageMode == null ? null : storageMode.toString());
            return this;
        }

        public final Integer getVolumeSizeGB() {
            return volumeSizeGB;
        }

        public final void setVolumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
        }

        @Override
        public final Builder volumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageRequest build() {
            return new UpdateStorageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
