/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * The VPC connection object.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConnection implements SdkPojo, Serializable, ToCopyableBuilder<VpcConnection.Builder, VpcConnection> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectionArn").getter(getter(VpcConnection::vpcConnectionArn))
            .setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()).build();

    private static final SdkField<String> TARGET_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetClusterArn").getter(getter(VpcConnection::targetClusterArn))
            .setter(setter(Builder::targetClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(VpcConnection::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Authentication").getter(getter(VpcConnection::authentication)).setter(setter(Builder::authentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(VpcConnection::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(VpcConnection::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD,
            TARGET_CLUSTER_ARN_FIELD, CREATION_TIME_FIELD, AUTHENTICATION_FIELD, VPC_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcConnectionArn;

    private final String targetClusterArn;

    private final Instant creationTime;

    private final String authentication;

    private final String vpcId;

    private final String state;

    private VpcConnection(BuilderImpl builder) {
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.targetClusterArn = builder.targetClusterArn;
        this.creationTime = builder.creationTime;
        this.authentication = builder.authentication;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
    }

    /**
     *
     * <p>
     * The ARN that identifies the Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         The ARN that identifies the Vpc Connection.
     *         </p>
     */
    public final String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    /**
     *
     * <p>
     * The ARN that identifies the Cluster which the Vpc Connection belongs to.
     * </p>
     * 
     * @return <p>
     *         The ARN that identifies the Cluster which the Vpc Connection belongs to.
     *         </p>
     */
    public final String targetClusterArn() {
        return targetClusterArn;
    }

    /**
     *
     * <p>
     * Creation time of the Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         Creation time of the Vpc Connection.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * Information about the auth scheme of Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         Information about the auth scheme of Vpc Connection.
     *         </p>
     */
    public final String authentication() {
        return authentication;
    }

    /**
     *
     * <p>
     * The vpcId that belongs to the Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         The vpcId that belongs to the Vpc Connection.
     *         </p>
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     *
     * <p>
     * State of the Vpc Connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         State of the Vpc Connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(state);
    }

    /**
     *
     * <p>
     * State of the Vpc Connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         State of the Vpc Connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnection)) {
            return false;
        }
        VpcConnection other = (VpcConnection) obj;
        return Objects.equals(vpcConnectionArn(), other.vpcConnectionArn())
                && Objects.equals(targetClusterArn(), other.targetClusterArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(authentication(), other.authentication()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConnection").add("VpcConnectionArn", vpcConnectionArn())
                .add("TargetClusterArn", targetClusterArn()).add("CreationTime", creationTime())
                .add("Authentication", authentication()).add("VpcId", vpcId()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        case "TargetClusterArn":
            return Optional.ofNullable(clazz.cast(targetClusterArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        map.put("targetClusterArn", TARGET_CLUSTER_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("authentication", AUTHENTICATION_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcConnection, T> g) {
        return obj -> g.apply((VpcConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConnection> {
        /**
         *
         * <p>
         * The ARN that identifies the Vpc Connection.
         * </p>
         * 
         * @param vpcConnectionArn
         *        <p>
         *        The ARN that identifies the Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);

        /**
         *
         * <p>
         * The ARN that identifies the Cluster which the Vpc Connection belongs to.
         * </p>
         * 
         * @param targetClusterArn
         *        <p>
         *        The ARN that identifies the Cluster which the Vpc Connection belongs to.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetClusterArn(String targetClusterArn);

        /**
         *
         * <p>
         * Creation time of the Vpc Connection.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        Creation time of the Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * Information about the auth scheme of Vpc Connection.
         * </p>
         * 
         * @param authentication
         *        <p>
         *        Information about the auth scheme of Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(String authentication);

        /**
         *
         * <p>
         * The vpcId that belongs to the Vpc Connection.
         * </p>
         * 
         * @param vpcId
         *        <p>
         *        The vpcId that belongs to the Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         *
         * <p>
         * State of the Vpc Connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        State of the Vpc Connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * State of the Vpc Connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        State of the Vpc Connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(VpcConnectionState state);
    }

    static final class BuilderImpl implements Builder {
        private String vpcConnectionArn;

        private String targetClusterArn;

        private Instant creationTime;

        private String authentication;

        private String vpcId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnection model) {
            vpcConnectionArn(model.vpcConnectionArn);
            targetClusterArn(model.targetClusterArn);
            creationTime(model.creationTime);
            authentication(model.authentication);
            vpcId(model.vpcId);
            state(model.state);
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getTargetClusterArn() {
            return targetClusterArn;
        }

        public final void setTargetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
        }

        @Override
        public final Builder targetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAuthentication() {
            return authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public VpcConnection build() {
            return new VpcConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
