/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Description of the requester that calls the API operation.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserIdentity implements SdkPojo, Serializable, ToCopyableBuilder<UserIdentity.Builder, UserIdentity> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UserIdentity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(UserIdentity::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TYPE_FIELD, PRINCIPAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String principalId;

    private UserIdentity(BuilderImpl builder) {
        this.type = builder.type;
        this.principalId = builder.principalId;
    }

    /**
     *
     * <p>
     * The identity type of the requester that calls the API operation.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return <p>
     *         The identity type of the requester that calls the API operation.
     *         </p>
     * @see UserIdentityType
     */
    public final UserIdentityType type() {
        return UserIdentityType.fromValue(type);
    }

    /**
     *
     * <p>
     * The identity type of the requester that calls the API operation.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return <p>
     *         The identity type of the requester that calls the API operation.
     *         </p>
     * @see UserIdentityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     *
     * <p>
     * A unique identifier for the requester that calls the API operation.
     * </p>
     * 
     * @return <p>
     *         A unique identifier for the requester that calls the API operation.
     *         </p>
     */
    public final String principalId() {
        return principalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(principalId(), other.principalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserIdentity").add("Type", typeAsString()).add("PrincipalId", principalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("principalId", PRINCIPAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserIdentity, T> g) {
        return obj -> g.apply((UserIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserIdentity> {
        /**
         *
         * <p>
         * The identity type of the requester that calls the API operation.
         * </p>
         * 
         * @param type
         *        <p>
         *        The identity type of the requester that calls the API operation.
         *        </p>
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder type(String type);

        /**
         *
         * <p>
         * The identity type of the requester that calls the API operation.
         * </p>
         * 
         * @param type
         *        <p>
         *        The identity type of the requester that calls the API operation.
         *        </p>
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder type(UserIdentityType type);

        /**
         *
         * <p>
         * A unique identifier for the requester that calls the API operation.
         * </p>
         * 
         * @param principalId
         *        <p>
         *        A unique identifier for the requester that calls the API operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentity model) {
            type(model.type);
            principalId(model.principalId);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserIdentityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        @Override
        public UserIdentity build() {
            return new UserIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
