/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Information regarding UpdateBrokerCount.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerCountUpdateInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerCountUpdateInfo.Builder, BrokerCountUpdateInfo> {
    private static final SdkField<List<Double>> CREATED_BROKER_IDS_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("CreatedBrokerIds")
            .getter(getter(BrokerCountUpdateInfo::createdBrokerIds))
            .setter(setter(Builder::createdBrokerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBrokerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> DELETED_BROKER_IDS_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("DeletedBrokerIds")
            .getter(getter(BrokerCountUpdateInfo::deletedBrokerIds))
            .setter(setter(Builder::deletedBrokerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedBrokerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BROKER_IDS_FIELD,
            DELETED_BROKER_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Double> createdBrokerIds;

    private final List<Double> deletedBrokerIds;

    private BrokerCountUpdateInfo(BuilderImpl builder) {
        this.createdBrokerIds = builder.createdBrokerIds;
        this.deletedBrokerIds = builder.deletedBrokerIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreatedBrokerIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCreatedBrokerIds() {
        return createdBrokerIds != null && !(createdBrokerIds instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Kafka Broker IDs of brokers being created.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreatedBrokerIds} method.
     * </p>
     * 
     * @return <p>
     *         Kafka Broker IDs of brokers being created.
     *         </p>
     */
    public final List<Double> createdBrokerIds() {
        return createdBrokerIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeletedBrokerIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeletedBrokerIds() {
        return deletedBrokerIds != null && !(deletedBrokerIds instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Kafka Broker IDs of brokers being deleted.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeletedBrokerIds} method.
     * </p>
     * 
     * @return <p>
     *         Kafka Broker IDs of brokers being deleted.
     *         </p>
     */
    public final List<Double> deletedBrokerIds() {
        return deletedBrokerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCreatedBrokerIds() ? createdBrokerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeletedBrokerIds() ? deletedBrokerIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerCountUpdateInfo)) {
            return false;
        }
        BrokerCountUpdateInfo other = (BrokerCountUpdateInfo) obj;
        return hasCreatedBrokerIds() == other.hasCreatedBrokerIds()
                && Objects.equals(createdBrokerIds(), other.createdBrokerIds())
                && hasDeletedBrokerIds() == other.hasDeletedBrokerIds()
                && Objects.equals(deletedBrokerIds(), other.deletedBrokerIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerCountUpdateInfo")
                .add("CreatedBrokerIds", hasCreatedBrokerIds() ? createdBrokerIds() : null)
                .add("DeletedBrokerIds", hasDeletedBrokerIds() ? deletedBrokerIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedBrokerIds":
            return Optional.ofNullable(clazz.cast(createdBrokerIds()));
        case "DeletedBrokerIds":
            return Optional.ofNullable(clazz.cast(deletedBrokerIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdBrokerIds", CREATED_BROKER_IDS_FIELD);
        map.put("deletedBrokerIds", DELETED_BROKER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrokerCountUpdateInfo, T> g) {
        return obj -> g.apply((BrokerCountUpdateInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerCountUpdateInfo> {
        /**
         *
         * <p>
         * Kafka Broker IDs of brokers being created.
         * </p>
         * 
         * @param createdBrokerIds
         *        <p>
         *        Kafka Broker IDs of brokers being created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBrokerIds(Collection<Double> createdBrokerIds);

        /**
         *
         * <p>
         * Kafka Broker IDs of brokers being created.
         * </p>
         * 
         * @param createdBrokerIds
         *        <p>
         *        Kafka Broker IDs of brokers being created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBrokerIds(Double... createdBrokerIds);

        /**
         *
         * <p>
         * Kafka Broker IDs of brokers being deleted.
         * </p>
         * 
         * @param deletedBrokerIds
         *        <p>
         *        Kafka Broker IDs of brokers being deleted.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedBrokerIds(Collection<Double> deletedBrokerIds);

        /**
         *
         * <p>
         * Kafka Broker IDs of brokers being deleted.
         * </p>
         * 
         * @param deletedBrokerIds
         *        <p>
         *        Kafka Broker IDs of brokers being deleted.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedBrokerIds(Double... deletedBrokerIds);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> createdBrokerIds = DefaultSdkAutoConstructList.getInstance();

        private List<Double> deletedBrokerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerCountUpdateInfo model) {
            createdBrokerIds(model.createdBrokerIds);
            deletedBrokerIds(model.deletedBrokerIds);
        }

        public final Collection<Double> getCreatedBrokerIds() {
            if (createdBrokerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return createdBrokerIds;
        }

        public final void setCreatedBrokerIds(Collection<Double> createdBrokerIds) {
            this.createdBrokerIds = ___listOf__doubleCopier.copy(createdBrokerIds);
        }

        @Override
        public final Builder createdBrokerIds(Collection<Double> createdBrokerIds) {
            this.createdBrokerIds = ___listOf__doubleCopier.copy(createdBrokerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdBrokerIds(Double... createdBrokerIds) {
            createdBrokerIds(Arrays.asList(createdBrokerIds));
            return this;
        }

        public final Collection<Double> getDeletedBrokerIds() {
            if (deletedBrokerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return deletedBrokerIds;
        }

        public final void setDeletedBrokerIds(Collection<Double> deletedBrokerIds) {
            this.deletedBrokerIds = ___listOf__doubleCopier.copy(deletedBrokerIds);
        }

        @Override
        public final Builder deletedBrokerIds(Collection<Double> deletedBrokerIds) {
            this.deletedBrokerIds = ___listOf__doubleCopier.copy(deletedBrokerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedBrokerIds(Double... deletedBrokerIds) {
            deletedBrokerIds(Arrays.asList(deletedBrokerIds));
            return this;
        }

        @Override
        public BrokerCountUpdateInfo build() {
            return new BrokerCountUpdateInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
