/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicatorResponse extends KafkaResponse implements
        ToCopyableBuilder<DescribeReplicatorResponse.Builder, DescribeReplicatorResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(DescribeReplicatorResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(DescribeReplicatorResponse::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<Boolean> IS_REPLICATOR_REFERENCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsReplicatorReference").getter(getter(DescribeReplicatorResponse::isReplicatorReference))
            .setter(setter(Builder::isReplicatorReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isReplicatorReference").build())
            .build();

    private static final SdkField<List<KafkaClusterDescription>> KAFKA_CLUSTERS_FIELD = SdkField
            .<List<KafkaClusterDescription>> builder(MarshallingType.LIST)
            .memberName("KafkaClusters")
            .getter(getter(DescribeReplicatorResponse::kafkaClusters))
            .setter(setter(Builder::kafkaClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KafkaClusterDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(KafkaClusterDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReplicationInfoDescription>> REPLICATION_INFO_LIST_FIELD = SdkField
            .<List<ReplicationInfoDescription>> builder(MarshallingType.LIST)
            .memberName("ReplicationInfoList")
            .getter(getter(DescribeReplicatorResponse::replicationInfoList))
            .setter(setter(Builder::replicationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationInfoDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationInfoDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorArn").getter(getter(DescribeReplicatorResponse::replicatorArn))
            .setter(setter(Builder::replicatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorArn").build()).build();

    private static final SdkField<String> REPLICATOR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorDescription").getter(getter(DescribeReplicatorResponse::replicatorDescription))
            .setter(setter(Builder::replicatorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorDescription").build())
            .build();

    private static final SdkField<String> REPLICATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorName").getter(getter(DescribeReplicatorResponse::replicatorName))
            .setter(setter(Builder::replicatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorName").build()).build();

    private static final SdkField<String> REPLICATOR_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorResourceArn").getter(getter(DescribeReplicatorResponse::replicatorResourceArn))
            .setter(setter(Builder::replicatorResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorResourceArn").build())
            .build();

    private static final SdkField<String> REPLICATOR_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorState").getter(getter(DescribeReplicatorResponse::replicatorStateAsString))
            .setter(setter(Builder::replicatorState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorState").build()).build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceExecutionRoleArn").getter(getter(DescribeReplicatorResponse::serviceExecutionRoleArn))
            .setter(setter(Builder::serviceExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build())
            .build();

    private static final SdkField<ReplicationStateInfo> STATE_INFO_FIELD = SdkField
            .<ReplicationStateInfo> builder(MarshallingType.SDK_POJO).memberName("StateInfo")
            .getter(getter(DescribeReplicatorResponse::stateInfo)).setter(setter(Builder::stateInfo))
            .constructor(ReplicationStateInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateInfo").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeReplicatorResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            CURRENT_VERSION_FIELD, IS_REPLICATOR_REFERENCE_FIELD, KAFKA_CLUSTERS_FIELD, REPLICATION_INFO_LIST_FIELD,
            REPLICATOR_ARN_FIELD, REPLICATOR_DESCRIPTION_FIELD, REPLICATOR_NAME_FIELD, REPLICATOR_RESOURCE_ARN_FIELD,
            REPLICATOR_STATE_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD, STATE_INFO_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant creationTime;

    private final String currentVersion;

    private final Boolean isReplicatorReference;

    private final List<KafkaClusterDescription> kafkaClusters;

    private final List<ReplicationInfoDescription> replicationInfoList;

    private final String replicatorArn;

    private final String replicatorDescription;

    private final String replicatorName;

    private final String replicatorResourceArn;

    private final String replicatorState;

    private final String serviceExecutionRoleArn;

    private final ReplicationStateInfo stateInfo;

    private final Map<String, String> tags;

    private DescribeReplicatorResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.isReplicatorReference = builder.isReplicatorReference;
        this.kafkaClusters = builder.kafkaClusters;
        this.replicationInfoList = builder.replicationInfoList;
        this.replicatorArn = builder.replicatorArn;
        this.replicatorDescription = builder.replicatorDescription;
        this.replicatorName = builder.replicatorName;
        this.replicatorResourceArn = builder.replicatorResourceArn;
        this.replicatorState = builder.replicatorState;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.stateInfo = builder.stateInfo;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The time when the replicator was created.
     * </p>
     * 
     * @return The time when the replicator was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The current version number of the replicator.
     * </p>
     * 
     * @return The current version number of the replicator.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * Whether this resource is a replicator reference.
     * </p>
     * 
     * @return Whether this resource is a replicator reference.
     */
    public final Boolean isReplicatorReference() {
        return isReplicatorReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the KafkaClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKafkaClusters() {
        return kafkaClusters != null && !(kafkaClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Kafka Clusters used in setting up sources / targets for replication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKafkaClusters} method.
     * </p>
     * 
     * @return Kafka Clusters used in setting up sources / targets for replication.
     */
    public final List<KafkaClusterDescription> kafkaClusters() {
        return kafkaClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationInfoList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationInfoList() {
        return replicationInfoList != null && !(replicationInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster
     * replication flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationInfoList} method.
     * </p>
     * 
     * @return A list of replication configurations, where each configuration targets a given source cluster to target
     *         cluster replication flow.
     */
    public final List<ReplicationInfoDescription> replicationInfoList() {
        return replicationInfoList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator.
     */
    public final String replicatorArn() {
        return replicatorArn;
    }

    /**
     * <p>
     * The description of the replicator.
     * </p>
     * 
     * @return The description of the replicator.
     */
    public final String replicatorDescription() {
        return replicatorDescription;
    }

    /**
     * <p>
     * The name of the replicator.
     * </p>
     * 
     * @return The name of the replicator.
     */
    public final String replicatorName() {
        return replicatorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
     */
    public final String replicatorResourceArn() {
        return replicatorResourceArn;
    }

    /**
     * <p>
     * State of the replicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicatorState}
     * will return {@link ReplicatorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicatorStateAsString}.
     * </p>
     * 
     * @return State of the replicator.
     * @see ReplicatorState
     */
    public final ReplicatorState replicatorState() {
        return ReplicatorState.fromValue(replicatorState);
    }

    /**
     * <p>
     * State of the replicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicatorState}
     * will return {@link ReplicatorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicatorStateAsString}.
     * </p>
     * 
     * @return State of the replicator.
     * @see ReplicatorState
     */
    public final String replicatorStateAsString() {
        return replicatorState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used by the replicator to access resources in the customer's
     * account (e.g source and target clusters)
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used by the replicator to access resources in the
     *         customer's account (e.g source and target clusters)
     */
    public final String serviceExecutionRoleArn() {
        return serviceExecutionRoleArn;
    }

    /**
     * <p>
     * Details about the state of the replicator.
     * </p>
     * 
     * @return Details about the state of the replicator.
     */
    public final ReplicationStateInfo stateInfo() {
        return stateInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * List of tags attached to the Replicator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return List of tags attached to the Replicator.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(isReplicatorReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasKafkaClusters() ? kafkaClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationInfoList() ? replicationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorName());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicatorResponse)) {
            return false;
        }
        DescribeReplicatorResponse other = (DescribeReplicatorResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(isReplicatorReference(), other.isReplicatorReference())
                && hasKafkaClusters() == other.hasKafkaClusters() && Objects.equals(kafkaClusters(), other.kafkaClusters())
                && hasReplicationInfoList() == other.hasReplicationInfoList()
                && Objects.equals(replicationInfoList(), other.replicationInfoList())
                && Objects.equals(replicatorArn(), other.replicatorArn())
                && Objects.equals(replicatorDescription(), other.replicatorDescription())
                && Objects.equals(replicatorName(), other.replicatorName())
                && Objects.equals(replicatorResourceArn(), other.replicatorResourceArn())
                && Objects.equals(replicatorStateAsString(), other.replicatorStateAsString())
                && Objects.equals(serviceExecutionRoleArn(), other.serviceExecutionRoleArn())
                && Objects.equals(stateInfo(), other.stateInfo()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicatorResponse").add("CreationTime", creationTime())
                .add("CurrentVersion", currentVersion()).add("IsReplicatorReference", isReplicatorReference())
                .add("KafkaClusters", hasKafkaClusters() ? kafkaClusters() : null)
                .add("ReplicationInfoList", hasReplicationInfoList() ? replicationInfoList() : null)
                .add("ReplicatorArn", replicatorArn()).add("ReplicatorDescription", replicatorDescription())
                .add("ReplicatorName", replicatorName()).add("ReplicatorResourceArn", replicatorResourceArn())
                .add("ReplicatorState", replicatorStateAsString()).add("ServiceExecutionRoleArn", serviceExecutionRoleArn())
                .add("StateInfo", stateInfo()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "IsReplicatorReference":
            return Optional.ofNullable(clazz.cast(isReplicatorReference()));
        case "KafkaClusters":
            return Optional.ofNullable(clazz.cast(kafkaClusters()));
        case "ReplicationInfoList":
            return Optional.ofNullable(clazz.cast(replicationInfoList()));
        case "ReplicatorArn":
            return Optional.ofNullable(clazz.cast(replicatorArn()));
        case "ReplicatorDescription":
            return Optional.ofNullable(clazz.cast(replicatorDescription()));
        case "ReplicatorName":
            return Optional.ofNullable(clazz.cast(replicatorName()));
        case "ReplicatorResourceArn":
            return Optional.ofNullable(clazz.cast(replicatorResourceArn()));
        case "ReplicatorState":
            return Optional.ofNullable(clazz.cast(replicatorStateAsString()));
        case "ServiceExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(serviceExecutionRoleArn()));
        case "StateInfo":
            return Optional.ofNullable(clazz.cast(stateInfo()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("isReplicatorReference", IS_REPLICATOR_REFERENCE_FIELD);
        map.put("kafkaClusters", KAFKA_CLUSTERS_FIELD);
        map.put("replicationInfoList", REPLICATION_INFO_LIST_FIELD);
        map.put("replicatorArn", REPLICATOR_ARN_FIELD);
        map.put("replicatorDescription", REPLICATOR_DESCRIPTION_FIELD);
        map.put("replicatorName", REPLICATOR_NAME_FIELD);
        map.put("replicatorResourceArn", REPLICATOR_RESOURCE_ARN_FIELD);
        map.put("replicatorState", REPLICATOR_STATE_FIELD);
        map.put("serviceExecutionRoleArn", SERVICE_EXECUTION_ROLE_ARN_FIELD);
        map.put("stateInfo", STATE_INFO_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicatorResponse, T> g) {
        return obj -> g.apply((DescribeReplicatorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReplicatorResponse> {
        /**
         * <p>
         * The time when the replicator was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the replicator was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The current version number of the replicator.
         * </p>
         * 
         * @param currentVersion
         *        The current version number of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * Whether this resource is a replicator reference.
         * </p>
         * 
         * @param isReplicatorReference
         *        Whether this resource is a replicator reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isReplicatorReference(Boolean isReplicatorReference);

        /**
         * <p>
         * Kafka Clusters used in setting up sources / targets for replication.
         * </p>
         * 
         * @param kafkaClusters
         *        Kafka Clusters used in setting up sources / targets for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusters(Collection<KafkaClusterDescription> kafkaClusters);

        /**
         * <p>
         * Kafka Clusters used in setting up sources / targets for replication.
         * </p>
         * 
         * @param kafkaClusters
         *        Kafka Clusters used in setting up sources / targets for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusters(KafkaClusterDescription... kafkaClusters);

        /**
         * <p>
         * Kafka Clusters used in setting up sources / targets for replication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.KafkaClusterDescription.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.kafka.model.KafkaClusterDescription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.KafkaClusterDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #kafkaClusters(List<KafkaClusterDescription>)}.
         * 
         * @param kafkaClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.KafkaClusterDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaClusters(java.util.Collection<KafkaClusterDescription>)
         */
        Builder kafkaClusters(Consumer<KafkaClusterDescription.Builder>... kafkaClusters);

        /**
         * <p>
         * A list of replication configurations, where each configuration targets a given source cluster to target
         * cluster replication flow.
         * </p>
         * 
         * @param replicationInfoList
         *        A list of replication configurations, where each configuration targets a given source cluster to
         *        target cluster replication flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInfoList(Collection<ReplicationInfoDescription> replicationInfoList);

        /**
         * <p>
         * A list of replication configurations, where each configuration targets a given source cluster to target
         * cluster replication flow.
         * </p>
         * 
         * @param replicationInfoList
         *        A list of replication configurations, where each configuration targets a given source cluster to
         *        target cluster replication flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInfoList(ReplicationInfoDescription... replicationInfoList);

        /**
         * <p>
         * A list of replication configurations, where each configuration targets a given source cluster to target
         * cluster replication flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationInfoList(List<ReplicationInfoDescription>)}.
         * 
         * @param replicationInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.ReplicationInfoDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationInfoList(java.util.Collection<ReplicationInfoDescription>)
         */
        Builder replicationInfoList(Consumer<ReplicationInfoDescription.Builder>... replicationInfoList);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator.
         * </p>
         * 
         * @param replicatorArn
         *        The Amazon Resource Name (ARN) of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorArn(String replicatorArn);

        /**
         * <p>
         * The description of the replicator.
         * </p>
         * 
         * @param replicatorDescription
         *        The description of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorDescription(String replicatorDescription);

        /**
         * <p>
         * The name of the replicator.
         * </p>
         * 
         * @param replicatorName
         *        The name of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorName(String replicatorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
         * </p>
         * 
         * @param replicatorResourceArn
         *        The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorResourceArn(String replicatorResourceArn);

        /**
         * <p>
         * State of the replicator.
         * </p>
         * 
         * @param replicatorState
         *        State of the replicator.
         * @see ReplicatorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicatorState
         */
        Builder replicatorState(String replicatorState);

        /**
         * <p>
         * State of the replicator.
         * </p>
         * 
         * @param replicatorState
         *        State of the replicator.
         * @see ReplicatorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicatorState
         */
        Builder replicatorState(ReplicatorState replicatorState);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used by the replicator to access resources in the customer's
         * account (e.g source and target clusters)
         * </p>
         * 
         * @param serviceExecutionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used by the replicator to access resources in the
         *        customer's account (e.g source and target clusters)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRoleArn(String serviceExecutionRoleArn);

        /**
         * <p>
         * Details about the state of the replicator.
         * </p>
         * 
         * @param stateInfo
         *        Details about the state of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateInfo(ReplicationStateInfo stateInfo);

        /**
         * <p>
         * Details about the state of the replicator.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationStateInfo.Builder} avoiding
         * the need to create one manually via {@link ReplicationStateInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationStateInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #stateInfo(ReplicationStateInfo)}.
         * 
         * @param stateInfo
         *        a consumer that will call methods on {@link ReplicationStateInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateInfo(ReplicationStateInfo)
         */
        default Builder stateInfo(Consumer<ReplicationStateInfo.Builder> stateInfo) {
            return stateInfo(ReplicationStateInfo.builder().applyMutation(stateInfo).build());
        }

        /**
         * <p>
         * List of tags attached to the Replicator.
         * </p>
         * 
         * @param tags
         *        List of tags attached to the Replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String currentVersion;

        private Boolean isReplicatorReference;

        private List<KafkaClusterDescription> kafkaClusters = DefaultSdkAutoConstructList.getInstance();

        private List<ReplicationInfoDescription> replicationInfoList = DefaultSdkAutoConstructList.getInstance();

        private String replicatorArn;

        private String replicatorDescription;

        private String replicatorName;

        private String replicatorResourceArn;

        private String replicatorState;

        private String serviceExecutionRoleArn;

        private ReplicationStateInfo stateInfo;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicatorResponse model) {
            super(model);
            creationTime(model.creationTime);
            currentVersion(model.currentVersion);
            isReplicatorReference(model.isReplicatorReference);
            kafkaClusters(model.kafkaClusters);
            replicationInfoList(model.replicationInfoList);
            replicatorArn(model.replicatorArn);
            replicatorDescription(model.replicatorDescription);
            replicatorName(model.replicatorName);
            replicatorResourceArn(model.replicatorResourceArn);
            replicatorState(model.replicatorState);
            serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            stateInfo(model.stateInfo);
            tags(model.tags);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final Boolean getIsReplicatorReference() {
            return isReplicatorReference;
        }

        public final void setIsReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
        }

        @Override
        public final Builder isReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
            return this;
        }

        public final List<KafkaClusterDescription.Builder> getKafkaClusters() {
            List<KafkaClusterDescription.Builder> result = ___listOfKafkaClusterDescriptionCopier
                    .copyToBuilder(this.kafkaClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKafkaClusters(Collection<KafkaClusterDescription.BuilderImpl> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterDescriptionCopier.copyFromBuilder(kafkaClusters);
        }

        @Override
        public final Builder kafkaClusters(Collection<KafkaClusterDescription> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterDescriptionCopier.copy(kafkaClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(KafkaClusterDescription... kafkaClusters) {
            kafkaClusters(Arrays.asList(kafkaClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(Consumer<KafkaClusterDescription.Builder>... kafkaClusters) {
            kafkaClusters(Stream.of(kafkaClusters).map(c -> KafkaClusterDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReplicationInfoDescription.Builder> getReplicationInfoList() {
            List<ReplicationInfoDescription.Builder> result = ___listOfReplicationInfoDescriptionCopier
                    .copyToBuilder(this.replicationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInfoList(Collection<ReplicationInfoDescription.BuilderImpl> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoDescriptionCopier.copyFromBuilder(replicationInfoList);
        }

        @Override
        public final Builder replicationInfoList(Collection<ReplicationInfoDescription> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoDescriptionCopier.copy(replicationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(ReplicationInfoDescription... replicationInfoList) {
            replicationInfoList(Arrays.asList(replicationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(Consumer<ReplicationInfoDescription.Builder>... replicationInfoList) {
            replicationInfoList(Stream.of(replicationInfoList)
                    .map(c -> ReplicationInfoDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicatorArn() {
            return replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getReplicatorDescription() {
            return replicatorDescription;
        }

        public final void setReplicatorDescription(String replicatorDescription) {
            this.replicatorDescription = replicatorDescription;
        }

        @Override
        public final Builder replicatorDescription(String replicatorDescription) {
            this.replicatorDescription = replicatorDescription;
            return this;
        }

        public final String getReplicatorName() {
            return replicatorName;
        }

        public final void setReplicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
        }

        @Override
        public final Builder replicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        public final String getReplicatorResourceArn() {
            return replicatorResourceArn;
        }

        public final void setReplicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
        }

        @Override
        public final Builder replicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
            return this;
        }

        public final String getReplicatorState() {
            return replicatorState;
        }

        public final void setReplicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
        }

        @Override
        public final Builder replicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
            return this;
        }

        @Override
        public final Builder replicatorState(ReplicatorState replicatorState) {
            this.replicatorState(replicatorState == null ? null : replicatorState.toString());
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final ReplicationStateInfo.Builder getStateInfo() {
            return stateInfo != null ? stateInfo.toBuilder() : null;
        }

        public final void setStateInfo(ReplicationStateInfo.BuilderImpl stateInfo) {
            this.stateInfo = stateInfo != null ? stateInfo.build() : null;
        }

        @Override
        public final Builder stateInfo(ReplicationStateInfo stateInfo) {
            this.stateInfo = stateInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeReplicatorResponse build() {
            return new DescribeReplicatorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
