/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Zookeeper node information.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZookeeperNodeInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ZookeeperNodeInfo.Builder, ZookeeperNodeInfo> {
    private static final SdkField<String> ATTACHED_ENI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachedENIId").getter(getter(ZookeeperNodeInfo::attachedENIId)).setter(setter(Builder::attachedENIId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedENIId").build()).build();

    private static final SdkField<String> CLIENT_VPC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientVpcIpAddress").getter(getter(ZookeeperNodeInfo::clientVpcIpAddress))
            .setter(setter(Builder::clientVpcIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientVpcIpAddress").build())
            .build();

    private static final SdkField<List<String>> ENDPOINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(ZookeeperNodeInfo::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> ZOOKEEPER_ID_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ZookeeperId").getter(getter(ZookeeperNodeInfo::zookeeperId)).setter(setter(Builder::zookeeperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperId").build()).build();

    private static final SdkField<String> ZOOKEEPER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZookeeperVersion").getter(getter(ZookeeperNodeInfo::zookeeperVersion))
            .setter(setter(Builder::zookeeperVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_ENI_ID_FIELD,
            CLIENT_VPC_IP_ADDRESS_FIELD, ENDPOINTS_FIELD, ZOOKEEPER_ID_FIELD, ZOOKEEPER_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attachedENIId;

    private final String clientVpcIpAddress;

    private final List<String> endpoints;

    private final Double zookeeperId;

    private final String zookeeperVersion;

    private ZookeeperNodeInfo(BuilderImpl builder) {
        this.attachedENIId = builder.attachedENIId;
        this.clientVpcIpAddress = builder.clientVpcIpAddress;
        this.endpoints = builder.endpoints;
        this.zookeeperId = builder.zookeeperId;
        this.zookeeperVersion = builder.zookeeperVersion;
    }

    /**
     *
     * <p>
     * The attached elastic network interface of the broker.
     * </p>
     * 
     * @return <p>
     *         The attached elastic network interface of the broker.
     *         </p>
     */
    public final String attachedENIId() {
        return attachedENIId;
    }

    /**
     *
     * <p>
     * The virtual private cloud (VPC) IP address of the client.
     * </p>
     * 
     * @return <p>
     *         The virtual private cloud (VPC) IP address of the client.
     *         </p>
     */
    public final String clientVpcIpAddress() {
        return clientVpcIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Endpoints for accessing the ZooKeeper.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return <p>
     *         Endpoints for accessing the ZooKeeper.
     *         </p>
     */
    public final List<String> endpoints() {
        return endpoints;
    }

    /**
     *
     * <p>
     * The role-specific ID for Zookeeper.
     * </p>
     * 
     * @return <p>
     *         The role-specific ID for Zookeeper.
     *         </p>
     */
    public final Double zookeeperId() {
        return zookeeperId;
    }

    /**
     *
     * <p>
     * The version of Zookeeper.
     * </p>
     * 
     * @return <p>
     *         The version of Zookeeper.
     *         </p>
     */
    public final String zookeeperVersion() {
        return zookeeperVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachedENIId());
        hashCode = 31 * hashCode + Objects.hashCode(clientVpcIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperId());
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZookeeperNodeInfo)) {
            return false;
        }
        ZookeeperNodeInfo other = (ZookeeperNodeInfo) obj;
        return Objects.equals(attachedENIId(), other.attachedENIId())
                && Objects.equals(clientVpcIpAddress(), other.clientVpcIpAddress()) && hasEndpoints() == other.hasEndpoints()
                && Objects.equals(endpoints(), other.endpoints()) && Objects.equals(zookeeperId(), other.zookeeperId())
                && Objects.equals(zookeeperVersion(), other.zookeeperVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZookeeperNodeInfo").add("AttachedENIId", attachedENIId())
                .add("ClientVpcIpAddress", clientVpcIpAddress()).add("Endpoints", hasEndpoints() ? endpoints() : null)
                .add("ZookeeperId", zookeeperId()).add("ZookeeperVersion", zookeeperVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedENIId":
            return Optional.ofNullable(clazz.cast(attachedENIId()));
        case "ClientVpcIpAddress":
            return Optional.ofNullable(clazz.cast(clientVpcIpAddress()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "ZookeeperId":
            return Optional.ofNullable(clazz.cast(zookeeperId()));
        case "ZookeeperVersion":
            return Optional.ofNullable(clazz.cast(zookeeperVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachedENIId", ATTACHED_ENI_ID_FIELD);
        map.put("clientVpcIpAddress", CLIENT_VPC_IP_ADDRESS_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        map.put("zookeeperId", ZOOKEEPER_ID_FIELD);
        map.put("zookeeperVersion", ZOOKEEPER_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZookeeperNodeInfo, T> g) {
        return obj -> g.apply((ZookeeperNodeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZookeeperNodeInfo> {
        /**
         *
         * <p>
         * The attached elastic network interface of the broker.
         * </p>
         * 
         * @param attachedENIId
         *        <p>
         *        The attached elastic network interface of the broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedENIId(String attachedENIId);

        /**
         *
         * <p>
         * The virtual private cloud (VPC) IP address of the client.
         * </p>
         * 
         * @param clientVpcIpAddress
         *        <p>
         *        The virtual private cloud (VPC) IP address of the client.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpcIpAddress(String clientVpcIpAddress);

        /**
         *
         * <p>
         * Endpoints for accessing the ZooKeeper.
         * </p>
         * 
         * @param endpoints
         *        <p>
         *        Endpoints for accessing the ZooKeeper.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<String> endpoints);

        /**
         *
         * <p>
         * Endpoints for accessing the ZooKeeper.
         * </p>
         * 
         * @param endpoints
         *        <p>
         *        Endpoints for accessing the ZooKeeper.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(String... endpoints);

        /**
         *
         * <p>
         * The role-specific ID for Zookeeper.
         * </p>
         * 
         * @param zookeeperId
         *        <p>
         *        The role-specific ID for Zookeeper.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperId(Double zookeeperId);

        /**
         *
         * <p>
         * The version of Zookeeper.
         * </p>
         * 
         * @param zookeeperVersion
         *        <p>
         *        The version of Zookeeper.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperVersion(String zookeeperVersion);
    }

    static final class BuilderImpl implements Builder {
        private String attachedENIId;

        private String clientVpcIpAddress;

        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();

        private Double zookeeperId;

        private String zookeeperVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ZookeeperNodeInfo model) {
            attachedENIId(model.attachedENIId);
            clientVpcIpAddress(model.clientVpcIpAddress);
            endpoints(model.endpoints);
            zookeeperId(model.zookeeperId);
            zookeeperVersion(model.zookeeperVersion);
        }

        public final String getAttachedENIId() {
            return attachedENIId;
        }

        public final void setAttachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
        }

        @Override
        public final Builder attachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
            return this;
        }

        public final String getClientVpcIpAddress() {
            return clientVpcIpAddress;
        }

        public final void setClientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
        }

        @Override
        public final Builder clientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
            return this;
        }

        public final Collection<String> getEndpoints() {
            if (endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return endpoints;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final Double getZookeeperId() {
            return zookeeperId;
        }

        public final void setZookeeperId(Double zookeeperId) {
            this.zookeeperId = zookeeperId;
        }

        @Override
        public final Builder zookeeperId(Double zookeeperId) {
            this.zookeeperId = zookeeperId;
            return this;
        }

        public final String getZookeeperVersion() {
            return zookeeperVersion;
        }

        public final void setZookeeperVersion(String zookeeperVersion) {
            this.zookeeperVersion = zookeeperVersion;
        }

        @Override
        public final Builder zookeeperVersion(String zookeeperVersion) {
            this.zookeeperVersion = zookeeperVersion;
            return this;
        }

        @Override
        public ZookeeperNodeInfo build() {
            return new ZookeeperNodeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
