/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an Amazon MSK Cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonMskCluster implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonMskCluster.Builder, AmazonMskCluster> {
    private static final SdkField<String> MSK_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MskClusterArn").getter(getter(AmazonMskCluster::mskClusterArn)).setter(setter(Builder::mskClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mskClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MSK_CLUSTER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mskClusterArn;

    private AmazonMskCluster(BuilderImpl builder) {
        this.mskClusterArn = builder.mskClusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon MSK cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon MSK cluster.
     */
    public final String mskClusterArn() {
        return mskClusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mskClusterArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonMskCluster)) {
            return false;
        }
        AmazonMskCluster other = (AmazonMskCluster) obj;
        return Objects.equals(mskClusterArn(), other.mskClusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonMskCluster").add("MskClusterArn", mskClusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MskClusterArn":
            return Optional.ofNullable(clazz.cast(mskClusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mskClusterArn", MSK_CLUSTER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonMskCluster, T> g) {
        return obj -> g.apply((AmazonMskCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonMskCluster> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon MSK cluster.
         * </p>
         * 
         * @param mskClusterArn
         *        The Amazon Resource Name (ARN) of an Amazon MSK cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mskClusterArn(String mskClusterArn);
    }

    static final class BuilderImpl implements Builder {
        private String mskClusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonMskCluster model) {
            mskClusterArn(model.mskClusterArn);
        }

        public final String getMskClusterArn() {
            return mskClusterArn;
        }

        public final void setMskClusterArn(String mskClusterArn) {
            this.mskClusterArn = mskClusterArn;
        }

        @Override
        public final Builder mskClusterArn(String mskClusterArn) {
            this.mskClusterArn = mskClusterArn;
            return this;
        }

        @Override
        public AmazonMskCluster build() {
            return new AmazonMskCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
