/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationRevisionsResponse extends KafkaResponse implements
        ToCopyableBuilder<ListConfigurationRevisionsResponse.Builder, ListConfigurationRevisionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationRevisionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ConfigurationRevision>> REVISIONS_FIELD = SdkField
            .<List<ConfigurationRevision>> builder(MarshallingType.LIST)
            .memberName("Revisions")
            .getter(getter(ListConfigurationRevisionsResponse::revisions))
            .setter(setter(Builder::revisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationRevision> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationRevision::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REVISIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ConfigurationRevision> revisions;

    private ListConfigurationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.revisions = builder.revisions;
    }

    /**
     *
     * <p>
     * Paginated results marker.
     * </p>
     * 
     * @return <p>
     *         Paginated results marker.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Revisions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRevisions() {
        return revisions != null && !(revisions instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * List of ConfigurationRevision objects.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevisions} method.
     * </p>
     * 
     * @return <p>
     *         List of ConfigurationRevision objects.
     *         </p>
     */
    public final List<ConfigurationRevision> revisions() {
        return revisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRevisions() ? revisions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationRevisionsResponse)) {
            return false;
        }
        ListConfigurationRevisionsResponse other = (ListConfigurationRevisionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRevisions() == other.hasRevisions()
                && Objects.equals(revisions(), other.revisions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationRevisionsResponse").add("NextToken", nextToken())
                .add("Revisions", hasRevisions() ? revisions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Revisions":
            return Optional.ofNullable(clazz.cast(revisions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("revisions", REVISIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationRevisionsResponse, T> g) {
        return obj -> g.apply((ListConfigurationRevisionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConfigurationRevisionsResponse> {
        /**
         *
         * <p>
         * Paginated results marker.
         * </p>
         * 
         * @param nextToken
         *        <p>
         *        Paginated results marker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         *
         * <p>
         * List of ConfigurationRevision objects.
         * </p>
         * 
         * @param revisions
         *        <p>
         *        List of ConfigurationRevision objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<ConfigurationRevision> revisions);

        /**
         *
         * <p>
         * List of ConfigurationRevision objects.
         * </p>
         * 
         * @param revisions
         *        <p>
         *        List of ConfigurationRevision objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(ConfigurationRevision... revisions);

        /**
         *
         * <p>
         * List of ConfigurationRevision objects.
         * </p>
         * 
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.ConfigurationRevision.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kafka.model.ConfigurationRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.ConfigurationRevision.Builder#build()} is called
         * immediately and its result is passed to {@link #revisions(List<ConfigurationRevision>)}.
         * 
         * @param revisions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.ConfigurationRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisions(java.util.Collection<ConfigurationRevision>)
         */
        Builder revisions(Consumer<ConfigurationRevision.Builder>... revisions);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ConfigurationRevision> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationRevisionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            revisions(model.revisions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConfigurationRevision.Builder> getRevisions() {
            List<ConfigurationRevision.Builder> result = ___listOfConfigurationRevisionCopier.copyToBuilder(this.revisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisions(Collection<ConfigurationRevision.BuilderImpl> revisions) {
            this.revisions = ___listOfConfigurationRevisionCopier.copyFromBuilder(revisions);
        }

        @Override
        public final Builder revisions(Collection<ConfigurationRevision> revisions) {
            this.revisions = ___listOfConfigurationRevisionCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(ConfigurationRevision... revisions) {
            revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<ConfigurationRevision.Builder>... revisions) {
            revisions(Stream.of(revisions).map(c -> ConfigurationRevision.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConfigurationRevisionsResponse build() {
            return new ListConfigurationRevisionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
