/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Contains information about provisioned throughput for EBS storage volumes attached to kafka broker nodes.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedThroughput implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedThroughput.Builder, ProvisionedThroughput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(ProvisionedThroughput::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Integer> VOLUME_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeThroughput").getter(getter(ProvisionedThroughput::volumeThroughput))
            .setter(setter(Builder::volumeThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeThroughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            VOLUME_THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer volumeThroughput;

    private ProvisionedThroughput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.volumeThroughput = builder.volumeThroughput;
    }

    /**
     *
     * <p>
     * Provisioned throughput is enabled or not.
     * </p>
     * 
     * @return <p>
     *         Provisioned throughput is enabled or not.
     *         </p>
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     *
     * <p>
     * Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
     * </p>
     * 
     * @return <p>
     *         Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
     *         </p>
     */
    public final Integer volumeThroughput() {
        return volumeThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(volumeThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughput)) {
            return false;
        }
        ProvisionedThroughput other = (ProvisionedThroughput) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(volumeThroughput(), other.volumeThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedThroughput").add("Enabled", enabled()).add("VolumeThroughput", volumeThroughput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "VolumeThroughput":
            return Optional.ofNullable(clazz.cast(volumeThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("volumeThroughput", VOLUME_THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedThroughput, T> g) {
        return obj -> g.apply((ProvisionedThroughput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedThroughput> {
        /**
         *
         * <p>
         * Provisioned throughput is enabled or not.
         * </p>
         * 
         * @param enabled
         *        <p>
         *        Provisioned throughput is enabled or not.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         *
         * <p>
         * Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
         * </p>
         * 
         * @param volumeThroughput
         *        <p>
         *        Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeThroughput(Integer volumeThroughput);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer volumeThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughput model) {
            enabled(model.enabled);
            volumeThroughput(model.volumeThroughput);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getVolumeThroughput() {
            return volumeThroughput;
        }

        public final void setVolumeThroughput(Integer volumeThroughput) {
            this.volumeThroughput = volumeThroughput;
        }

        @Override
        public final Builder volumeThroughput(Integer volumeThroughput) {
            this.volumeThroughput = volumeThroughput;
            return this;
        }

        @Override
        public ProvisionedThroughput build() {
            return new ProvisionedThroughput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
