/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateSecurityRequest.Builder, UpdateSecurityRequest> {
    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<ClientAuthentication> builder(MarshallingType.SDK_POJO).memberName("ClientAuthentication")
            .getter(getter(UpdateSecurityRequest::clientAuthentication)).setter(setter(Builder::clientAuthentication))
            .constructor(ClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateSecurityRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateSecurityRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField
            .<EncryptionInfo> builder(MarshallingType.SDK_POJO).memberName("EncryptionInfo")
            .getter(getter(UpdateSecurityRequest::encryptionInfo)).setter(setter(Builder::encryptionInfo))
            .constructor(EncryptionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_AUTHENTICATION_FIELD,
            CLUSTER_ARN_FIELD, CURRENT_VERSION_FIELD, ENCRYPTION_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ClientAuthentication clientAuthentication;

    private final String clusterArn;

    private final String currentVersion;

    private final EncryptionInfo encryptionInfo;

    private UpdateSecurityRequest(BuilderImpl builder) {
        super(builder);
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.encryptionInfo = builder.encryptionInfo;
    }

    /**
     *
     * <p>
     * Includes all client authentication related information.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication related information.
     *         </p>
     */
    public final ClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster
     * to find its version. When this update operation is successful, it generates a new cluster version.
     * </p>
     * 
     * @return <p>
     *         The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK
     *         cluster to find its version. When this update operation is successful, it generates a new cluster
     *         version.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * Includes all encryption-related information.
     * </p>
     * 
     * @return <p>
     *         Includes all encryption-related information.
     *         </p>
     */
    public final EncryptionInfo encryptionInfo() {
        return encryptionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityRequest)) {
            return false;
        }
        UpdateSecurityRequest other = (UpdateSecurityRequest) obj;
        return Objects.equals(clientAuthentication(), other.clientAuthentication())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(encryptionInfo(), other.encryptionInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityRequest").add("ClientAuthentication", clientAuthentication())
                .add("ClusterArn", clusterArn()).add("CurrentVersion", currentVersion()).add("EncryptionInfo", encryptionInfo())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "EncryptionInfo":
            return Optional.ofNullable(clazz.cast(encryptionInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientAuthentication", CLIENT_AUTHENTICATION_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("encryptionInfo", ENCRYPTION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityRequest, T> g) {
        return obj -> g.apply((UpdateSecurityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecurityRequest> {
        /**
         *
         * <p>
         * Includes all client authentication related information.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(ClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication related information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ClientAuthentication.Builder} avoiding
         * the need to create one manually via {@link ClientAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #clientAuthentication(ClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link ClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(ClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(ClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }

        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK
         * cluster to find its version. When this update operation is successful, it generates a new cluster version.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an
         *        MSK cluster to find its version. When this update operation is successful, it generates a new cluster
         *        version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * @param encryptionInfo
         *        <p>
         *        Includes all encryption-related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInfo(EncryptionInfo encryptionInfo);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link EncryptionInfo.Builder} avoiding the need
         * to create one manually via {@link EncryptionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionInfo(EncryptionInfo)}.
         * 
         * @param encryptionInfo
         *        a consumer that will call methods on {@link EncryptionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInfo(EncryptionInfo)
         */
        default Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return encryptionInfo(EncryptionInfo.builder().applyMutation(encryptionInfo).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private ClientAuthentication clientAuthentication;

        private String clusterArn;

        private String currentVersion;

        private EncryptionInfo encryptionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityRequest model) {
            super(model);
            clientAuthentication(model.clientAuthentication);
            clusterArn(model.clusterArn);
            currentVersion(model.currentVersion);
            encryptionInfo(model.encryptionInfo);
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return encryptionInfo != null ? encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityRequest build() {
            return new UpdateSecurityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
