/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ClusterOperationV2Summary;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response;

public class ListClusterOperationsV2Publisher
implements SdkPublisher<ListClusterOperationsV2Response> {
    private final KafkaAsyncClient client;
    private final ListClusterOperationsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterOperationsV2Publisher(KafkaAsyncClient client, ListClusterOperationsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterOperationsV2Publisher(KafkaAsyncClient client, ListClusterOperationsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterOperationsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterOperationsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterOperationV2Summary> clusterOperationInfoList() {
        Function<ListClusterOperationsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.clusterOperationInfoList() != null) {
                return response.clusterOperationInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClusterOperationsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClusterOperationsV2ResponseFetcher
    implements AsyncPageFetcher<ListClusterOperationsV2Response> {
        private ListClusterOperationsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterOperationsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterOperationsV2Response> nextPage(ListClusterOperationsV2Response previousPage) {
            if (previousPage == null) {
                return ListClusterOperationsV2Publisher.this.client.listClusterOperationsV2(ListClusterOperationsV2Publisher.this.firstRequest);
            }
            return ListClusterOperationsV2Publisher.this.client.listClusterOperationsV2((ListClusterOperationsV2Request)((Object)ListClusterOperationsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

