/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.kafka.model.BadRequestException;
import software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest;
import software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretResponse;
import software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest;
import software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretResponse;
import software.amazon.awssdk.services.kafka.model.ConflictException;
import software.amazon.awssdk.services.kafka.model.CreateClusterRequest;
import software.amazon.awssdk.services.kafka.model.CreateClusterResponse;
import software.amazon.awssdk.services.kafka.model.CreateClusterV2Request;
import software.amazon.awssdk.services.kafka.model.CreateClusterV2Response;
import software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest;
import software.amazon.awssdk.services.kafka.model.CreateReplicatorResponse;
import software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.CreateVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.DeleteClusterPolicyRequest;
import software.amazon.awssdk.services.kafka.model.DeleteClusterPolicyResponse;
import software.amazon.awssdk.services.kafka.model.DeleteClusterRequest;
import software.amazon.awssdk.services.kafka.model.DeleteClusterResponse;
import software.amazon.awssdk.services.kafka.model.DeleteConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.DeleteConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest;
import software.amazon.awssdk.services.kafka.model.DeleteReplicatorResponse;
import software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationRequest;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Request;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Response;
import software.amazon.awssdk.services.kafka.model.DescribeClusterRequest;
import software.amazon.awssdk.services.kafka.model.DescribeClusterResponse;
import software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request;
import software.amazon.awssdk.services.kafka.model.DescribeClusterV2Response;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionRequest;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse;
import software.amazon.awssdk.services.kafka.model.DescribeReplicatorRequest;
import software.amazon.awssdk.services.kafka.model.DescribeReplicatorResponse;
import software.amazon.awssdk.services.kafka.model.DescribeVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.DescribeVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.ForbiddenException;
import software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersRequest;
import software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse;
import software.amazon.awssdk.services.kafka.model.GetClusterPolicyRequest;
import software.amazon.awssdk.services.kafka.model.GetClusterPolicyResponse;
import software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest;
import software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsResponse;
import software.amazon.awssdk.services.kafka.model.InternalServerErrorException;
import software.amazon.awssdk.services.kafka.model.KafkaException;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response;
import software.amazon.awssdk.services.kafka.model.ListClustersRequest;
import software.amazon.awssdk.services.kafka.model.ListClustersResponse;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Request;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Response;
import software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse;
import software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse;
import software.amazon.awssdk.services.kafka.model.ListNodesRequest;
import software.amazon.awssdk.services.kafka.model.ListNodesResponse;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse;
import software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest;
import software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse;
import software.amazon.awssdk.services.kafka.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kafka.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse;
import software.amazon.awssdk.services.kafka.model.NotFoundException;
import software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest;
import software.amazon.awssdk.services.kafka.model.PutClusterPolicyResponse;
import software.amazon.awssdk.services.kafka.model.RebootBrokerRequest;
import software.amazon.awssdk.services.kafka.model.RebootBrokerResponse;
import software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kafka.model.TagResourceRequest;
import software.amazon.awssdk.services.kafka.model.TagResourceResponse;
import software.amazon.awssdk.services.kafka.model.TooManyRequestsException;
import software.amazon.awssdk.services.kafka.model.UnauthorizedException;
import software.amazon.awssdk.services.kafka.model.UntagResourceRequest;
import software.amazon.awssdk.services.kafka.model.UntagResourceResponse;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerCountResponse;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageResponse;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeRequest;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse;
import software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest;
import software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionResponse;
import software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest;
import software.amazon.awssdk.services.kafka.model.UpdateConnectivityResponse;
import software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest;
import software.amazon.awssdk.services.kafka.model.UpdateMonitoringResponse;
import software.amazon.awssdk.services.kafka.model.UpdateRebalancingRequest;
import software.amazon.awssdk.services.kafka.model.UpdateRebalancingResponse;
import software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest;
import software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoResponse;
import software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest;
import software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse;
import software.amazon.awssdk.services.kafka.model.UpdateStorageRequest;
import software.amazon.awssdk.services.kafka.model.UpdateStorageResponse;
import software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsIterable;
import software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsIterable;
import software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Iterable;
import software.amazon.awssdk.services.kafka.paginators.ListClustersIterable;
import software.amazon.awssdk.services.kafka.paginators.ListClustersV2Iterable;
import software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsIterable;
import software.amazon.awssdk.services.kafka.paginators.ListConfigurationsIterable;
import software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsIterable;
import software.amazon.awssdk.services.kafka.paginators.ListNodesIterable;
import software.amazon.awssdk.services.kafka.paginators.ListReplicatorsIterable;
import software.amazon.awssdk.services.kafka.paginators.ListScramSecretsIterable;
import software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsIterable;

/**
 * Service client for accessing Kafka. This can be created using the static {@link #builder()} method.
 *
 *
 * <p>
 * The operations for managing an Amazon MSK cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KafkaClient extends AwsClient {
    String SERVICE_NAME = "kafka";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kafka";

    /**
     *
     * <p>
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     * </p>
     * 
     *
     * @param batchAssociateScramSecretRequest
     *        <p>
     *        Associates sasl scram secrets to cluster.
     *        </p>
     * @return Result of the BatchAssociateScramSecret operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.BatchAssociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchAssociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateScramSecretResponse batchAssociateScramSecret(
            BatchAssociateScramSecretRequest batchAssociateScramSecretRequest) throws BadRequestException, UnauthorizedException,
            InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException,
            TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAssociateScramSecretRequest.Builder} avoiding
     * the need to create one manually via {@link BatchAssociateScramSecretRequest#builder()}
     * </p>
     *
     * @param batchAssociateScramSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest.Builder} to create a
     *        request.
     *        <p>
     *        Associates sasl scram secrets to cluster.
     *        </p>
     * @return Result of the BatchAssociateScramSecret operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.BatchAssociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchAssociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateScramSecretResponse batchAssociateScramSecret(
            Consumer<BatchAssociateScramSecretRequest.Builder> batchAssociateScramSecretRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return batchAssociateScramSecret(BatchAssociateScramSecretRequest.builder()
                .applyMutation(batchAssociateScramSecretRequest).build());
    }

    /**
     *
     * <p>
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     * </p>
     * 
     *
     * @param batchDisassociateScramSecretRequest
     *        <p>
     *        Disassociates sasl scram secrets to cluster.
     *        </p>
     * @return Result of the BatchDisassociateScramSecret operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.BatchDisassociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchDisassociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateScramSecretResponse batchDisassociateScramSecret(
            BatchDisassociateScramSecretRequest batchDisassociateScramSecretRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisassociateScramSecretRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDisassociateScramSecretRequest#builder()}
     * </p>
     *
     * @param batchDisassociateScramSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest.Builder} to create
     *        a request.
     *        <p>
     *        Disassociates sasl scram secrets to cluster.
     *        </p>
     * @return Result of the BatchDisassociateScramSecret operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.BatchDisassociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchDisassociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateScramSecretResponse batchDisassociateScramSecret(
            Consumer<BatchDisassociateScramSecretRequest.Builder> batchDisassociateScramSecretRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return batchDisassociateScramSecret(BatchDisassociateScramSecretRequest.builder()
                .applyMutation(batchDisassociateScramSecretRequest).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * 
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateClusterRequest.Builder} to create a request.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            KafkaException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * 
     *
     * @param createClusterV2Request
     * @return Result of the CreateClusterV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterV2Response createClusterV2(CreateClusterV2Request createClusterV2Request) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterV2Request.Builder} avoiding the need
     * to create one manually via {@link CreateClusterV2Request#builder()}
     * </p>
     *
     * @param createClusterV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateClusterV2Request.Builder} to create a request.
     * @return Result of the CreateClusterV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterV2Response createClusterV2(Consumer<CreateClusterV2Request.Builder> createClusterV2Request)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            KafkaException {
        return createClusterV2(CreateClusterV2Request.builder().applyMutation(createClusterV2Request).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK configuration.
     * </p>
     * 
     *
     * @param createConfigurationRequest
     * @return Result of the CreateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConfigurationResponse createConfiguration(CreateConfigurationRequest createConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationRequest#builder()}
     * </p>
     *
     * @param createConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConfigurationResponse createConfiguration(
            Consumer<CreateConfigurationRequest.Builder> createConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, KafkaException {
        return createConfiguration(CreateConfigurationRequest.builder().applyMutation(createConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates the replicator.
     * </p>
     *
     * @param createReplicatorRequest
     *        Creates a replicator using the specified configuration.
     * @return Result of the CreateReplicator operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This replicator name already exists. Retry your request with another
     *         name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReplicatorResponse createReplicator(CreateReplicatorRequest createReplicatorRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicatorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReplicatorRequest#builder()}
     * </p>
     *
     * @param createReplicatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest.Builder} to create a request.
     *        Creates a replicator using the specified configuration.
     * @return Result of the CreateReplicator operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. This replicator name already exists. Retry your request with another
     *         name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReplicatorResponse createReplicator(Consumer<CreateReplicatorRequest.Builder> createReplicatorRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, KafkaException {
        return createReplicator(CreateReplicatorRequest.builder().applyMutation(createReplicatorRequest).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK VPC connection.
     * </p>
     * 
     *
     * @param createVpcConnectionRequest
     * @return Result of the CreateVpcConnection operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpcConnectionResponse createVpcConnection(CreateVpcConnectionRequest createVpcConnectionRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK VPC connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVpcConnectionRequest#builder()}
     * </p>
     *
     * @param createVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVpcConnection operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.CreateVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpcConnectionResponse createVpcConnection(
            Consumer<CreateVpcConnectionRequest.Builder> createVpcConnectionRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return createVpcConnection(CreateVpcConnectionRequest.builder().applyMutation(createVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteClusterRequest.Builder} to create a request.
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param deleteClusterPolicyRequest
     * @return Result of the DeleteClusterPolicy operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterPolicyResponse deleteClusterPolicy(DeleteClusterPolicyRequest deleteClusterPolicyRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClusterPolicyRequest#builder()}
     * </p>
     *
     * @param deleteClusterPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteClusterPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteClusterPolicy operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterPolicyResponse deleteClusterPolicy(
            Consumer<DeleteClusterPolicyRequest.Builder> deleteClusterPolicyRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return deleteClusterPolicy(DeleteClusterPolicyRequest.builder().applyMutation(deleteClusterPolicyRequest).build());
    }

    /**
     *
     * <p>
     * Deletes an MSK Configuration.
     * </p>
     * 
     *
     * @param deleteConfigurationRequest
     * @return Result of the DeleteConfiguration operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConfigurationResponse deleteConfiguration(DeleteConfigurationRequest deleteConfigurationRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes an MSK Configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConfiguration operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConfigurationResponse deleteConfiguration(
            Consumer<DeleteConfigurationRequest.Builder> deleteConfigurationRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return deleteConfiguration(DeleteConfigurationRequest.builder().applyMutation(deleteConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a replicator.
     * </p>
     *
     * @param deleteReplicatorRequest
     * @return Result of the DeleteReplicator operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReplicatorResponse deleteReplicator(DeleteReplicatorRequest deleteReplicatorRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicatorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReplicatorRequest#builder()}
     * </p>
     *
     * @param deleteReplicatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest.Builder} to create a request.
     * @return Result of the DeleteReplicator operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReplicatorResponse deleteReplicator(Consumer<DeleteReplicatorRequest.Builder> deleteReplicatorRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return deleteReplicator(DeleteReplicatorRequest.builder().applyMutation(deleteReplicatorRequest).build());
    }

    /**
     *
     * <p>
     * Deletes a MSK VPC connection.
     * </p>
     * 
     *
     * @param deleteVpcConnectionRequest
     * @return Result of the DeleteVpcConnection operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpcConnectionResponse deleteVpcConnection(DeleteVpcConnectionRequest deleteVpcConnectionRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes a MSK VPC connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVpcConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVpcConnection operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DeleteVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpcConnectionResponse deleteVpcConnection(
            Consumer<DeleteVpcConnectionRequest.Builder> deleteVpcConnectionRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return deleteVpcConnection(DeleteVpcConnectionRequest.builder().applyMutation(deleteVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * 
     *
     * @param describeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws NotFoundException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterRequest.Builder} to create a request.
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest)
            throws NotFoundException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     * 
     *
     * @param describeClusterOperationRequest
     * @return Result of the DescribeClusterOperation operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeClusterOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterOperationResponse describeClusterOperation(
            DescribeClusterOperationRequest describeClusterOperationRequest) throws NotFoundException, BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterOperationRequest#builder()}
     * </p>
     *
     * @param describeClusterOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterOperationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterOperation operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeClusterOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterOperationResponse describeClusterOperation(
            Consumer<DescribeClusterOperationRequest.Builder> describeClusterOperationRequest) throws NotFoundException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return describeClusterOperation(DescribeClusterOperationRequest.builder().applyMutation(describeClusterOperationRequest)
                .build());
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     *
     *
     * @param describeClusterOperationV2Request
     * @return Result of the DescribeClusterOperationV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeClusterOperationV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperationV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterOperationV2Response describeClusterOperationV2(
            DescribeClusterOperationV2Request describeClusterOperationV2Request) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterOperationV2Request.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterOperationV2Request#builder()}
     * </p>
     *
     * @param describeClusterOperationV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Request.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterOperationV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeClusterOperationV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperationV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterOperationV2Response describeClusterOperationV2(
            Consumer<DescribeClusterOperationV2Request.Builder> describeClusterOperationV2Request) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return describeClusterOperationV2(DescribeClusterOperationV2Request.builder()
                .applyMutation(describeClusterOperationV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * 
     *
     * @param describeClusterV2Request
     * @return Result of the DescribeClusterV2 operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterV2Response describeClusterV2(DescribeClusterV2Request describeClusterV2Request)
            throws NotFoundException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterV2Request.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterV2Request#builder()}
     * </p>
     *
     * @param describeClusterV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request.Builder} to create a request.
     * @return Result of the DescribeClusterV2 operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterV2Response describeClusterV2(Consumer<DescribeClusterV2Request.Builder> describeClusterV2Request)
            throws NotFoundException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return describeClusterV2(DescribeClusterV2Request.builder().applyMutation(describeClusterV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a description of this MSK configuration.
     * </p>
     * 
     *
     * @param describeConfigurationRequest
     * @return Result of the DescribeConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigurationResponse describeConfiguration(DescribeConfigurationRequest describeConfigurationRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of this MSK configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigurationResponse describeConfiguration(
            Consumer<DescribeConfigurationRequest.Builder> describeConfigurationRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return describeConfiguration(DescribeConfigurationRequest.builder().applyMutation(describeConfigurationRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of this revision of the configuration.
     * </p>
     * 
     *
     * @param describeConfigurationRevisionRequest
     * @return Result of the DescribeConfigurationRevision operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeConfigurationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRevisionResponse describeConfigurationRevision(
            DescribeConfigurationRevisionRequest describeConfigurationRevisionRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of this revision of the configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRevisionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRevisionRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeConfigurationRevision operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeConfigurationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRevisionResponse describeConfigurationRevision(
            Consumer<DescribeConfigurationRevisionRequest.Builder> describeConfigurationRevisionRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return describeConfigurationRevision(DescribeConfigurationRevisionRequest.builder()
                .applyMutation(describeConfigurationRevisionRequest).build());
    }

    /**
     * <p>
     * Describes a replicator.
     * </p>
     *
     * @param describeReplicatorRequest
     * @return Result of the DescribeReplicator operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicatorResponse describeReplicator(DescribeReplicatorRequest describeReplicatorRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicatorRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReplicatorRequest#builder()}
     * </p>
     *
     * @param describeReplicatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeReplicatorRequest.Builder} to create a request.
     * @return Result of the DescribeReplicator operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicatorResponse describeReplicator(Consumer<DescribeReplicatorRequest.Builder> describeReplicatorRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return describeReplicator(DescribeReplicatorRequest.builder().applyMutation(describeReplicatorRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of this MSK VPC connection.
     * </p>
     * 
     *
     * @param describeVpcConnectionRequest
     * @return Result of the DescribeVpcConnection operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeVpcConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVpcConnectionResponse describeVpcConnection(DescribeVpcConnectionRequest describeVpcConnectionRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of this MSK VPC connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVpcConnectionRequest#builder()}
     * </p>
     *
     * @param describeVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeVpcConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeVpcConnection operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.DescribeVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeVpcConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVpcConnectionResponse describeVpcConnection(
            Consumer<DescribeVpcConnectionRequest.Builder> describeVpcConnectionRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return describeVpcConnection(DescribeVpcConnectionRequest.builder().applyMutation(describeVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * A list of brokers that a client application can use to bootstrap. This list doesn't necessarily include all of
     * the brokers in the cluster. The following Python 3.6 example shows how you can use the Amazon Resource Name (ARN)
     * of a cluster to get its bootstrap brokers. If you don't know the ARN of your cluster, you can use the
     * <code>ListClusters</code> operation to get the ARNs of all the clusters in this account and Region.
     * </p>
     * 
     *
     * @param getBootstrapBrokersRequest
     * @return Result of the GetBootstrapBrokers operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.GetBootstrapBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBootstrapBrokersResponse getBootstrapBrokers(GetBootstrapBrokersRequest getBootstrapBrokersRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ConflictException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * A list of brokers that a client application can use to bootstrap. This list doesn't necessarily include all of
     * the brokers in the cluster. The following Python 3.6 example shows how you can use the Amazon Resource Name (ARN)
     * of a cluster to get its bootstrap brokers. If you don't know the ARN of your cluster, you can use the
     * <code>ListClusters</code> operation to get the ARNs of all the clusters in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBootstrapBrokersRequest.Builder} avoiding the
     * need to create one manually via {@link GetBootstrapBrokersRequest#builder()}
     * </p>
     *
     * @param getBootstrapBrokersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersRequest.Builder} to create a
     *        request.
     * @return Result of the GetBootstrapBrokers operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.GetBootstrapBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBootstrapBrokersResponse getBootstrapBrokers(
            Consumer<GetBootstrapBrokersRequest.Builder> getBootstrapBrokersRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return getBootstrapBrokers(GetBootstrapBrokersRequest.builder().applyMutation(getBootstrapBrokersRequest).build());
    }

    /**
     *
     * <p>
     * Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param getClusterPolicyRequest
     * @return Result of the GetClusterPolicy operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.GetClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClusterPolicyResponse getClusterPolicy(GetClusterPolicyRequest getClusterPolicyRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetClusterPolicyRequest#builder()}
     * </p>
     *
     * @param getClusterPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.GetClusterPolicyRequest.Builder} to create a request.
     * @return Result of the GetClusterPolicy operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.GetClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClusterPolicyResponse getClusterPolicy(Consumer<GetClusterPolicyRequest.Builder> getClusterPolicyRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return getClusterPolicy(GetClusterPolicyRequest.builder().applyMutation(getClusterPolicyRequest).build());
    }

    /**
     *
     * <p>
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     * </p>
     * 
     *
     * @param getCompatibleKafkaVersionsRequest
     * @return Result of the GetCompatibleKafkaVersions operation returned by the service.
     * @throws BadRequestException
     *         n
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         n
     * @throws UnauthorizedException
     *         n
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         n
     * @throws InternalServerErrorException
     *         n
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         n
     * @throws ForbiddenException
     *         n
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         n
     * @throws NotFoundException
     *         n
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         n
     * @throws ServiceUnavailableException
     *         n
     *         <p>
     *         503 response
     *         </p>
     *         n
     * @throws TooManyRequestsException
     *         n
     *         <p>
     *         429 response
     *         </p>
     *         n
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.GetCompatibleKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCompatibleKafkaVersionsResponse getCompatibleKafkaVersions(
            GetCompatibleKafkaVersionsRequest getCompatibleKafkaVersionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCompatibleKafkaVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCompatibleKafkaVersionsRequest#builder()}
     * </p>
     *
     * @param getCompatibleKafkaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetCompatibleKafkaVersions operation returned by the service.
     * @throws BadRequestException
     *         n
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         n
     * @throws UnauthorizedException
     *         n
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         n
     * @throws InternalServerErrorException
     *         n
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         n
     * @throws ForbiddenException
     *         n
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         n
     * @throws NotFoundException
     *         n
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         n
     * @throws ServiceUnavailableException
     *         n
     *         <p>
     *         503 response
     *         </p>
     *         n
     * @throws TooManyRequestsException
     *         n
     *         <p>
     *         429 response
     *         </p>
     *         n
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.GetCompatibleKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCompatibleKafkaVersionsResponse getCompatibleKafkaVersions(
            Consumer<GetCompatibleKafkaVersionsRequest.Builder> getCompatibleKafkaVersionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest.builder()
                .applyMutation(getCompatibleKafkaVersionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * 
     *
     * @param listClientVpcConnectionsRequest
     * @return Result of the ListClientVpcConnections operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientVpcConnectionsResponse listClientVpcConnections(
            ListClientVpcConnectionsRequest listClientVpcConnectionsRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClientVpcConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListClientVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listClientVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListClientVpcConnections operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientVpcConnectionsResponse listClientVpcConnections(
            Consumer<ListClientVpcConnectionsRequest.Builder> listClientVpcConnectionsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return listClientVpcConnections(ListClientVpcConnectionsRequest.builder().applyMutation(listClientVpcConnectionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsIterable responses = client.listClientVpcConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsIterable responses = client
     *             .listClientVpcConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsIterable responses = client.listClientVpcConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClientVpcConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientVpcConnectionsIterable listClientVpcConnectionsPaginator(
            ListClientVpcConnectionsRequest listClientVpcConnectionsRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return new ListClientVpcConnectionsIterable(this, listClientVpcConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsIterable responses = client.listClientVpcConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsIterable responses = client
     *             .listClientVpcConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsIterable responses = client.listClientVpcConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClientVpcConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListClientVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listClientVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientVpcConnectionsIterable listClientVpcConnectionsPaginator(
            Consumer<ListClientVpcConnectionsRequest.Builder> listClientVpcConnectionsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return listClientVpcConnectionsPaginator(ListClientVpcConnectionsRequest.builder()
                .applyMutation(listClientVpcConnectionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * 
     *
     * @param listClusterOperationsRequest
     * @return Result of the ListClusterOperations operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsResponse listClusterOperations(ListClusterOperationsRequest listClusterOperationsRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterOperationsRequest#builder()}
     * </p>
     *
     * @param listClusterOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListClusterOperations operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsResponse listClusterOperations(
            Consumer<ListClusterOperationsRequest.Builder> listClusterOperationsRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return listClusterOperations(ListClusterOperationsRequest.builder().applyMutation(listClusterOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsIterable responses = client.listClusterOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsIterable responses = client
     *             .listClusterOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsIterable responses = client.listClusterOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClusterOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsIterable listClusterOperationsPaginator(ListClusterOperationsRequest listClusterOperationsRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return new ListClusterOperationsIterable(this, listClusterOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsIterable responses = client.listClusterOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsIterable responses = client
     *             .listClusterOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsIterable responses = client.listClusterOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterOperationsRequest#builder()}
     * </p>
     *
     * @param listClusterOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsIterable listClusterOperationsPaginator(
            Consumer<ListClusterOperationsRequest.Builder> listClusterOperationsRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return listClusterOperationsPaginator(ListClusterOperationsRequest.builder().applyMutation(listClusterOperationsRequest)
                .build());
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * 
     *
     * @param listClusterOperationsV2Request
     * @return Result of the ListClusterOperationsV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsV2Response listClusterOperationsV2(ListClusterOperationsV2Request listClusterOperationsV2Request)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsV2Request.Builder} avoiding
     * the need to create one manually via {@link ListClusterOperationsV2Request#builder()}
     * </p>
     *
     * @param listClusterOperationsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request.Builder} to create a
     *        request.
     * @return Result of the ListClusterOperationsV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsV2Response listClusterOperationsV2(
            Consumer<ListClusterOperationsV2Request.Builder> listClusterOperationsV2Request) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return listClusterOperationsV2(ListClusterOperationsV2Request.builder().applyMutation(listClusterOperationsV2Request)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Iterable responses = client.listClusterOperationsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Iterable responses = client
     *             .listClusterOperationsV2Paginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Iterable responses = client.listClusterOperationsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation.</b>
     * </p>
     *
     * @param listClusterOperationsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsV2Iterable listClusterOperationsV2Paginator(
            ListClusterOperationsV2Request listClusterOperationsV2Request) throws BadRequestException, UnauthorizedException,
            InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException,
            TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return new ListClusterOperationsV2Iterable(this, listClusterOperationsV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Iterable responses = client.listClusterOperationsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Iterable responses = client
     *             .listClusterOperationsV2Paginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Iterable responses = client.listClusterOperationsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsV2Request.Builder} avoiding
     * the need to create one manually via {@link ListClusterOperationsV2Request#builder()}
     * </p>
     *
     * @param listClusterOperationsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsV2Iterable listClusterOperationsV2Paginator(
            Consumer<ListClusterOperationsV2Request.Builder> listClusterOperationsV2Request) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return listClusterOperationsV2Paginator(ListClusterOperationsV2Request.builder()
                .applyMutation(listClusterOperationsV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * 
     *
     * @param listClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersRequest.Builder} to create a request.
     * @return Result of the ListClusters operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * 
     *
     * @return Result of the ListClusters operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusters
     * @see #listClusters(ListClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters() throws BadRequestException, InternalServerErrorException, UnauthorizedException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return listClusters(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusters
     * @see #listClustersPaginator(ListClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator() throws BadRequestException, InternalServerErrorException,
            UnauthorizedException, ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return listClustersPaginator(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return new ListClustersIterable(this, listClustersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * 
     *
     * @param listClustersV2Request
     * @return Result of the ListClustersV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersV2Response listClustersV2(ListClustersV2Request listClustersV2Request) throws BadRequestException,
            InternalServerErrorException, UnauthorizedException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersV2Request.Builder} avoiding the need to
     * create one manually via {@link ListClustersV2Request#builder()}
     * </p>
     *
     * @param listClustersV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersV2Request.Builder} to create a request.
     * @return Result of the ListClustersV2 operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersV2Response listClustersV2(Consumer<ListClustersV2Request.Builder> listClustersV2Request)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return listClustersV2(ListClustersV2Request.builder().applyMutation(listClustersV2Request).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Iterable responses = client.listClustersV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClustersV2Iterable responses = client.listClustersV2Paginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClustersV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Iterable responses = client.listClustersV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)} operation.</b>
     * </p>
     *
     * @param listClustersV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersV2Iterable listClustersV2Paginator(ListClustersV2Request listClustersV2Request)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return new ListClustersV2Iterable(this, listClustersV2Request);
    }

    /**
     * <p>
     * This is a variant of {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Iterable responses = client.listClustersV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListClustersV2Iterable responses = client.listClustersV2Paginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListClustersV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Iterable responses = client.listClustersV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersV2Request.Builder} avoiding the need to
     * create one manually via {@link ListClustersV2Request#builder()}
     * </p>
     *
     * @param listClustersV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersV2Request.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersV2Iterable listClustersV2Paginator(Consumer<ListClustersV2Request.Builder> listClustersV2Request)
            throws BadRequestException, InternalServerErrorException, UnauthorizedException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return listClustersV2Paginator(ListClustersV2Request.builder().applyMutation(listClustersV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * 
     *
     * @param listConfigurationRevisionsRequest
     * @return Result of the ListConfigurationRevisions operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationRevisionsResponse listConfigurationRevisions(
            ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationRevisionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConfigurationRevisions operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationRevisionsResponse listConfigurationRevisions(
            Consumer<ListConfigurationRevisionsRequest.Builder> listConfigurationRevisionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return listConfigurationRevisions(ListConfigurationRevisionsRequest.builder()
                .applyMutation(listConfigurationRevisionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsIterable responses = client.listConfigurationRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsIterable responses = client
     *             .listConfigurationRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsIterable responses = client.listConfigurationRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationRevisionsIterable listConfigurationRevisionsPaginator(
            ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return new ListConfigurationRevisionsIterable(this, listConfigurationRevisionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsIterable responses = client.listConfigurationRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsIterable responses = client
     *             .listConfigurationRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsIterable responses = client.listConfigurationRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationRevisionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationRevisionsIterable listConfigurationRevisionsPaginator(
            Consumer<ListConfigurationRevisionsRequest.Builder> listConfigurationRevisionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return listConfigurationRevisionsPaginator(ListConfigurationRevisionsRequest.builder()
                .applyMutation(listConfigurationRevisionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * 
     *
     * @param listConfigurationsRequest
     * @return Result of the ListConfigurations operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsResponse listConfigurations(ListConfigurationsRequest listConfigurationsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest.Builder} to create a request.
     * @return Result of the ListConfigurations operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsResponse listConfigurations(Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return listConfigurations(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsIterable responses = client.listConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListConfigurationsIterable responses = client
     *             .listConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsIterable responses = client.listConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation.</b>
     * </p>
     *
     * @param listConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsIterable listConfigurationsPaginator(ListConfigurationsRequest listConfigurationsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return new ListConfigurationsIterable(this, listConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsIterable responses = client.listConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListConfigurationsIterable responses = client
     *             .listConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsIterable responses = client.listConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsIterable listConfigurationsPaginator(
            Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return listConfigurationsPaginator(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of Apache Kafka versions.
     * </p>
     * 
     *
     * @param listKafkaVersionsRequest
     * @return Result of the ListKafkaVersions operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKafkaVersionsResponse listKafkaVersions(ListKafkaVersionsRequest listKafkaVersionsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of Apache Kafka versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKafkaVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKafkaVersionsRequest#builder()}
     * </p>
     *
     * @param listKafkaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest.Builder} to create a request.
     * @return Result of the ListKafkaVersions operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKafkaVersionsResponse listKafkaVersions(Consumer<ListKafkaVersionsRequest.Builder> listKafkaVersionsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return listKafkaVersions(ListKafkaVersionsRequest.builder().applyMutation(listKafkaVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsIterable responses = client.listKafkaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsIterable responses = client
     *             .listKafkaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsIterable responses = client.listKafkaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listKafkaVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKafkaVersionsIterable listKafkaVersionsPaginator(ListKafkaVersionsRequest listKafkaVersionsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            AwsServiceException, SdkClientException, KafkaException {
        return new ListKafkaVersionsIterable(this, listKafkaVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsIterable responses = client.listKafkaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsIterable responses = client
     *             .listKafkaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsIterable responses = client.listKafkaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKafkaVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKafkaVersionsRequest#builder()}
     * </p>
     *
     * @param listKafkaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKafkaVersionsIterable listKafkaVersionsPaginator(
            Consumer<ListKafkaVersionsRequest.Builder> listKafkaVersionsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return listKafkaVersionsPaginator(ListKafkaVersionsRequest.builder().applyMutation(listKafkaVersionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of the broker nodes in the cluster.
     * </p>
     * 
     *
     * @param listNodesRequest
     * @return Result of the ListNodes operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of the broker nodes in the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListNodesRequest.Builder} to create a request.
     * @return Result of the ListNodes operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesResponse listNodes(Consumer<ListNodesRequest.Builder> listNodesRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return listNodes(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.</b>
     * </p>
     *
     * @param listNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(ListNodesRequest listNodesRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return new ListNodesIterable(this, listNodesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesIterable responses = client.listNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListNodesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesIterable listNodesPaginator(Consumer<ListNodesRequest.Builder> listNodesRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            KafkaException {
        return listNodesPaginator(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Lists the replicators.
     * </p>
     *
     * @param listReplicatorsRequest
     * @return Result of the ListReplicators operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReplicatorsResponse listReplicators(ListReplicatorsRequest listReplicatorsRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the replicators.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReplicatorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReplicatorsRequest#builder()}
     * </p>
     *
     * @param listReplicatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest.Builder} to create a request.
     * @return Result of the ListReplicators operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReplicatorsResponse listReplicators(Consumer<ListReplicatorsRequest.Builder> listReplicatorsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return listReplicators(ListReplicatorsRequest.builder().applyMutation(listReplicatorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsIterable responses = client.listReplicatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListReplicatorsIterable responses = client.listReplicatorsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsIterable responses = client.listReplicatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)} operation.</b>
     * </p>
     *
     * @param listReplicatorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReplicatorsIterable listReplicatorsPaginator(ListReplicatorsRequest listReplicatorsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return new ListReplicatorsIterable(this, listReplicatorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsIterable responses = client.listReplicatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListReplicatorsIterable responses = client.listReplicatorsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsIterable responses = client.listReplicatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReplicatorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReplicatorsRequest#builder()}
     * </p>
     *
     * @param listReplicatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReplicatorsIterable listReplicatorsPaginator(Consumer<ListReplicatorsRequest.Builder> listReplicatorsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return listReplicatorsPaginator(ListReplicatorsRequest.builder().applyMutation(listReplicatorsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     * </p>
     * 
     *
     * @param listScramSecretsRequest
     * @return Result of the ListScramSecrets operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScramSecretsResponse listScramSecrets(ListScramSecretsRequest listScramSecretsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScramSecretsRequest.Builder} avoiding the need
     * to create one manually via {@link ListScramSecretsRequest#builder()}
     * </p>
     *
     * @param listScramSecretsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest.Builder} to create a request.
     * @return Result of the ListScramSecrets operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScramSecretsResponse listScramSecrets(Consumer<ListScramSecretsRequest.Builder> listScramSecretsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return listScramSecrets(ListScramSecretsRequest.builder().applyMutation(listScramSecretsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsIterable responses = client.listScramSecretsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListScramSecretsIterable responses = client
     *             .listScramSecretsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsIterable responses = client.listScramSecretsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation.</b>
     * </p>
     *
     * @param listScramSecretsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScramSecretsIterable listScramSecretsPaginator(ListScramSecretsRequest listScramSecretsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return new ListScramSecretsIterable(this, listScramSecretsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsIterable responses = client.listScramSecretsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListScramSecretsIterable responses = client
     *             .listScramSecretsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsIterable responses = client.listScramSecretsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScramSecretsRequest.Builder} avoiding the need
     * to create one manually via {@link ListScramSecretsRequest#builder()}
     * </p>
     *
     * @param listScramSecretsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScramSecretsIterable listScramSecretsPaginator(Consumer<ListScramSecretsRequest.Builder> listScramSecretsRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return listScramSecretsPaginator(ListScramSecretsRequest.builder().applyMutation(listScramSecretsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of the tags associated with the specified resource.
     * </p>
     * 
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of the tags associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * 
     *
     * @param listVpcConnectionsRequest
     * @return Result of the ListVpcConnections operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVpcConnectionsResponse listVpcConnections(ListVpcConnectionsRequest listVpcConnectionsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest.Builder} to create a request.
     * @return Result of the ListVpcConnections operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVpcConnectionsResponse listVpcConnections(Consumer<ListVpcConnectionsRequest.Builder> listVpcConnectionsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return listVpcConnections(ListVpcConnectionsRequest.builder().applyMutation(listVpcConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsIterable responses = client.listVpcConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsIterable responses = client
     *             .listVpcConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsIterable responses = client.listVpcConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation.</b>
     * </p>
     *
     * @param listVpcConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVpcConnectionsIterable listVpcConnectionsPaginator(ListVpcConnectionsRequest listVpcConnectionsRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return new ListVpcConnectionsIterable(this, listVpcConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsIterable responses = client.listVpcConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsIterable responses = client
     *             .listVpcConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsIterable responses = client.listVpcConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVpcConnectionsIterable listVpcConnectionsPaginator(
            Consumer<ListVpcConnectionsRequest.Builder> listVpcConnectionsRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return listVpcConnectionsPaginator(ListVpcConnectionsRequest.builder().applyMutation(listVpcConnectionsRequest).build());
    }

    /**
     *
     * <p>
     * Creates or updates the MSK cluster policy specified by the cluster Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param putClusterPolicyRequest
     * @return Result of the PutClusterPolicy operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.PutClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/PutClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutClusterPolicyResponse putClusterPolicy(PutClusterPolicyRequest putClusterPolicyRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates or updates the MSK cluster policy specified by the cluster Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutClusterPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutClusterPolicyRequest#builder()}
     * </p>
     *
     * @param putClusterPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest.Builder} to create a request.
     * @return Result of the PutClusterPolicy operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.PutClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/PutClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutClusterPolicyResponse putClusterPolicy(Consumer<PutClusterPolicyRequest.Builder> putClusterPolicyRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return putClusterPolicy(PutClusterPolicyRequest.builder().applyMutation(putClusterPolicyRequest).build());
    }

    /**
     * Reboots brokers.
     *
     * @param rebootBrokerRequest
     *        Reboots a node.
     * @return Result of the RebootBroker operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.RebootBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootBrokerResponse rebootBroker(RebootBrokerRequest rebootBrokerRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     * Reboots brokers.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link RebootBrokerRequest#builder()}
     * </p>
     *
     * @param rebootBrokerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.RebootBrokerRequest.Builder} to create a request.
     *        Reboots a node.
     * @return Result of the RebootBroker operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.RebootBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootBrokerResponse rebootBroker(Consumer<RebootBrokerRequest.Builder> rebootBrokerRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return rebootBroker(RebootBrokerRequest.builder().applyMutation(rebootBrokerRequest).build());
    }

    /**
     *
     * <p>
     * Returns empty response.
     * </p>
     * 
     *
     * @param rejectClientVpcConnectionRequest
     * @return Result of the RejectClientVpcConnection operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.RejectClientVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RejectClientVpcConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectClientVpcConnectionResponse rejectClientVpcConnection(
            RejectClientVpcConnectionRequest rejectClientVpcConnectionRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns empty response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectClientVpcConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link RejectClientVpcConnectionRequest#builder()}
     * </p>
     *
     * @param rejectClientVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the RejectClientVpcConnection operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.RejectClientVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RejectClientVpcConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectClientVpcConnectionResponse rejectClientVpcConnection(
            Consumer<RejectClientVpcConnectionRequest.Builder> rejectClientVpcConnectionRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return rejectClientVpcConnection(RejectClientVpcConnectionRequest.builder()
                .applyMutation(rejectClientVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * Adds tags to the specified MSK resource.
     * </p>
     * 
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Adds tags to the specified MSK resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     *
     * <p>
     * Removes the tags associated with the keys that are provided in the query.
     * </p>
     * 
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Removes the tags associated with the keys that are provided in the query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException,
            KafkaException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     *
     * <p>
     * Updates the number of broker nodes in the cluster.
     * </p>
     * 
     *
     * @param updateBrokerCountRequest
     * @return Result of the UpdateBrokerCount operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateBrokerCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerCountResponse updateBrokerCount(UpdateBrokerCountRequest updateBrokerCountRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the number of broker nodes in the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerCountRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBrokerCountRequest#builder()}
     * </p>
     *
     * @param updateBrokerCountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest.Builder} to create a request.
     * @return Result of the UpdateBrokerCount operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateBrokerCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerCountResponse updateBrokerCount(Consumer<UpdateBrokerCountRequest.Builder> updateBrokerCountRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return updateBrokerCount(UpdateBrokerCountRequest.builder().applyMutation(updateBrokerCountRequest).build());
    }

    /**
     *
     * <p>
     * Updates the EBS storage associated with MSK brokers.
     * </p>
     * 
     *
     * @param updateBrokerStorageRequest
     * @return Result of the UpdateBrokerStorage operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateBrokerStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerStorageResponse updateBrokerStorage(UpdateBrokerStorageRequest updateBrokerStorageRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the EBS storage associated with MSK brokers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerStorageRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBrokerStorageRequest#builder()}
     * </p>
     *
     * @param updateBrokerStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBrokerStorage operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateBrokerStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerStorageResponse updateBrokerStorage(
            Consumer<UpdateBrokerStorageRequest.Builder> updateBrokerStorageRequest) throws ServiceUnavailableException,
            BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, KafkaException {
        return updateBrokerStorage(UpdateBrokerStorageRequest.builder().applyMutation(updateBrokerStorageRequest).build());
    }

    /**
     *
     * <p>
     * Updates EC2 instance type.
     * </p>
     * 
     *
     * @param updateBrokerTypeRequest
     * @return Result of the UpdateBrokerType operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateBrokerType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerType" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerTypeResponse updateBrokerType(UpdateBrokerTypeRequest updateBrokerTypeRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates EC2 instance type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerTypeRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBrokerTypeRequest#builder()}
     * </p>
     *
     * @param updateBrokerTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeRequest.Builder} to create a request.
     * @return Result of the UpdateBrokerType operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateBrokerType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerType" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBrokerTypeResponse updateBrokerType(Consumer<UpdateBrokerTypeRequest.Builder> updateBrokerTypeRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return updateBrokerType(UpdateBrokerTypeRequest.builder().applyMutation(updateBrokerTypeRequest).build());
    }

    /**
     *
     * <p>
     * Updates the cluster with the configuration that is specified in the request body.
     * </p>
     * 
     *
     * @param updateClusterConfigurationRequest
     * @return Result of the UpdateClusterConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateClusterConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateClusterConfigurationResponse updateClusterConfiguration(
            UpdateClusterConfigurationRequest updateClusterConfigurationRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the cluster with the configuration that is specified in the request body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateClusterConfigurationRequest#builder()}
     * </p>
     *
     * @param updateClusterConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateClusterConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateClusterConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateClusterConfigurationResponse updateClusterConfiguration(
            Consumer<UpdateClusterConfigurationRequest.Builder> updateClusterConfigurationRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return updateClusterConfiguration(UpdateClusterConfigurationRequest.builder()
                .applyMutation(updateClusterConfigurationRequest).build());
    }

    /**
     *
     * <p>
     * Updates the Apache Kafka version for the cluster.
     * </p>
     * 
     *
     * @param updateClusterKafkaVersionRequest
     * @return Result of the UpdateClusterKafkaVersion operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateClusterKafkaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateClusterKafkaVersionResponse updateClusterKafkaVersion(
            UpdateClusterKafkaVersionRequest updateClusterKafkaVersionRequest) throws BadRequestException, UnauthorizedException,
            InternalServerErrorException, ForbiddenException, NotFoundException, ServiceUnavailableException,
            TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the Apache Kafka version for the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterKafkaVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateClusterKafkaVersionRequest#builder()}
     * </p>
     *
     * @param updateClusterKafkaVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateClusterKafkaVersion operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateClusterKafkaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateClusterKafkaVersionResponse updateClusterKafkaVersion(
            Consumer<UpdateClusterKafkaVersionRequest.Builder> updateClusterKafkaVersionRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest.builder()
                .applyMutation(updateClusterKafkaVersionRequest).build());
    }

    /**
     *
     * <p>
     * Updates an MSK configuration.
     * </p>
     * 
     *
     * @param updateConfigurationRequest
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates an MSK configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateConfiguration operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConfigurationResponse updateConfiguration(
            Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return updateConfiguration(UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest).build());
    }

    /**
     *
     * <p>
     * Updates the cluster's connectivity configuration.
     * </p>
     * 
     *
     * @param updateConnectivityRequest
     *        Request body for UpdateConnectivity.
     * @return Result of the UpdateConnectivity operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateConnectivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConnectivity" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConnectivityResponse updateConnectivity(UpdateConnectivityRequest updateConnectivityRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the cluster's connectivity configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectivityRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConnectivityRequest#builder()}
     * </p>
     *
     * @param updateConnectivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest.Builder} to create a request.
     *        Request body for UpdateConnectivity.
     * @return Result of the UpdateConnectivity operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateConnectivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConnectivity" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConnectivityResponse updateConnectivity(Consumer<UpdateConnectivityRequest.Builder> updateConnectivityRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, KafkaException {
        return updateConnectivity(UpdateConnectivityRequest.builder().applyMutation(updateConnectivityRequest).build());
    }

    /**
     *
     * <p>
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics
     * you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with
     * Prometheus.
     * </p>
     * 
     *
     * @param updateMonitoringRequest
     *        Request body for UpdateMonitoring.
     * @return Result of the UpdateMonitoring operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMonitoringResponse updateMonitoring(UpdateMonitoringRequest updateMonitoringRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics
     * you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with
     * Prometheus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMonitoringRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMonitoringRequest#builder()}
     * </p>
     *
     * @param updateMonitoringRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest.Builder} to create a request.
     *        Request body for UpdateMonitoring.
     * @return Result of the UpdateMonitoring operation returned by the service.
     * @throws ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMonitoringResponse updateMonitoring(Consumer<UpdateMonitoringRequest.Builder> updateMonitoringRequest)
            throws ServiceUnavailableException, BadRequestException, UnauthorizedException, InternalServerErrorException,
            ForbiddenException, AwsServiceException, SdkClientException, KafkaException {
        return updateMonitoring(UpdateMonitoringRequest.builder().applyMutation(updateMonitoringRequest).build());
    }

    /**
     *
     * <p>
     * Use this resource to update the intelligent rebalancing status of an Amazon MSK Provisioned cluster with Express
     * brokers.
     * </p>
     * 
     *
     * @param updateRebalancingRequest
     * @return Result of the UpdateRebalancing operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         The service cannot complete the request.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         The request throughput limit was exceeded.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateRebalancing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateRebalancing" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRebalancingResponse updateRebalancing(UpdateRebalancingRequest updateRebalancingRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Use this resource to update the intelligent rebalancing status of an Amazon MSK Provisioned cluster with Express
     * brokers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRebalancingRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRebalancingRequest#builder()}
     * </p>
     *
     * @param updateRebalancingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateRebalancingRequest.Builder} to create a request.
     * @return Result of the UpdateRebalancing operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         The service cannot complete the request.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         The request throughput limit was exceeded.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateRebalancing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateRebalancing" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRebalancingResponse updateRebalancing(Consumer<UpdateRebalancingRequest.Builder> updateRebalancingRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return updateRebalancing(UpdateRebalancingRequest.builder().applyMutation(updateRebalancingRequest).build());
    }

    /**
     * <p>
     * Updates replication info of a replicator.
     * </p>
     *
     * @param updateReplicationInfoRequest
     *        Update information relating to replication between a given source and target Kafka cluster.
     * @return Result of the UpdateReplicationInfo operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateReplicationInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateReplicationInfo" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateReplicationInfoResponse updateReplicationInfo(UpdateReplicationInfoRequest updateReplicationInfoRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates replication info of a replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationInfoRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateReplicationInfoRequest#builder()}
     * </p>
     *
     * @param updateReplicationInfoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest.Builder} to create a
     *        request. Update information relating to replication between a given source and target Kafka cluster.
     * @return Result of the UpdateReplicationInfo operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateReplicationInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateReplicationInfo" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateReplicationInfoResponse updateReplicationInfo(
            Consumer<UpdateReplicationInfoRequest.Builder> updateReplicationInfoRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        return updateReplicationInfo(UpdateReplicationInfoRequest.builder().applyMutation(updateReplicationInfoRequest).build());
    }

    /**
     *
     * <p>
     * Updates the security settings for the cluster. You can use this operation to specify encryption and
     * authentication on existing clusters.
     * </p>
     * 
     *
     * @param updateSecurityRequest
     * @return Result of the UpdateSecurity operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         The service cannot complete the request.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         The request throughput limit was exceeded.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateSecurity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateSecurity" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSecurityResponse updateSecurity(UpdateSecurityRequest updateSecurityRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the security settings for the cluster. You can use this operation to specify encryption and
     * authentication on existing clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSecurityRequest#builder()}
     * </p>
     *
     * @param updateSecurityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest.Builder} to create a request.
     * @return Result of the UpdateSecurity operation returned by the service.
     * @throws BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     * @throws UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     * @throws InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     * @throws ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     * @throws NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     * @throws ServiceUnavailableException
     *         <p>
     *         The service cannot complete the request.
     *         </p>
     * @throws TooManyRequestsException
     *         <p>
     *         The request throughput limit was exceeded.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateSecurity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateSecurity" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSecurityResponse updateSecurity(Consumer<UpdateSecurityRequest.Builder> updateSecurityRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return updateSecurity(UpdateSecurityRequest.builder().applyMutation(updateSecurityRequest).build());
    }

    /**
     * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
     *
     * @param updateStorageRequest
     *        <p>
     *        Request object for UpdateStorage api. Its used to update the storage attributes for the cluster.
     *        </p>
     * @return Result of the UpdateStorage operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStorageResponse updateStorage(UpdateStorageRequest updateStorageRequest) throws BadRequestException,
            UnauthorizedException, InternalServerErrorException, ForbiddenException, NotFoundException,
            ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException, KafkaException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStorageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStorageRequest#builder()}
     * </p>
     *
     * @param updateStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateStorageRequest.Builder} to create a request.
     *        <p>
     *        Request object for UpdateStorage api. Its used to update the storage attributes for the cluster.
     *        </p>
     * @return Result of the UpdateStorage operation returned by the service.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaClient.UpdateStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStorageResponse updateStorage(Consumer<UpdateStorageRequest.Builder> updateStorageRequest)
            throws BadRequestException, UnauthorizedException, InternalServerErrorException, ForbiddenException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            KafkaException {
        return updateStorage(UpdateStorageRequest.builder().applyMutation(updateStorageRequest).build());
    }

    /**
     * Create a {@link KafkaClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KafkaClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KafkaClient}.
     */
    static KafkaClientBuilder builder() {
        return new DefaultKafkaClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default KafkaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
