/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends KafkaRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField
            .<BrokerNodeGroupInfo> builder(MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo")
            .getter(getter(CreateClusterRequest::brokerNodeGroupInfo)).setter(setter(Builder::brokerNodeGroupInfo))
            .constructor(BrokerNodeGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build())
            .build();

    private static final SdkField<Rebalancing> REBALANCING_FIELD = SdkField.<Rebalancing> builder(MarshallingType.SDK_POJO)
            .memberName("Rebalancing").getter(getter(CreateClusterRequest::rebalancing)).setter(setter(Builder::rebalancing))
            .constructor(Rebalancing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rebalancing").build()).build();

    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<ClientAuthentication> builder(MarshallingType.SDK_POJO).memberName("ClientAuthentication")
            .getter(getter(CreateClusterRequest::clientAuthentication)).setter(setter(Builder::clientAuthentication))
            .constructor(ClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(CreateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<ConfigurationInfo> CONFIGURATION_INFO_FIELD = SdkField
            .<ConfigurationInfo> builder(MarshallingType.SDK_POJO).memberName("ConfigurationInfo")
            .getter(getter(CreateClusterRequest::configurationInfo)).setter(setter(Builder::configurationInfo))
            .constructor(ConfigurationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationInfo").build()).build();

    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField
            .<EncryptionInfo> builder(MarshallingType.SDK_POJO).memberName("EncryptionInfo")
            .getter(getter(CreateClusterRequest::encryptionInfo)).setter(setter(Builder::encryptionInfo))
            .constructor(EncryptionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()).build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoring").getter(getter(CreateClusterRequest::enhancedMonitoringAsString))
            .setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build())
            .build();

    private static final SdkField<OpenMonitoringInfo> OPEN_MONITORING_FIELD = SdkField
            .<OpenMonitoringInfo> builder(MarshallingType.SDK_POJO).memberName("OpenMonitoring")
            .getter(getter(CreateClusterRequest::openMonitoring)).setter(setter(Builder::openMonitoring))
            .constructor(OpenMonitoringInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()).build();

    private static final SdkField<String> KAFKA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KafkaVersion").getter(getter(CreateClusterRequest::kafkaVersion)).setter(setter(Builder::kafkaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersion").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(CreateClusterRequest::loggingInfo)).setter(setter(Builder::loggingInfo))
            .constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBrokerNodes").getter(getter(CreateClusterRequest::numberOfBrokerNodes))
            .setter(setter(Builder::numberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageMode").getter(getter(CreateClusterRequest::storageModeAsString))
            .setter(setter(Builder::storageMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_NODE_GROUP_INFO_FIELD,
            REBALANCING_FIELD, CLIENT_AUTHENTICATION_FIELD, CLUSTER_NAME_FIELD, CONFIGURATION_INFO_FIELD, ENCRYPTION_INFO_FIELD,
            ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, KAFKA_VERSION_FIELD, LOGGING_INFO_FIELD,
            NUMBER_OF_BROKER_NODES_FIELD, TAGS_FIELD, STORAGE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final BrokerNodeGroupInfo brokerNodeGroupInfo;

    private final Rebalancing rebalancing;

    private final ClientAuthentication clientAuthentication;

    private final String clusterName;

    private final ConfigurationInfo configurationInfo;

    private final EncryptionInfo encryptionInfo;

    private final String enhancedMonitoring;

    private final OpenMonitoringInfo openMonitoring;

    private final String kafkaVersion;

    private final LoggingInfo loggingInfo;

    private final Integer numberOfBrokerNodes;

    private final Map<String, String> tags;

    private final String storageMode;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.rebalancing = builder.rebalancing;
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterName = builder.clusterName;
        this.configurationInfo = builder.configurationInfo;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.kafkaVersion = builder.kafkaVersion;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.tags = builder.tags;
        this.storageMode = builder.storageMode;
    }

    /**
     *
     * <p>
     * Information about the broker nodes in the cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the broker nodes in the cluster.
     *         </p>
     */
    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return brokerNodeGroupInfo;
    }

    /**
     *
     * <p>
     * Specifies if intelligent rebalancing should be turned on for the new MSK Provisioned cluster with Express
     * brokers. By default, intelligent rebalancing status is ACTIVE for all new clusters.
     * </p>
     * 
     * @return <p>
     *         Specifies if intelligent rebalancing should be turned on for the new MSK Provisioned cluster with Express
     *         brokers. By default, intelligent rebalancing status is ACTIVE for all new clusters.
     *         </p>
     */
    public final Rebalancing rebalancing() {
        return rebalancing;
    }

    /**
     *
     * <p>
     * Includes all client authentication related information.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication related information.
     *         </p>
     */
    public final ClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    /**
     *
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return <p>
     *         The name of the cluster.
     *         </p>
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     *
     * <p>
     * Represents the configuration that you want MSK to use for the brokers in a cluster.
     * </p>
     * 
     * @return <p>
     *         Represents the configuration that you want MSK to use for the brokers in a cluster.
     *         </p>
     */
    public final ConfigurationInfo configurationInfo() {
        return configurationInfo;
    }

    /**
     *
     * <p>
     * Includes all encryption-related information.
     * </p>
     * 
     * @return <p>
     *         Includes all encryption-related information.
     *         </p>
     */
    public final EncryptionInfo encryptionInfo() {
        return encryptionInfo;
    }

    /**
     *
     * <p>
     * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     *         PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(enhancedMonitoring);
    }

    /**
     *
     * <p>
     * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
     *         PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final String enhancedMonitoringAsString() {
        return enhancedMonitoring;
    }

    /**
     *
     * <p>
     * The settings for open monitoring.
     * </p>
     * 
     * @return <p>
     *         The settings for open monitoring.
     *         </p>
     */
    public final OpenMonitoringInfo openMonitoring() {
        return openMonitoring;
    }

    /**
     *
     * <p>
     * The version of Apache Kafka.
     * </p>
     * 
     * @return <p>
     *         The version of Apache Kafka.
     *         </p>
     */
    public final String kafkaVersion() {
        return kafkaVersion;
    }

    /**
     * Returns the value of the LoggingInfo property for this object.
     * 
     * @return The value of the LoggingInfo property for this object.
     */
    public final LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     *
     * <p>
     * The number of broker nodes in the cluster.
     * </p>
     * 
     * @return <p>
     *         The number of broker nodes in the cluster.
     *         </p>
     */
    public final Integer numberOfBrokerNodes() {
        return numberOfBrokerNodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     *
     * <p>
     * Create tags when creating the cluster.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return <p>
     *         Create tags when creating the cluster.
     *         </p>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     *
     * <p>
     * This controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         This controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final StorageMode storageMode() {
        return StorageMode.fromValue(storageMode);
    }

    /**
     *
     * <p>
     * This controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         This controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final String storageModeAsString() {
        return storageMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(rebalancing());
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(configurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(brokerNodeGroupInfo(), other.brokerNodeGroupInfo())
                && Objects.equals(rebalancing(), other.rebalancing())
                && Objects.equals(clientAuthentication(), other.clientAuthentication())
                && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(configurationInfo(), other.configurationInfo())
                && Objects.equals(encryptionInfo(), other.encryptionInfo())
                && Objects.equals(enhancedMonitoringAsString(), other.enhancedMonitoringAsString())
                && Objects.equals(openMonitoring(), other.openMonitoring())
                && Objects.equals(kafkaVersion(), other.kafkaVersion()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(numberOfBrokerNodes(), other.numberOfBrokerNodes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(storageModeAsString(), other.storageModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("BrokerNodeGroupInfo", brokerNodeGroupInfo())
                .add("Rebalancing", rebalancing()).add("ClientAuthentication", clientAuthentication())
                .add("ClusterName", clusterName()).add("ConfigurationInfo", configurationInfo())
                .add("EncryptionInfo", encryptionInfo()).add("EnhancedMonitoring", enhancedMonitoringAsString())
                .add("OpenMonitoring", openMonitoring()).add("KafkaVersion", kafkaVersion()).add("LoggingInfo", loggingInfo())
                .add("NumberOfBrokerNodes", numberOfBrokerNodes()).add("Tags", hasTags() ? tags() : null)
                .add("StorageMode", storageModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerNodeGroupInfo":
            return Optional.ofNullable(clazz.cast(brokerNodeGroupInfo()));
        case "Rebalancing":
            return Optional.ofNullable(clazz.cast(rebalancing()));
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "ConfigurationInfo":
            return Optional.ofNullable(clazz.cast(configurationInfo()));
        case "EncryptionInfo":
            return Optional.ofNullable(clazz.cast(encryptionInfo()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringAsString()));
        case "OpenMonitoring":
            return Optional.ofNullable(clazz.cast(openMonitoring()));
        case "KafkaVersion":
            return Optional.ofNullable(clazz.cast(kafkaVersion()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        case "NumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(numberOfBrokerNodes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "StorageMode":
            return Optional.ofNullable(clazz.cast(storageModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("brokerNodeGroupInfo", BROKER_NODE_GROUP_INFO_FIELD);
        map.put("rebalancing", REBALANCING_FIELD);
        map.put("clientAuthentication", CLIENT_AUTHENTICATION_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("configurationInfo", CONFIGURATION_INFO_FIELD);
        map.put("encryptionInfo", ENCRYPTION_INFO_FIELD);
        map.put("enhancedMonitoring", ENHANCED_MONITORING_FIELD);
        map.put("openMonitoring", OPEN_MONITORING_FIELD);
        map.put("kafkaVersion", KAFKA_VERSION_FIELD);
        map.put("loggingInfo", LOGGING_INFO_FIELD);
        map.put("numberOfBrokerNodes", NUMBER_OF_BROKER_NODES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("storageMode", STORAGE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         *
         * <p>
         * Information about the broker nodes in the cluster.
         * </p>
         * 
         * @param brokerNodeGroupInfo
         *        <p>
         *        Information about the broker nodes in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo);

        /**
         *
         * <p>
         * Information about the broker nodes in the cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link BrokerNodeGroupInfo.Builder} avoiding the
         * need to create one manually via {@link BrokerNodeGroupInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrokerNodeGroupInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #brokerNodeGroupInfo(BrokerNodeGroupInfo)}.
         * 
         * @param brokerNodeGroupInfo
         *        a consumer that will call methods on {@link BrokerNodeGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerNodeGroupInfo(BrokerNodeGroupInfo)
         */
        default Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return brokerNodeGroupInfo(BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo).build());
        }

        /**
         *
         * <p>
         * Specifies if intelligent rebalancing should be turned on for the new MSK Provisioned cluster with Express
         * brokers. By default, intelligent rebalancing status is ACTIVE for all new clusters.
         * </p>
         * 
         * @param rebalancing
         *        <p>
         *        Specifies if intelligent rebalancing should be turned on for the new MSK Provisioned cluster with
         *        Express brokers. By default, intelligent rebalancing status is ACTIVE for all new clusters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebalancing(Rebalancing rebalancing);

        /**
         *
         * <p>
         * Specifies if intelligent rebalancing should be turned on for the new MSK Provisioned cluster with Express
         * brokers. By default, intelligent rebalancing status is ACTIVE for all new clusters.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Rebalancing.Builder} avoiding the need to
         * create one manually via {@link Rebalancing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Rebalancing.Builder#build()} is called immediately and its result
         * is passed to {@link #rebalancing(Rebalancing)}.
         * 
         * @param rebalancing
         *        a consumer that will call methods on {@link Rebalancing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rebalancing(Rebalancing)
         */
        default Builder rebalancing(Consumer<Rebalancing.Builder> rebalancing) {
            return rebalancing(Rebalancing.builder().applyMutation(rebalancing).build());
        }

        /**
         *
         * <p>
         * Includes all client authentication related information.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(ClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication related information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ClientAuthentication.Builder} avoiding
         * the need to create one manually via {@link ClientAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #clientAuthentication(ClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link ClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(ClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(ClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }

        /**
         *
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        <p>
         *        The name of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         *
         * <p>
         * Represents the configuration that you want MSK to use for the brokers in a cluster.
         * </p>
         * 
         * @param configurationInfo
         *        <p>
         *        Represents the configuration that you want MSK to use for the brokers in a cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationInfo(ConfigurationInfo configurationInfo);

        /**
         *
         * <p>
         * Represents the configuration that you want MSK to use for the brokers in a cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ConfigurationInfo.Builder} avoiding the
         * need to create one manually via {@link ConfigurationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationInfo(ConfigurationInfo)}.
         * 
         * @param configurationInfo
         *        a consumer that will call methods on {@link ConfigurationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationInfo(ConfigurationInfo)
         */
        default Builder configurationInfo(Consumer<ConfigurationInfo.Builder> configurationInfo) {
            return configurationInfo(ConfigurationInfo.builder().applyMutation(configurationInfo).build());
        }

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * @param encryptionInfo
         *        <p>
         *        Includes all encryption-related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInfo(EncryptionInfo encryptionInfo);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link EncryptionInfo.Builder} avoiding the need
         * to create one manually via {@link EncryptionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionInfo(EncryptionInfo)}.
         * 
         * @param encryptionInfo
         *        a consumer that will call methods on {@link EncryptionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInfo(EncryptionInfo)
         */
        default Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return encryptionInfo(EncryptionInfo.builder().applyMutation(encryptionInfo).build());
        }

        /**
         *
         * <p>
         * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         *        PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(String enhancedMonitoring);

        /**
         *
         * <p>
         * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         * PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER,
         *        PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * @param openMonitoring
         *        <p>
         *        The settings for open monitoring.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openMonitoring(OpenMonitoringInfo openMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link OpenMonitoringInfo.Builder} avoiding the
         * need to create one manually via {@link OpenMonitoringInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenMonitoringInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #openMonitoring(OpenMonitoringInfo)}.
         * 
         * @param openMonitoring
         *        a consumer that will call methods on {@link OpenMonitoringInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openMonitoring(OpenMonitoringInfo)
         */
        default Builder openMonitoring(Consumer<OpenMonitoringInfo.Builder> openMonitoring) {
            return openMonitoring(OpenMonitoringInfo.builder().applyMutation(openMonitoring).build());
        }

        /**
         *
         * <p>
         * The version of Apache Kafka.
         * </p>
         * 
         * @param kafkaVersion
         *        <p>
         *        The version of Apache Kafka.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersion(String kafkaVersion);

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * @param loggingInfo
         *        The new value for the LoggingInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to
         * create one manually via {@link LoggingInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        /**
         *
         * <p>
         * The number of broker nodes in the cluster.
         * </p>
         * 
         * @param numberOfBrokerNodes
         *        <p>
         *        The number of broker nodes in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBrokerNodes(Integer numberOfBrokerNodes);

        /**
         *
         * <p>
         * Create tags when creating the cluster.
         * </p>
         * 
         * @param tags
         *        <p>
         *        Create tags when creating the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         *
         * <p>
         * This controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        This controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(String storageMode);

        /**
         *
         * <p>
         * This controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        This controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(StorageMode storageMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private BrokerNodeGroupInfo brokerNodeGroupInfo;

        private Rebalancing rebalancing;

        private ClientAuthentication clientAuthentication;

        private String clusterName;

        private ConfigurationInfo configurationInfo;

        private EncryptionInfo encryptionInfo;

        private String enhancedMonitoring;

        private OpenMonitoringInfo openMonitoring;

        private String kafkaVersion;

        private LoggingInfo loggingInfo;

        private Integer numberOfBrokerNodes;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String storageMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            rebalancing(model.rebalancing);
            clientAuthentication(model.clientAuthentication);
            clusterName(model.clusterName);
            configurationInfo(model.configurationInfo);
            encryptionInfo(model.encryptionInfo);
            enhancedMonitoring(model.enhancedMonitoring);
            openMonitoring(model.openMonitoring);
            kafkaVersion(model.kafkaVersion);
            loggingInfo(model.loggingInfo);
            numberOfBrokerNodes(model.numberOfBrokerNodes);
            tags(model.tags);
            storageMode(model.storageMode);
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return brokerNodeGroupInfo != null ? brokerNodeGroupInfo.toBuilder() : null;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final Rebalancing.Builder getRebalancing() {
            return rebalancing != null ? rebalancing.toBuilder() : null;
        }

        public final void setRebalancing(Rebalancing.BuilderImpl rebalancing) {
            this.rebalancing = rebalancing != null ? rebalancing.build() : null;
        }

        @Override
        public final Builder rebalancing(Rebalancing rebalancing) {
            this.rebalancing = rebalancing;
            return this;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final ConfigurationInfo.Builder getConfigurationInfo() {
            return configurationInfo != null ? configurationInfo.toBuilder() : null;
        }

        public final void setConfigurationInfo(ConfigurationInfo.BuilderImpl configurationInfo) {
            this.configurationInfo = configurationInfo != null ? configurationInfo.build() : null;
        }

        @Override
        public final Builder configurationInfo(ConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return encryptionInfo != null ? encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoringInfo.Builder getOpenMonitoring() {
            return openMonitoring != null ? openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoringInfo.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoringInfo openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final String getKafkaVersion() {
            return kafkaVersion;
        }

        public final void setKafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
        }

        @Override
        public final Builder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getStorageMode() {
            return storageMode;
        }

        public final void setStorageMode(String storageMode) {
            this.storageMode = storageMode;
        }

        @Override
        public final Builder storageMode(String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @Override
        public final Builder storageMode(StorageMode storageMode) {
            this.storageMode(storageMode == null ? null : storageMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
