/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration for replication between a source and target Kafka cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationInfo implements SdkPojo, Serializable, ToCopyableBuilder<ReplicationInfo.Builder, ReplicationInfo> {
    private static final SdkField<ConsumerGroupReplication> CONSUMER_GROUP_REPLICATION_FIELD = SdkField
            .<ConsumerGroupReplication> builder(MarshallingType.SDK_POJO).memberName("ConsumerGroupReplication")
            .getter(getter(ReplicationInfo::consumerGroupReplication)).setter(setter(Builder::consumerGroupReplication))
            .constructor(ConsumerGroupReplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupReplication").build())
            .build();

    private static final SdkField<String> SOURCE_KAFKA_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceKafkaClusterArn").getter(getter(ReplicationInfo::sourceKafkaClusterArn))
            .setter(setter(Builder::sourceKafkaClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKafkaClusterArn").build())
            .build();

    private static final SdkField<String> TARGET_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCompressionType").getter(getter(ReplicationInfo::targetCompressionTypeAsString))
            .setter(setter(Builder::targetCompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCompressionType").build())
            .build();

    private static final SdkField<String> TARGET_KAFKA_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetKafkaClusterArn").getter(getter(ReplicationInfo::targetKafkaClusterArn))
            .setter(setter(Builder::targetKafkaClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKafkaClusterArn").build())
            .build();

    private static final SdkField<TopicReplication> TOPIC_REPLICATION_FIELD = SdkField
            .<TopicReplication> builder(MarshallingType.SDK_POJO).memberName("TopicReplication")
            .getter(getter(ReplicationInfo::topicReplication)).setter(setter(Builder::topicReplication))
            .constructor(TopicReplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicReplication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSUMER_GROUP_REPLICATION_FIELD, SOURCE_KAFKA_CLUSTER_ARN_FIELD, TARGET_COMPRESSION_TYPE_FIELD,
            TARGET_KAFKA_CLUSTER_ARN_FIELD, TOPIC_REPLICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConsumerGroupReplication consumerGroupReplication;

    private final String sourceKafkaClusterArn;

    private final String targetCompressionType;

    private final String targetKafkaClusterArn;

    private final TopicReplication topicReplication;

    private ReplicationInfo(BuilderImpl builder) {
        this.consumerGroupReplication = builder.consumerGroupReplication;
        this.sourceKafkaClusterArn = builder.sourceKafkaClusterArn;
        this.targetCompressionType = builder.targetCompressionType;
        this.targetKafkaClusterArn = builder.targetKafkaClusterArn;
        this.topicReplication = builder.topicReplication;
    }

    /**
     * <p>
     * Configuration relating to consumer group replication.
     * </p>
     * 
     * @return Configuration relating to consumer group replication.
     */
    public final ConsumerGroupReplication consumerGroupReplication() {
        return consumerGroupReplication;
    }

    /**
     * <p>
     * The ARN of the source Kafka cluster.
     * </p>
     * 
     * @return The ARN of the source Kafka cluster.
     */
    public final String sourceKafkaClusterArn() {
        return sourceKafkaClusterArn;
    }

    /**
     * <p>
     * The compression type to use when producing records to target cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCompressionType} will return {@link TargetCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCompressionTypeAsString}.
     * </p>
     * 
     * @return The compression type to use when producing records to target cluster.
     * @see TargetCompressionType
     */
    public final TargetCompressionType targetCompressionType() {
        return TargetCompressionType.fromValue(targetCompressionType);
    }

    /**
     * <p>
     * The compression type to use when producing records to target cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCompressionType} will return {@link TargetCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCompressionTypeAsString}.
     * </p>
     * 
     * @return The compression type to use when producing records to target cluster.
     * @see TargetCompressionType
     */
    public final String targetCompressionTypeAsString() {
        return targetCompressionType;
    }

    /**
     * <p>
     * The ARN of the target Kafka cluster.
     * </p>
     * 
     * @return The ARN of the target Kafka cluster.
     */
    public final String targetKafkaClusterArn() {
        return targetKafkaClusterArn;
    }

    /**
     * <p>
     * Configuration relating to topic replication.
     * </p>
     * 
     * @return Configuration relating to topic replication.
     */
    public final TopicReplication topicReplication() {
        return topicReplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumerGroupReplication());
        hashCode = 31 * hashCode + Objects.hashCode(sourceKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(topicReplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInfo)) {
            return false;
        }
        ReplicationInfo other = (ReplicationInfo) obj;
        return Objects.equals(consumerGroupReplication(), other.consumerGroupReplication())
                && Objects.equals(sourceKafkaClusterArn(), other.sourceKafkaClusterArn())
                && Objects.equals(targetCompressionTypeAsString(), other.targetCompressionTypeAsString())
                && Objects.equals(targetKafkaClusterArn(), other.targetKafkaClusterArn())
                && Objects.equals(topicReplication(), other.topicReplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationInfo").add("ConsumerGroupReplication", consumerGroupReplication())
                .add("SourceKafkaClusterArn", sourceKafkaClusterArn())
                .add("TargetCompressionType", targetCompressionTypeAsString())
                .add("TargetKafkaClusterArn", targetKafkaClusterArn()).add("TopicReplication", topicReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerGroupReplication":
            return Optional.ofNullable(clazz.cast(consumerGroupReplication()));
        case "SourceKafkaClusterArn":
            return Optional.ofNullable(clazz.cast(sourceKafkaClusterArn()));
        case "TargetCompressionType":
            return Optional.ofNullable(clazz.cast(targetCompressionTypeAsString()));
        case "TargetKafkaClusterArn":
            return Optional.ofNullable(clazz.cast(targetKafkaClusterArn()));
        case "TopicReplication":
            return Optional.ofNullable(clazz.cast(topicReplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumerGroupReplication", CONSUMER_GROUP_REPLICATION_FIELD);
        map.put("sourceKafkaClusterArn", SOURCE_KAFKA_CLUSTER_ARN_FIELD);
        map.put("targetCompressionType", TARGET_COMPRESSION_TYPE_FIELD);
        map.put("targetKafkaClusterArn", TARGET_KAFKA_CLUSTER_ARN_FIELD);
        map.put("topicReplication", TOPIC_REPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInfo, T> g) {
        return obj -> g.apply((ReplicationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationInfo> {
        /**
         * <p>
         * Configuration relating to consumer group replication.
         * </p>
         * 
         * @param consumerGroupReplication
         *        Configuration relating to consumer group replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupReplication(ConsumerGroupReplication consumerGroupReplication);

        /**
         * <p>
         * Configuration relating to consumer group replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumerGroupReplication.Builder}
         * avoiding the need to create one manually via {@link ConsumerGroupReplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumerGroupReplication.Builder#build()} is called immediately
         * and its result is passed to {@link #consumerGroupReplication(ConsumerGroupReplication)}.
         * 
         * @param consumerGroupReplication
         *        a consumer that will call methods on {@link ConsumerGroupReplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumerGroupReplication(ConsumerGroupReplication)
         */
        default Builder consumerGroupReplication(Consumer<ConsumerGroupReplication.Builder> consumerGroupReplication) {
            return consumerGroupReplication(ConsumerGroupReplication.builder().applyMutation(consumerGroupReplication).build());
        }

        /**
         * <p>
         * The ARN of the source Kafka cluster.
         * </p>
         * 
         * @param sourceKafkaClusterArn
         *        The ARN of the source Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceKafkaClusterArn(String sourceKafkaClusterArn);

        /**
         * <p>
         * The compression type to use when producing records to target cluster.
         * </p>
         * 
         * @param targetCompressionType
         *        The compression type to use when producing records to target cluster.
         * @see TargetCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCompressionType
         */
        Builder targetCompressionType(String targetCompressionType);

        /**
         * <p>
         * The compression type to use when producing records to target cluster.
         * </p>
         * 
         * @param targetCompressionType
         *        The compression type to use when producing records to target cluster.
         * @see TargetCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCompressionType
         */
        Builder targetCompressionType(TargetCompressionType targetCompressionType);

        /**
         * <p>
         * The ARN of the target Kafka cluster.
         * </p>
         * 
         * @param targetKafkaClusterArn
         *        The ARN of the target Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetKafkaClusterArn(String targetKafkaClusterArn);

        /**
         * <p>
         * Configuration relating to topic replication.
         * </p>
         * 
         * @param topicReplication
         *        Configuration relating to topic replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicReplication(TopicReplication topicReplication);

        /**
         * <p>
         * Configuration relating to topic replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicReplication.Builder} avoiding the
         * need to create one manually via {@link TopicReplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicReplication.Builder#build()} is called immediately and its
         * result is passed to {@link #topicReplication(TopicReplication)}.
         * 
         * @param topicReplication
         *        a consumer that will call methods on {@link TopicReplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicReplication(TopicReplication)
         */
        default Builder topicReplication(Consumer<TopicReplication.Builder> topicReplication) {
            return topicReplication(TopicReplication.builder().applyMutation(topicReplication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConsumerGroupReplication consumerGroupReplication;

        private String sourceKafkaClusterArn;

        private String targetCompressionType;

        private String targetKafkaClusterArn;

        private TopicReplication topicReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInfo model) {
            consumerGroupReplication(model.consumerGroupReplication);
            sourceKafkaClusterArn(model.sourceKafkaClusterArn);
            targetCompressionType(model.targetCompressionType);
            targetKafkaClusterArn(model.targetKafkaClusterArn);
            topicReplication(model.topicReplication);
        }

        public final ConsumerGroupReplication.Builder getConsumerGroupReplication() {
            return consumerGroupReplication != null ? consumerGroupReplication.toBuilder() : null;
        }

        public final void setConsumerGroupReplication(ConsumerGroupReplication.BuilderImpl consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication != null ? consumerGroupReplication.build() : null;
        }

        @Override
        public final Builder consumerGroupReplication(ConsumerGroupReplication consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication;
            return this;
        }

        public final String getSourceKafkaClusterArn() {
            return sourceKafkaClusterArn;
        }

        public final void setSourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
        }

        @Override
        public final Builder sourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
            return this;
        }

        public final String getTargetCompressionType() {
            return targetCompressionType;
        }

        public final void setTargetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
        }

        @Override
        public final Builder targetCompressionType(String targetCompressionType) {
            this.targetCompressionType = targetCompressionType;
            return this;
        }

        @Override
        public final Builder targetCompressionType(TargetCompressionType targetCompressionType) {
            this.targetCompressionType(targetCompressionType == null ? null : targetCompressionType.toString());
            return this;
        }

        public final String getTargetKafkaClusterArn() {
            return targetKafkaClusterArn;
        }

        public final void setTargetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
        }

        @Override
        public final Builder targetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
            return this;
        }

        public final TopicReplication.Builder getTopicReplication() {
            return topicReplication != null ? topicReplication.toBuilder() : null;
        }

        public final void setTopicReplication(TopicReplication.BuilderImpl topicReplication) {
            this.topicReplication = topicReplication != null ? topicReplication.build() : null;
        }

        @Override
        public final Builder topicReplication(TopicReplication topicReplication) {
            this.topicReplication = topicReplication;
            return this;
        }

        @Override
        public ReplicationInfo build() {
            return new ReplicationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
