/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrokerStorageRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateBrokerStorageRequest.Builder, UpdateBrokerStorageRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateBrokerStorageRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateBrokerStorageRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<List<BrokerEBSVolumeInfo>> TARGET_BROKER_EBS_VOLUME_INFO_FIELD = SdkField
            .<List<BrokerEBSVolumeInfo>> builder(MarshallingType.LIST)
            .memberName("TargetBrokerEBSVolumeInfo")
            .getter(getter(UpdateBrokerStorageRequest::targetBrokerEBSVolumeInfo))
            .setter(setter(Builder::targetBrokerEBSVolumeInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBrokerEBSVolumeInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerEBSVolumeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerEBSVolumeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CURRENT_VERSION_FIELD, TARGET_BROKER_EBS_VOLUME_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterArn;

    private final String currentVersion;

    private final List<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo;

    private UpdateBrokerStorageRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.targetBrokerEBSVolumeInfo = builder.targetBrokerEBSVolumeInfo;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The version of cluster to update from. A successful operation will then generate a new version.
     * </p>
     * 
     * @return <p>
     *         The version of cluster to update from. A successful operation will then generate a new version.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetBrokerEBSVolumeInfo property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetBrokerEBSVolumeInfo() {
        return targetBrokerEBSVolumeInfo != null && !(targetBrokerEBSVolumeInfo instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Describes the target volume size and the ID of the broker to apply the update to.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetBrokerEBSVolumeInfo} method.
     * </p>
     * 
     * @return <p>
     *         Describes the target volume size and the ID of the broker to apply the update to.
     *         </p>
     */
    public final List<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo() {
        return targetBrokerEBSVolumeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetBrokerEBSVolumeInfo() ? targetBrokerEBSVolumeInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerStorageRequest)) {
            return false;
        }
        UpdateBrokerStorageRequest other = (UpdateBrokerStorageRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(currentVersion(), other.currentVersion())
                && hasTargetBrokerEBSVolumeInfo() == other.hasTargetBrokerEBSVolumeInfo()
                && Objects.equals(targetBrokerEBSVolumeInfo(), other.targetBrokerEBSVolumeInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrokerStorageRequest").add("ClusterArn", clusterArn())
                .add("CurrentVersion", currentVersion())
                .add("TargetBrokerEBSVolumeInfo", hasTargetBrokerEBSVolumeInfo() ? targetBrokerEBSVolumeInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "TargetBrokerEBSVolumeInfo":
            return Optional.ofNullable(clazz.cast(targetBrokerEBSVolumeInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("targetBrokerEBSVolumeInfo", TARGET_BROKER_EBS_VOLUME_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerStorageRequest, T> g) {
        return obj -> g.apply((UpdateBrokerStorageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBrokerStorageRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The version of cluster to update from. A successful operation will then generate a new version.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of cluster to update from. A successful operation will then generate a new version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * Describes the target volume size and the ID of the broker to apply the update to.
         * </p>
         * 
         * @param targetBrokerEBSVolumeInfo
         *        <p>
         *        Describes the target volume size and the ID of the broker to apply the update to.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Describes the target volume size and the ID of the broker to apply the update to.
         * </p>
         * 
         * @param targetBrokerEBSVolumeInfo
         *        <p>
         *        Describes the target volume size and the ID of the broker to apply the update to.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBrokerEBSVolumeInfo(BrokerEBSVolumeInfo... targetBrokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Describes the target volume size and the ID of the broker to apply the update to.
         * </p>
         * 
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #targetBrokerEBSVolumeInfo(List<BrokerEBSVolumeInfo>)}.
         * 
         * @param targetBrokerEBSVolumeInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetBrokerEBSVolumeInfo(java.util.Collection<BrokerEBSVolumeInfo>)
         */
        Builder targetBrokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder>... targetBrokerEBSVolumeInfo);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private String currentVersion;

        private List<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerStorageRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            currentVersion(model.currentVersion);
            targetBrokerEBSVolumeInfo(model.targetBrokerEBSVolumeInfo);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final List<BrokerEBSVolumeInfo.Builder> getTargetBrokerEBSVolumeInfo() {
            List<BrokerEBSVolumeInfo.Builder> result = ___listOfBrokerEBSVolumeInfoCopier
                    .copyToBuilder(this.targetBrokerEBSVolumeInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo.BuilderImpl> targetBrokerEBSVolumeInfo) {
            this.targetBrokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copyFromBuilder(targetBrokerEBSVolumeInfo);
        }

        @Override
        public final Builder targetBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> targetBrokerEBSVolumeInfo) {
            this.targetBrokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copy(targetBrokerEBSVolumeInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBrokerEBSVolumeInfo(BrokerEBSVolumeInfo... targetBrokerEBSVolumeInfo) {
            targetBrokerEBSVolumeInfo(Arrays.asList(targetBrokerEBSVolumeInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBrokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder>... targetBrokerEBSVolumeInfo) {
            targetBrokerEBSVolumeInfo(Stream.of(targetBrokerEBSVolumeInfo)
                    .map(c -> BrokerEBSVolumeInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerStorageRequest build() {
            return new UpdateBrokerStorageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
