/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsPublisher;
import software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsPublisher;
import software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsPublisher;

/**
 * Service client for accessing Kafka Connect asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KafkaConnectAsyncClient extends SdkClient {
    String SERVICE_NAME = "kafkaconnect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kafkaconnect";

    /**
     * Create a {@link KafkaConnectAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KafkaConnectAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KafkaConnectAsyncClient}.
     */
    static KafkaConnectAsyncClientBuilder builder() {
        return new DefaultKafkaConnectAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a connector using the specified properties.
     * </p>
     *
     * @param createConnectorRequest
     * @return A Java Future containing the result of the CreateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. A resource with this name already exists. Retry
     *         your request with another name.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConnectorResponse> createConnector(CreateConnectorRequest createConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connector using the specified properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectorRequest#builder()}
     * </p>
     *
     * @param createConnectorRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. A resource with this name already exists. Retry
     *         your request with another name.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConnectorResponse> createConnector(
            Consumer<CreateConnectorRequest.Builder> createConnectorRequest) {
        return createConnector(CreateConnectorRequest.builder().applyMutation(createConnectorRequest).build());
    }

    /**
     * <p>
     * Creates a custom plugin using the specified properties.
     * </p>
     *
     * @param createCustomPluginRequest
     * @return A Java Future containing the result of the CreateCustomPlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. A resource with this name already exists. Retry
     *         your request with another name.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.CreateCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomPluginResponse> createCustomPlugin(CreateCustomPluginRequest createCustomPluginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom plugin using the specified properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomPluginRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomPluginRequest#builder()}
     * </p>
     *
     * @param createCustomPluginRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomPluginRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomPlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. A resource with this name already exists. Retry
     *         your request with another name.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.CreateCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomPluginResponse> createCustomPlugin(
            Consumer<CreateCustomPluginRequest.Builder> createCustomPluginRequest) {
        return createCustomPlugin(CreateCustomPluginRequest.builder().applyMutation(createCustomPluginRequest).build());
    }

    /**
     * <p>
     * Creates a worker configuration using the specified properties.
     * </p>
     *
     * @param createWorkerConfigurationRequest
     * @return A Java Future containing the result of the CreateWorkerConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. A resource with this name already exists. Retry
     *         your request with another name.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.CreateWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkerConfigurationResponse> createWorkerConfiguration(
            CreateWorkerConfigurationRequest createWorkerConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a worker configuration using the specified properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkerConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWorkerConfigurationRequest#builder()}
     * </p>
     *
     * @param createWorkerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkerConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkerConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. A resource with this name already exists. Retry
     *         your request with another name.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.CreateWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkerConfigurationResponse> createWorkerConfiguration(
            Consumer<CreateWorkerConfigurationRequest.Builder> createWorkerConfigurationRequest) {
        return createWorkerConfiguration(CreateWorkerConfigurationRequest.builder()
                .applyMutation(createWorkerConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified connector.
     * </p>
     *
     * @param deleteConnectorRequest
     * @return A Java Future containing the result of the DeleteConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorResponse> deleteConnector(DeleteConnectorRequest deleteConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectorRequest#builder()}
     * </p>
     *
     * @param deleteConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConnectorResponse> deleteConnector(
            Consumer<DeleteConnectorRequest.Builder> deleteConnectorRequest) {
        return deleteConnector(DeleteConnectorRequest.builder().applyMutation(deleteConnectorRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the connector.
     * </p>
     *
     * @param describeConnectorRequest
     * @return A Java Future containing the result of the DescribeConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorResponse> describeConnector(DescribeConnectorRequest describeConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeConnectorRequest#builder()}
     * </p>
     *
     * @param describeConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorResponse> describeConnector(
            Consumer<DescribeConnectorRequest.Builder> describeConnectorRequest) {
        return describeConnector(DescribeConnectorRequest.builder().applyMutation(describeConnectorRequest).build());
    }

    /**
     * <p>
     * A summary description of the custom plugin.
     * </p>
     *
     * @param describeCustomPluginRequest
     * @return A Java Future containing the result of the DescribeCustomPlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DescribeCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomPluginResponse> describeCustomPlugin(
            DescribeCustomPluginRequest describeCustomPluginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A summary description of the custom plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomPluginRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCustomPluginRequest#builder()}
     * </p>
     *
     * @param describeCustomPluginRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomPluginRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCustomPlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DescribeCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomPluginResponse> describeCustomPlugin(
            Consumer<DescribeCustomPluginRequest.Builder> describeCustomPluginRequest) {
        return describeCustomPlugin(DescribeCustomPluginRequest.builder().applyMutation(describeCustomPluginRequest).build());
    }

    /**
     * <p>
     * Returns information about a worker configuration.
     * </p>
     *
     * @param describeWorkerConfigurationRequest
     * @return A Java Future containing the result of the DescribeWorkerConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DescribeWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkerConfigurationResponse> describeWorkerConfiguration(
            DescribeWorkerConfigurationRequest describeWorkerConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a worker configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkerConfigurationRequest#builder()}
     * </p>
     *
     * @param describeWorkerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkerConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeWorkerConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.DescribeWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorkerConfigurationResponse> describeWorkerConfiguration(
            Consumer<DescribeWorkerConfigurationRequest.Builder> describeWorkerConfigurationRequest) {
        return describeWorkerConfiguration(DescribeWorkerConfigurationRequest.builder()
                .applyMutation(describeWorkerConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     *
     * @param listConnectorsRequest
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(ListConnectorsRequest listConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectors(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation.</b>
     * </p>
     *
     * @param listConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectorsPaginator(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     *
     * @param listCustomPluginsRequest
     * @return A Java Future containing the result of the ListCustomPlugins operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomPluginsResponse> listCustomPlugins(ListCustomPluginsRequest listCustomPluginsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomPluginsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomPluginsRequest#builder()}
     * </p>
     *
     * @param listCustomPluginsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomPluginsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCustomPlugins operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomPluginsResponse> listCustomPlugins(
            Consumer<ListCustomPluginsRequest.Builder> listCustomPluginsRequest) {
        return listCustomPlugins(ListCustomPluginsRequest.builder().applyMutation(listCustomPluginsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsPublisher publisher = client.listCustomPluginsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsPublisher publisher = client.listCustomPluginsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomPluginsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomPluginsPublisher listCustomPluginsPaginator(ListCustomPluginsRequest listCustomPluginsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsPublisher publisher = client.listCustomPluginsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsPublisher publisher = client.listCustomPluginsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomPluginsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomPluginsRequest#builder()}
     * </p>
     *
     * @param listCustomPluginsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomPluginsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomPluginsPublisher listCustomPluginsPaginator(
            Consumer<ListCustomPluginsRequest.Builder> listCustomPluginsRequest) {
        return listCustomPluginsPaginator(ListCustomPluginsRequest.builder().applyMutation(listCustomPluginsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     * @return A Java Future containing the result of the ListWorkerConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkerConfigurationsResponse> listWorkerConfigurations(
            ListWorkerConfigurationsRequest listWorkerConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkerConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkerConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkerConfigurationsResponse> listWorkerConfigurations(
            Consumer<ListWorkerConfigurationsRequest.Builder> listWorkerConfigurationsRequest) {
        return listWorkerConfigurations(ListWorkerConfigurationsRequest.builder().applyMutation(listWorkerConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsPublisher publisher = client.listWorkerConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsPublisher publisher = client.listWorkerConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerConfigurationsPublisher listWorkerConfigurationsPaginator(
            ListWorkerConfigurationsRequest listWorkerConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsPublisher publisher = client.listWorkerConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsPublisher publisher = client.listWorkerConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkerConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerConfigurationsPublisher listWorkerConfigurationsPaginator(
            Consumer<ListWorkerConfigurationsRequest.Builder> listWorkerConfigurationsRequest) {
        return listWorkerConfigurationsPaginator(ListWorkerConfigurationsRequest.builder()
                .applyMutation(listWorkerConfigurationsRequest).build());
    }

    /**
     * <p>
     * Updates the specified connector.
     * </p>
     *
     * @param updateConnectorRequest
     * @return A Java Future containing the result of the UpdateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/UpdateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorResponse> updateConnector(UpdateConnectorRequest updateConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectorRequest#builder()}
     * </p>
     *
     * @param updateConnectorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaConnectAsyncClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/UpdateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConnectorResponse> updateConnector(
            Consumer<UpdateConnectorRequest.Builder> updateConnectorRequest) {
        return updateConnector(UpdateConnectorRequest.builder().applyMutation(updateConnectorRequest).build());
    }
}
