/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how the connector scales.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScaling implements SdkPojo, Serializable, ToCopyableBuilder<AutoScaling.Builder, AutoScaling> {
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxWorkerCount").getter(getter(AutoScaling::maxWorkerCount)).setter(setter(Builder::maxWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()).build();

    private static final SdkField<Integer> MCU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("mcuCount").getter(getter(AutoScaling::mcuCount)).setter(setter(Builder::mcuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mcuCount").build()).build();

    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minWorkerCount").getter(getter(AutoScaling::minWorkerCount)).setter(setter(Builder::minWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()).build();

    private static final SdkField<ScaleInPolicy> SCALE_IN_POLICY_FIELD = SdkField
            .<ScaleInPolicy> builder(MarshallingType.SDK_POJO).memberName("scaleInPolicy")
            .getter(getter(AutoScaling::scaleInPolicy)).setter(setter(Builder::scaleInPolicy))
            .constructor(ScaleInPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInPolicy").build()).build();

    private static final SdkField<ScaleOutPolicy> SCALE_OUT_POLICY_FIELD = SdkField
            .<ScaleOutPolicy> builder(MarshallingType.SDK_POJO).memberName("scaleOutPolicy")
            .getter(getter(AutoScaling::scaleOutPolicy)).setter(setter(Builder::scaleOutPolicy))
            .constructor(ScaleOutPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_WORKER_COUNT_FIELD,
            MCU_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, SCALE_IN_POLICY_FIELD, SCALE_OUT_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxWorkerCount;

    private final Integer mcuCount;

    private final Integer minWorkerCount;

    private final ScaleInPolicy scaleInPolicy;

    private final ScaleOutPolicy scaleOutPolicy;

    private AutoScaling(BuilderImpl builder) {
        this.maxWorkerCount = builder.maxWorkerCount;
        this.mcuCount = builder.mcuCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.scaleInPolicy = builder.scaleInPolicy;
        this.scaleOutPolicy = builder.scaleOutPolicy;
    }

    /**
     * <p>
     * The maximum number of workers allocated to the connector.
     * </p>
     * 
     * @return The maximum number of workers allocated to the connector.
     */
    public final Integer maxWorkerCount() {
        return maxWorkerCount;
    }

    /**
     * <p>
     * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
     * </p>
     * 
     * @return The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
     *         1,2,4,8.
     */
    public final Integer mcuCount() {
        return mcuCount;
    }

    /**
     * <p>
     * The minimum number of workers allocated to the connector.
     * </p>
     * 
     * @return The minimum number of workers allocated to the connector.
     */
    public final Integer minWorkerCount() {
        return minWorkerCount;
    }

    /**
     * <p>
     * The sacle-in policy for the connector.
     * </p>
     * 
     * @return The sacle-in policy for the connector.
     */
    public final ScaleInPolicy scaleInPolicy() {
        return scaleInPolicy;
    }

    /**
     * <p>
     * The sacle-out policy for the connector.
     * </p>
     * 
     * @return The sacle-out policy for the connector.
     */
    public final ScaleOutPolicy scaleOutPolicy() {
        return scaleOutPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(mcuCount());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScaling)) {
            return false;
        }
        AutoScaling other = (AutoScaling) obj;
        return Objects.equals(maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(mcuCount(), other.mcuCount())
                && Objects.equals(minWorkerCount(), other.minWorkerCount())
                && Objects.equals(scaleInPolicy(), other.scaleInPolicy())
                && Objects.equals(scaleOutPolicy(), other.scaleOutPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScaling").add("MaxWorkerCount", maxWorkerCount()).add("McuCount", mcuCount())
                .add("MinWorkerCount", minWorkerCount()).add("ScaleInPolicy", scaleInPolicy())
                .add("ScaleOutPolicy", scaleOutPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxWorkerCount":
            return Optional.ofNullable(clazz.cast(maxWorkerCount()));
        case "mcuCount":
            return Optional.ofNullable(clazz.cast(mcuCount()));
        case "minWorkerCount":
            return Optional.ofNullable(clazz.cast(minWorkerCount()));
        case "scaleInPolicy":
            return Optional.ofNullable(clazz.cast(scaleInPolicy()));
        case "scaleOutPolicy":
            return Optional.ofNullable(clazz.cast(scaleOutPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScaling, T> g) {
        return obj -> g.apply((AutoScaling) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScaling> {
        /**
         * <p>
         * The maximum number of workers allocated to the connector.
         * </p>
         * 
         * @param maxWorkerCount
         *        The maximum number of workers allocated to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkerCount(Integer maxWorkerCount);

        /**
         * <p>
         * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
         * </p>
         * 
         * @param mcuCount
         *        The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
         *        1,2,4,8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcuCount(Integer mcuCount);

        /**
         * <p>
         * The minimum number of workers allocated to the connector.
         * </p>
         * 
         * @param minWorkerCount
         *        The minimum number of workers allocated to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkerCount(Integer minWorkerCount);

        /**
         * <p>
         * The sacle-in policy for the connector.
         * </p>
         * 
         * @param scaleInPolicy
         *        The sacle-in policy for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInPolicy(ScaleInPolicy scaleInPolicy);

        /**
         * <p>
         * The sacle-in policy for the connector.
         * </p>
         * This is a convenience that creates an instance of the {@link ScaleInPolicy.Builder} avoiding the need to
         * create one manually via {@link ScaleInPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScaleInPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #scaleInPolicy(ScaleInPolicy)}.
         * 
         * @param scaleInPolicy
         *        a consumer that will call methods on {@link ScaleInPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaleInPolicy(ScaleInPolicy)
         */
        default Builder scaleInPolicy(Consumer<ScaleInPolicy.Builder> scaleInPolicy) {
            return scaleInPolicy(ScaleInPolicy.builder().applyMutation(scaleInPolicy).build());
        }

        /**
         * <p>
         * The sacle-out policy for the connector.
         * </p>
         * 
         * @param scaleOutPolicy
         *        The sacle-out policy for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutPolicy(ScaleOutPolicy scaleOutPolicy);

        /**
         * <p>
         * The sacle-out policy for the connector.
         * </p>
         * This is a convenience that creates an instance of the {@link ScaleOutPolicy.Builder} avoiding the need to
         * create one manually via {@link ScaleOutPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScaleOutPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #scaleOutPolicy(ScaleOutPolicy)}.
         * 
         * @param scaleOutPolicy
         *        a consumer that will call methods on {@link ScaleOutPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaleOutPolicy(ScaleOutPolicy)
         */
        default Builder scaleOutPolicy(Consumer<ScaleOutPolicy.Builder> scaleOutPolicy) {
            return scaleOutPolicy(ScaleOutPolicy.builder().applyMutation(scaleOutPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer maxWorkerCount;

        private Integer mcuCount;

        private Integer minWorkerCount;

        private ScaleInPolicy scaleInPolicy;

        private ScaleOutPolicy scaleOutPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScaling model) {
            maxWorkerCount(model.maxWorkerCount);
            mcuCount(model.mcuCount);
            minWorkerCount(model.minWorkerCount);
            scaleInPolicy(model.scaleInPolicy);
            scaleOutPolicy(model.scaleOutPolicy);
        }

        public final Integer getMaxWorkerCount() {
            return maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        @Transient
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final Integer getMcuCount() {
            return mcuCount;
        }

        public final void setMcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
        }

        @Override
        @Transient
        public final Builder mcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        @Transient
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final ScaleInPolicy.Builder getScaleInPolicy() {
            return scaleInPolicy != null ? scaleInPolicy.toBuilder() : null;
        }

        public final void setScaleInPolicy(ScaleInPolicy.BuilderImpl scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy != null ? scaleInPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder scaleInPolicy(ScaleInPolicy scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy;
            return this;
        }

        public final ScaleOutPolicy.Builder getScaleOutPolicy() {
            return scaleOutPolicy != null ? scaleOutPolicy.toBuilder() : null;
        }

        public final void setScaleOutPolicy(ScaleOutPolicy.BuilderImpl scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy != null ? scaleOutPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder scaleOutPolicy(ScaleOutPolicy scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy;
            return this;
        }

        @Override
        public AutoScaling build() {
            return new AutoScaling(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
