/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the auto scaling parameters for the connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingDescription.Builder, AutoScalingDescription> {
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxWorkerCount").getter(getter(AutoScalingDescription::maxWorkerCount))
            .setter(setter(Builder::maxWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()).build();

    private static final SdkField<Integer> MCU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("mcuCount").getter(getter(AutoScalingDescription::mcuCount)).setter(setter(Builder::mcuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mcuCount").build()).build();

    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minWorkerCount").getter(getter(AutoScalingDescription::minWorkerCount))
            .setter(setter(Builder::minWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()).build();

    private static final SdkField<ScaleInPolicyDescription> SCALE_IN_POLICY_FIELD = SdkField
            .<ScaleInPolicyDescription> builder(MarshallingType.SDK_POJO).memberName("scaleInPolicy")
            .getter(getter(AutoScalingDescription::scaleInPolicy)).setter(setter(Builder::scaleInPolicy))
            .constructor(ScaleInPolicyDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInPolicy").build()).build();

    private static final SdkField<ScaleOutPolicyDescription> SCALE_OUT_POLICY_FIELD = SdkField
            .<ScaleOutPolicyDescription> builder(MarshallingType.SDK_POJO).memberName("scaleOutPolicy")
            .getter(getter(AutoScalingDescription::scaleOutPolicy)).setter(setter(Builder::scaleOutPolicy))
            .constructor(ScaleOutPolicyDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_WORKER_COUNT_FIELD,
            MCU_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, SCALE_IN_POLICY_FIELD, SCALE_OUT_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxWorkerCount;

    private final Integer mcuCount;

    private final Integer minWorkerCount;

    private final ScaleInPolicyDescription scaleInPolicy;

    private final ScaleOutPolicyDescription scaleOutPolicy;

    private AutoScalingDescription(BuilderImpl builder) {
        this.maxWorkerCount = builder.maxWorkerCount;
        this.mcuCount = builder.mcuCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.scaleInPolicy = builder.scaleInPolicy;
        this.scaleOutPolicy = builder.scaleOutPolicy;
    }

    /**
     * <p>
     * The maximum number of workers allocated to the connector.
     * </p>
     * 
     * @return The maximum number of workers allocated to the connector.
     */
    public final Integer maxWorkerCount() {
        return maxWorkerCount;
    }

    /**
     * <p>
     * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
     * </p>
     * 
     * @return The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
     *         1,2,4,8.
     */
    public final Integer mcuCount() {
        return mcuCount;
    }

    /**
     * <p>
     * The minimum number of workers allocated to the connector.
     * </p>
     * 
     * @return The minimum number of workers allocated to the connector.
     */
    public final Integer minWorkerCount() {
        return minWorkerCount;
    }

    /**
     * <p>
     * The sacle-in policy for the connector.
     * </p>
     * 
     * @return The sacle-in policy for the connector.
     */
    public final ScaleInPolicyDescription scaleInPolicy() {
        return scaleInPolicy;
    }

    /**
     * <p>
     * The sacle-out policy for the connector.&gt;
     * </p>
     * 
     * @return The sacle-out policy for the connector.&gt;
     */
    public final ScaleOutPolicyDescription scaleOutPolicy() {
        return scaleOutPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(mcuCount());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingDescription)) {
            return false;
        }
        AutoScalingDescription other = (AutoScalingDescription) obj;
        return Objects.equals(maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(mcuCount(), other.mcuCount())
                && Objects.equals(minWorkerCount(), other.minWorkerCount())
                && Objects.equals(scaleInPolicy(), other.scaleInPolicy())
                && Objects.equals(scaleOutPolicy(), other.scaleOutPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingDescription").add("MaxWorkerCount", maxWorkerCount()).add("McuCount", mcuCount())
                .add("MinWorkerCount", minWorkerCount()).add("ScaleInPolicy", scaleInPolicy())
                .add("ScaleOutPolicy", scaleOutPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxWorkerCount":
            return Optional.ofNullable(clazz.cast(maxWorkerCount()));
        case "mcuCount":
            return Optional.ofNullable(clazz.cast(mcuCount()));
        case "minWorkerCount":
            return Optional.ofNullable(clazz.cast(minWorkerCount()));
        case "scaleInPolicy":
            return Optional.ofNullable(clazz.cast(scaleInPolicy()));
        case "scaleOutPolicy":
            return Optional.ofNullable(clazz.cast(scaleOutPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingDescription, T> g) {
        return obj -> g.apply((AutoScalingDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingDescription> {
        /**
         * <p>
         * The maximum number of workers allocated to the connector.
         * </p>
         * 
         * @param maxWorkerCount
         *        The maximum number of workers allocated to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkerCount(Integer maxWorkerCount);

        /**
         * <p>
         * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
         * </p>
         * 
         * @param mcuCount
         *        The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
         *        1,2,4,8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcuCount(Integer mcuCount);

        /**
         * <p>
         * The minimum number of workers allocated to the connector.
         * </p>
         * 
         * @param minWorkerCount
         *        The minimum number of workers allocated to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkerCount(Integer minWorkerCount);

        /**
         * <p>
         * The sacle-in policy for the connector.
         * </p>
         * 
         * @param scaleInPolicy
         *        The sacle-in policy for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInPolicy(ScaleInPolicyDescription scaleInPolicy);

        /**
         * <p>
         * The sacle-in policy for the connector.
         * </p>
         * This is a convenience that creates an instance of the {@link ScaleInPolicyDescription.Builder} avoiding the
         * need to create one manually via {@link ScaleInPolicyDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScaleInPolicyDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #scaleInPolicy(ScaleInPolicyDescription)}.
         * 
         * @param scaleInPolicy
         *        a consumer that will call methods on {@link ScaleInPolicyDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaleInPolicy(ScaleInPolicyDescription)
         */
        default Builder scaleInPolicy(Consumer<ScaleInPolicyDescription.Builder> scaleInPolicy) {
            return scaleInPolicy(ScaleInPolicyDescription.builder().applyMutation(scaleInPolicy).build());
        }

        /**
         * <p>
         * The sacle-out policy for the connector.&gt;
         * </p>
         * 
         * @param scaleOutPolicy
         *        The sacle-out policy for the connector.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutPolicy(ScaleOutPolicyDescription scaleOutPolicy);

        /**
         * <p>
         * The sacle-out policy for the connector.&gt;
         * </p>
         * This is a convenience that creates an instance of the {@link ScaleOutPolicyDescription.Builder} avoiding the
         * need to create one manually via {@link ScaleOutPolicyDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScaleOutPolicyDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #scaleOutPolicy(ScaleOutPolicyDescription)}.
         * 
         * @param scaleOutPolicy
         *        a consumer that will call methods on {@link ScaleOutPolicyDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaleOutPolicy(ScaleOutPolicyDescription)
         */
        default Builder scaleOutPolicy(Consumer<ScaleOutPolicyDescription.Builder> scaleOutPolicy) {
            return scaleOutPolicy(ScaleOutPolicyDescription.builder().applyMutation(scaleOutPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer maxWorkerCount;

        private Integer mcuCount;

        private Integer minWorkerCount;

        private ScaleInPolicyDescription scaleInPolicy;

        private ScaleOutPolicyDescription scaleOutPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingDescription model) {
            maxWorkerCount(model.maxWorkerCount);
            mcuCount(model.mcuCount);
            minWorkerCount(model.minWorkerCount);
            scaleInPolicy(model.scaleInPolicy);
            scaleOutPolicy(model.scaleOutPolicy);
        }

        public final Integer getMaxWorkerCount() {
            return maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        @Transient
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final Integer getMcuCount() {
            return mcuCount;
        }

        public final void setMcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
        }

        @Override
        @Transient
        public final Builder mcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        @Transient
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final ScaleInPolicyDescription.Builder getScaleInPolicy() {
            return scaleInPolicy != null ? scaleInPolicy.toBuilder() : null;
        }

        public final void setScaleInPolicy(ScaleInPolicyDescription.BuilderImpl scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy != null ? scaleInPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder scaleInPolicy(ScaleInPolicyDescription scaleInPolicy) {
            this.scaleInPolicy = scaleInPolicy;
            return this;
        }

        public final ScaleOutPolicyDescription.Builder getScaleOutPolicy() {
            return scaleOutPolicy != null ? scaleOutPolicy.toBuilder() : null;
        }

        public final void setScaleOutPolicy(ScaleOutPolicyDescription.BuilderImpl scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy != null ? scaleOutPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder scaleOutPolicy(ScaleOutPolicyDescription scaleOutPolicy) {
            this.scaleOutPolicy = scaleOutPolicy;
            return this;
        }

        @Override
        public AutoScalingDescription build() {
            return new AutoScalingDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
