/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target capacity for the connector. The capacity can be auto scaled or provisioned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityUpdate implements SdkPojo, Serializable, ToCopyableBuilder<CapacityUpdate.Builder, CapacityUpdate> {
    private static final SdkField<AutoScalingUpdate> AUTO_SCALING_FIELD = SdkField
            .<AutoScalingUpdate> builder(MarshallingType.SDK_POJO).memberName("autoScaling")
            .getter(getter(CapacityUpdate::autoScaling)).setter(setter(Builder::autoScaling))
            .constructor(AutoScalingUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScaling").build()).build();

    private static final SdkField<ProvisionedCapacityUpdate> PROVISIONED_CAPACITY_FIELD = SdkField
            .<ProvisionedCapacityUpdate> builder(MarshallingType.SDK_POJO).memberName("provisionedCapacity")
            .getter(getter(CapacityUpdate::provisionedCapacity)).setter(setter(Builder::provisionedCapacity))
            .constructor(ProvisionedCapacityUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedCapacity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_FIELD,
            PROVISIONED_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoScalingUpdate autoScaling;

    private final ProvisionedCapacityUpdate provisionedCapacity;

    private CapacityUpdate(BuilderImpl builder) {
        this.autoScaling = builder.autoScaling;
        this.provisionedCapacity = builder.provisionedCapacity;
    }

    /**
     * <p>
     * The target auto scaling setting.
     * </p>
     * 
     * @return The target auto scaling setting.
     */
    public final AutoScalingUpdate autoScaling() {
        return autoScaling;
    }

    /**
     * <p>
     * The target settings for provisioned capacity.
     * </p>
     * 
     * @return The target settings for provisioned capacity.
     */
    public final ProvisionedCapacityUpdate provisionedCapacity() {
        return provisionedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScaling());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityUpdate)) {
            return false;
        }
        CapacityUpdate other = (CapacityUpdate) obj;
        return Objects.equals(autoScaling(), other.autoScaling())
                && Objects.equals(provisionedCapacity(), other.provisionedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityUpdate").add("AutoScaling", autoScaling())
                .add("ProvisionedCapacity", provisionedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoScaling":
            return Optional.ofNullable(clazz.cast(autoScaling()));
        case "provisionedCapacity":
            return Optional.ofNullable(clazz.cast(provisionedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityUpdate, T> g) {
        return obj -> g.apply((CapacityUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityUpdate> {
        /**
         * <p>
         * The target auto scaling setting.
         * </p>
         * 
         * @param autoScaling
         *        The target auto scaling setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScaling(AutoScalingUpdate autoScaling);

        /**
         * <p>
         * The target auto scaling setting.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingUpdate.Builder} avoiding the need to
         * create one manually via {@link AutoScalingUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #autoScaling(AutoScalingUpdate)}.
         * 
         * @param autoScaling
         *        a consumer that will call methods on {@link AutoScalingUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScaling(AutoScalingUpdate)
         */
        default Builder autoScaling(Consumer<AutoScalingUpdate.Builder> autoScaling) {
            return autoScaling(AutoScalingUpdate.builder().applyMutation(autoScaling).build());
        }

        /**
         * <p>
         * The target settings for provisioned capacity.
         * </p>
         * 
         * @param provisionedCapacity
         *        The target settings for provisioned capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCapacity(ProvisionedCapacityUpdate provisionedCapacity);

        /**
         * <p>
         * The target settings for provisioned capacity.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedCapacityUpdate.Builder} avoiding the
         * need to create one manually via {@link ProvisionedCapacityUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedCapacityUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionedCapacity(ProvisionedCapacityUpdate)}.
         * 
         * @param provisionedCapacity
         *        a consumer that will call methods on {@link ProvisionedCapacityUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedCapacity(ProvisionedCapacityUpdate)
         */
        default Builder provisionedCapacity(Consumer<ProvisionedCapacityUpdate.Builder> provisionedCapacity) {
            return provisionedCapacity(ProvisionedCapacityUpdate.builder().applyMutation(provisionedCapacity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoScalingUpdate autoScaling;

        private ProvisionedCapacityUpdate provisionedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityUpdate model) {
            autoScaling(model.autoScaling);
            provisionedCapacity(model.provisionedCapacity);
        }

        public final AutoScalingUpdate.Builder getAutoScaling() {
            return autoScaling != null ? autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(AutoScalingUpdate.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        @Transient
        public final Builder autoScaling(AutoScalingUpdate autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        public final ProvisionedCapacityUpdate.Builder getProvisionedCapacity() {
            return provisionedCapacity != null ? provisionedCapacity.toBuilder() : null;
        }

        public final void setProvisionedCapacity(ProvisionedCapacityUpdate.BuilderImpl provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity != null ? provisionedCapacity.build() : null;
        }

        @Override
        @Transient
        public final Builder provisionedCapacity(ProvisionedCapacityUpdate provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity;
            return this;
        }

        @Override
        public CapacityUpdate build() {
            return new CapacityUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
