/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomPluginRequest extends KafkaConnectRequest implements
        ToCopyableBuilder<CreateCustomPluginRequest.Builder, CreateCustomPluginRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(CreateCustomPluginRequest::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCustomPluginRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<CustomPluginLocation> LOCATION_FIELD = SdkField
            .<CustomPluginLocation> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(CreateCustomPluginRequest::location)).setter(setter(Builder::location))
            .constructor(CustomPluginLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCustomPluginRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            DESCRIPTION_FIELD, LOCATION_FIELD, NAME_FIELD));

    private final String contentType;

    private final String description;

    private final CustomPluginLocation location;

    private final String name;

    private CreateCustomPluginRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.description = builder.description;
        this.location = builder.location;
        this.name = builder.name;
    }

    /**
     * <p>
     * The type of the plugin file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CustomPluginContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The type of the plugin file.
     * @see CustomPluginContentType
     */
    public final CustomPluginContentType contentType() {
        return CustomPluginContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The type of the plugin file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CustomPluginContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The type of the plugin file.
     * @see CustomPluginContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * A summary description of the custom plugin.
     * </p>
     * 
     * @return A summary description of the custom plugin.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the location of a custom plugin.
     * </p>
     * 
     * @return Information about the location of a custom plugin.
     */
    public final CustomPluginLocation location() {
        return location;
    }

    /**
     * <p>
     * The name of the custom plugin.
     * </p>
     * 
     * @return The name of the custom plugin.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomPluginRequest)) {
            return false;
        }
        CreateCustomPluginRequest other = (CreateCustomPluginRequest) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(location(), other.location())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomPluginRequest").add("ContentType", contentTypeAsString())
                .add("Description", description()).add("Location", location()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomPluginRequest, T> g) {
        return obj -> g.apply((CreateCustomPluginRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomPluginRequest> {
        /**
         * <p>
         * The type of the plugin file.
         * </p>
         * 
         * @param contentType
         *        The type of the plugin file.
         * @see CustomPluginContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The type of the plugin file.
         * </p>
         * 
         * @param contentType
         *        The type of the plugin file.
         * @see CustomPluginContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginContentType
         */
        Builder contentType(CustomPluginContentType contentType);

        /**
         * <p>
         * A summary description of the custom plugin.
         * </p>
         * 
         * @param description
         *        A summary description of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the location of a custom plugin.
         * </p>
         * 
         * @param location
         *        Information about the location of a custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(CustomPluginLocation location);

        /**
         * <p>
         * Information about the location of a custom plugin.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomPluginLocation.Builder} avoiding the need
         * to create one manually via {@link CustomPluginLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomPluginLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #location(CustomPluginLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link CustomPluginLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(CustomPluginLocation)
         */
        default Builder location(Consumer<CustomPluginLocation.Builder> location) {
            return location(CustomPluginLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The name of the custom plugin.
         * </p>
         * 
         * @param name
         *        The name of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaConnectRequest.BuilderImpl implements Builder {
        private String contentType;

        private String description;

        private CustomPluginLocation location;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomPluginRequest model) {
            super(model);
            contentType(model.contentType);
            description(model.description);
            location(model.location);
            name(model.name);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentType(CustomPluginContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CustomPluginLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(CustomPluginLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(CustomPluginLocation location) {
            this.location = location;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomPluginRequest build() {
            return new CreateCustomPluginRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
