/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkerConfigurationRequest extends KafkaConnectRequest implements
        ToCopyableBuilder<CreateWorkerConfigurationRequest.Builder, CreateWorkerConfigurationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateWorkerConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkerConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROPERTIES_FILE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertiesFileContent").getter(getter(CreateWorkerConfigurationRequest::propertiesFileContent))
            .setter(setter(Builder::propertiesFileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertiesFileContent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD,
            PROPERTIES_FILE_CONTENT_FIELD));

    private final String description;

    private final String name;

    private final String propertiesFileContent;

    private CreateWorkerConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.propertiesFileContent = builder.propertiesFileContent;
    }

    /**
     * <p>
     * A summary description of the worker configuration.
     * </p>
     * 
     * @return A summary description of the worker configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the worker configuration.
     * </p>
     * 
     * @return The name of the worker configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Base64 encoded contents of connect-distributed.properties file.
     * </p>
     * 
     * @return Base64 encoded contents of connect-distributed.properties file.
     */
    public final String propertiesFileContent() {
        return propertiesFileContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(propertiesFileContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkerConfigurationRequest)) {
            return false;
        }
        CreateWorkerConfigurationRequest other = (CreateWorkerConfigurationRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(propertiesFileContent(), other.propertiesFileContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkerConfigurationRequest").add("Description", description()).add("Name", name())
                .add("PropertiesFileContent", propertiesFileContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "propertiesFileContent":
            return Optional.ofNullable(clazz.cast(propertiesFileContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkerConfigurationRequest, T> g) {
        return obj -> g.apply((CreateWorkerConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkerConfigurationRequest> {
        /**
         * <p>
         * A summary description of the worker configuration.
         * </p>
         * 
         * @param description
         *        A summary description of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the worker configuration.
         * </p>
         * 
         * @param name
         *        The name of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Base64 encoded contents of connect-distributed.properties file.
         * </p>
         * 
         * @param propertiesFileContent
         *        Base64 encoded contents of connect-distributed.properties file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesFileContent(String propertiesFileContent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaConnectRequest.BuilderImpl implements Builder {
        private String description;

        private String name;

        private String propertiesFileContent;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkerConfigurationRequest model) {
            super(model);
            description(model.description);
            name(model.name);
            propertiesFileContent(model.propertiesFileContent);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPropertiesFileContent() {
            return propertiesFileContent;
        }

        public final void setPropertiesFileContent(String propertiesFileContent) {
            this.propertiesFileContent = propertiesFileContent;
        }

        @Override
        @Transient
        public final Builder propertiesFileContent(String propertiesFileContent) {
            this.propertiesFileContent = propertiesFileContent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkerConfigurationRequest build() {
            return new CreateWorkerConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
