/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkerConfigurationRequest extends KafkaConnectRequest implements
        ToCopyableBuilder<DescribeWorkerConfigurationRequest.Builder, DescribeWorkerConfigurationRequest> {
    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerConfigurationArn").getter(getter(DescribeWorkerConfigurationRequest::workerConfigurationArn))
            .setter(setter(Builder::workerConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workerConfigurationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WORKER_CONFIGURATION_ARN_FIELD));

    private final String workerConfigurationArn;

    private DescribeWorkerConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.workerConfigurationArn = builder.workerConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.
     */
    public final String workerConfigurationArn() {
        return workerConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workerConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkerConfigurationRequest)) {
            return false;
        }
        DescribeWorkerConfigurationRequest other = (DescribeWorkerConfigurationRequest) obj;
        return Objects.equals(workerConfigurationArn(), other.workerConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkerConfigurationRequest").add("WorkerConfigurationArn", workerConfigurationArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workerConfigurationArn":
            return Optional.ofNullable(clazz.cast(workerConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkerConfigurationRequest, T> g) {
        return obj -> g.apply((DescribeWorkerConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkerConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.
         * </p>
         * 
         * @param workerConfigurationArn
         *        The Amazon Resource Name (ARN) of the worker configuration that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfigurationArn(String workerConfigurationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaConnectRequest.BuilderImpl implements Builder {
        private String workerConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkerConfigurationRequest model) {
            super(model);
            workerConfigurationArn(model.workerConfigurationArn);
        }

        public final String getWorkerConfigurationArn() {
            return workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        @Transient
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkerConfigurationRequest build() {
            return new DescribeWorkerConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
