/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the Apache Kafka cluster to which the connector is connected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KafkaCluster implements SdkPojo, Serializable, ToCopyableBuilder<KafkaCluster.Builder, KafkaCluster> {
    private static final SdkField<ApacheKafkaCluster> APACHE_KAFKA_CLUSTER_FIELD = SdkField
            .<ApacheKafkaCluster> builder(MarshallingType.SDK_POJO).memberName("apacheKafkaCluster")
            .getter(getter(KafkaCluster::apacheKafkaCluster)).setter(setter(Builder::apacheKafkaCluster))
            .constructor(ApacheKafkaCluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apacheKafkaCluster").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APACHE_KAFKA_CLUSTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final ApacheKafkaCluster apacheKafkaCluster;

    private KafkaCluster(BuilderImpl builder) {
        this.apacheKafkaCluster = builder.apacheKafkaCluster;
    }

    /**
     * <p>
     * The Apache Kafka cluster to which the connector is connected.
     * </p>
     * 
     * @return The Apache Kafka cluster to which the connector is connected.
     */
    public final ApacheKafkaCluster apacheKafkaCluster() {
        return apacheKafkaCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apacheKafkaCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaCluster)) {
            return false;
        }
        KafkaCluster other = (KafkaCluster) obj;
        return Objects.equals(apacheKafkaCluster(), other.apacheKafkaCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KafkaCluster").add("ApacheKafkaCluster", apacheKafkaCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apacheKafkaCluster":
            return Optional.ofNullable(clazz.cast(apacheKafkaCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaCluster, T> g) {
        return obj -> g.apply((KafkaCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KafkaCluster> {
        /**
         * <p>
         * The Apache Kafka cluster to which the connector is connected.
         * </p>
         * 
         * @param apacheKafkaCluster
         *        The Apache Kafka cluster to which the connector is connected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apacheKafkaCluster(ApacheKafkaCluster apacheKafkaCluster);

        /**
         * <p>
         * The Apache Kafka cluster to which the connector is connected.
         * </p>
         * This is a convenience that creates an instance of the {@link ApacheKafkaCluster.Builder} avoiding the need to
         * create one manually via {@link ApacheKafkaCluster#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApacheKafkaCluster.Builder#build()} is called immediately and its
         * result is passed to {@link #apacheKafkaCluster(ApacheKafkaCluster)}.
         * 
         * @param apacheKafkaCluster
         *        a consumer that will call methods on {@link ApacheKafkaCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apacheKafkaCluster(ApacheKafkaCluster)
         */
        default Builder apacheKafkaCluster(Consumer<ApacheKafkaCluster.Builder> apacheKafkaCluster) {
            return apacheKafkaCluster(ApacheKafkaCluster.builder().applyMutation(apacheKafkaCluster).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApacheKafkaCluster apacheKafkaCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaCluster model) {
            apacheKafkaCluster(model.apacheKafkaCluster);
        }

        public final ApacheKafkaCluster.Builder getApacheKafkaCluster() {
            return apacheKafkaCluster != null ? apacheKafkaCluster.toBuilder() : null;
        }

        public final void setApacheKafkaCluster(ApacheKafkaCluster.BuilderImpl apacheKafkaCluster) {
            this.apacheKafkaCluster = apacheKafkaCluster != null ? apacheKafkaCluster.build() : null;
        }

        @Override
        @Transient
        public final Builder apacheKafkaCluster(ApacheKafkaCluster apacheKafkaCluster) {
            this.apacheKafkaCluster = apacheKafkaCluster;
            return this;
        }

        @Override
        public KafkaCluster build() {
            return new KafkaCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
