/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of how to connect to the Apache Kafka cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KafkaClusterDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<KafkaClusterDescription.Builder, KafkaClusterDescription> {
    private static final SdkField<ApacheKafkaClusterDescription> APACHE_KAFKA_CLUSTER_FIELD = SdkField
            .<ApacheKafkaClusterDescription> builder(MarshallingType.SDK_POJO).memberName("apacheKafkaCluster")
            .getter(getter(KafkaClusterDescription::apacheKafkaCluster)).setter(setter(Builder::apacheKafkaCluster))
            .constructor(ApacheKafkaClusterDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apacheKafkaCluster").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APACHE_KAFKA_CLUSTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final ApacheKafkaClusterDescription apacheKafkaCluster;

    private KafkaClusterDescription(BuilderImpl builder) {
        this.apacheKafkaCluster = builder.apacheKafkaCluster;
    }

    /**
     * <p>
     * The Apache Kafka cluster to which the connector is connected.
     * </p>
     * 
     * @return The Apache Kafka cluster to which the connector is connected.
     */
    public final ApacheKafkaClusterDescription apacheKafkaCluster() {
        return apacheKafkaCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apacheKafkaCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaClusterDescription)) {
            return false;
        }
        KafkaClusterDescription other = (KafkaClusterDescription) obj;
        return Objects.equals(apacheKafkaCluster(), other.apacheKafkaCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KafkaClusterDescription").add("ApacheKafkaCluster", apacheKafkaCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apacheKafkaCluster":
            return Optional.ofNullable(clazz.cast(apacheKafkaCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaClusterDescription, T> g) {
        return obj -> g.apply((KafkaClusterDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KafkaClusterDescription> {
        /**
         * <p>
         * The Apache Kafka cluster to which the connector is connected.
         * </p>
         * 
         * @param apacheKafkaCluster
         *        The Apache Kafka cluster to which the connector is connected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apacheKafkaCluster(ApacheKafkaClusterDescription apacheKafkaCluster);

        /**
         * <p>
         * The Apache Kafka cluster to which the connector is connected.
         * </p>
         * This is a convenience that creates an instance of the {@link ApacheKafkaClusterDescription.Builder} avoiding
         * the need to create one manually via {@link ApacheKafkaClusterDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApacheKafkaClusterDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #apacheKafkaCluster(ApacheKafkaClusterDescription)}.
         * 
         * @param apacheKafkaCluster
         *        a consumer that will call methods on {@link ApacheKafkaClusterDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apacheKafkaCluster(ApacheKafkaClusterDescription)
         */
        default Builder apacheKafkaCluster(Consumer<ApacheKafkaClusterDescription.Builder> apacheKafkaCluster) {
            return apacheKafkaCluster(ApacheKafkaClusterDescription.builder().applyMutation(apacheKafkaCluster).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApacheKafkaClusterDescription apacheKafkaCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaClusterDescription model) {
            apacheKafkaCluster(model.apacheKafkaCluster);
        }

        public final ApacheKafkaClusterDescription.Builder getApacheKafkaCluster() {
            return apacheKafkaCluster != null ? apacheKafkaCluster.toBuilder() : null;
        }

        public final void setApacheKafkaCluster(ApacheKafkaClusterDescription.BuilderImpl apacheKafkaCluster) {
            this.apacheKafkaCluster = apacheKafkaCluster != null ? apacheKafkaCluster.build() : null;
        }

        @Override
        @Transient
        public final Builder apacheKafkaCluster(ApacheKafkaClusterDescription apacheKafkaCluster) {
            this.apacheKafkaCluster = apacheKafkaCluster;
            return this;
        }

        @Override
        public KafkaClusterDescription build() {
            return new KafkaClusterDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
