/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectorsResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<ListConnectorsResponse.Builder, ListConnectorsResponse> {
    private static final SdkField<List<ConnectorSummary>> CONNECTORS_FIELD = SdkField
            .<List<ConnectorSummary>> builder(MarshallingType.LIST)
            .memberName("connectors")
            .getter(getter(ListConnectorsResponse::connectors))
            .setter(setter(Builder::connectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConnectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ConnectorSummary> connectors;

    private final String nextToken;

    private ListConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.connectors = builder.connectors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConnectors() {
        return connectors != null && !(connectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of connector descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectors} method.
     * </p>
     * 
     * @return An array of connector descriptions.
     */
    public final List<ConnectorSummary> connectors() {
        return connectors;
    }

    /**
     * <p>
     * If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken in a
     * subsequent request to continue listing from where it left off.
     * </p>
     * 
     * @return If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this
     *         NextToken in a subsequent request to continue listing from where it left off.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectors() ? connectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorsResponse)) {
            return false;
        }
        ListConnectorsResponse other = (ListConnectorsResponse) obj;
        return hasConnectors() == other.hasConnectors() && Objects.equals(connectors(), other.connectors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectorsResponse").add("Connectors", hasConnectors() ? connectors() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectors":
            return Optional.ofNullable(clazz.cast(connectors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorsResponse, T> g) {
        return obj -> g.apply((ListConnectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectorsResponse> {
        /**
         * <p>
         * An array of connector descriptions.
         * </p>
         * 
         * @param connectors
         *        An array of connector descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(Collection<ConnectorSummary> connectors);

        /**
         * <p>
         * An array of connector descriptions.
         * </p>
         * 
         * @param connectors
         *        An array of connector descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(ConnectorSummary... connectors);

        /**
         * <p>
         * An array of connector descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConnectorSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ConnectorSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectorSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #connectors(List<ConnectorSummary>)}.
         * 
         * @param connectors
         *        a consumer that will call methods on {@link List<ConnectorSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectors(List<ConnectorSummary>)
         */
        Builder connectors(Consumer<ConnectorSummary.Builder>... connectors);

        /**
         * <p>
         * If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this NextToken
         * in a subsequent request to continue listing from where it left off.
         * </p>
         * 
         * @param nextToken
         *        If the response of a ListConnectors operation is truncated, it will include a NextToken. Send this
         *        NextToken in a subsequent request to continue listing from where it left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private List<ConnectorSummary> connectors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorsResponse model) {
            super(model);
            connectors(model.connectors);
            nextToken(model.nextToken);
        }

        public final List<ConnectorSummary.Builder> getConnectors() {
            List<ConnectorSummary.Builder> result = ___listOfConnectorSummaryCopier.copyToBuilder(this.connectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectors(Collection<ConnectorSummary.BuilderImpl> connectors) {
            this.connectors = ___listOfConnectorSummaryCopier.copyFromBuilder(connectors);
        }

        @Override
        @Transient
        public final Builder connectors(Collection<ConnectorSummary> connectors) {
            this.connectors = ___listOfConnectorSummaryCopier.copy(connectors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectors(ConnectorSummary... connectors) {
            connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectors(Consumer<ConnectorSummary.Builder>... connectors) {
            connectors(Stream.of(connectors).map(c -> ConnectorSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectorsResponse build() {
            return new ListConnectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
