/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about log delivery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogDelivery implements SdkPojo, Serializable, ToCopyableBuilder<LogDelivery.Builder, LogDelivery> {
    private static final SdkField<WorkerLogDelivery> WORKER_LOG_DELIVERY_FIELD = SdkField
            .<WorkerLogDelivery> builder(MarshallingType.SDK_POJO).memberName("workerLogDelivery")
            .getter(getter(LogDelivery::workerLogDelivery)).setter(setter(Builder::workerLogDelivery))
            .constructor(WorkerLogDelivery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerLogDelivery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_LOG_DELIVERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final WorkerLogDelivery workerLogDelivery;

    private LogDelivery(BuilderImpl builder) {
        this.workerLogDelivery = builder.workerLogDelivery;
    }

    /**
     * <p>
     * The workers can send worker logs to different destination types. This configuration specifies the details of
     * these destinations.
     * </p>
     * 
     * @return The workers can send worker logs to different destination types. This configuration specifies the details
     *         of these destinations.
     */
    public final WorkerLogDelivery workerLogDelivery() {
        return workerLogDelivery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workerLogDelivery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogDelivery)) {
            return false;
        }
        LogDelivery other = (LogDelivery) obj;
        return Objects.equals(workerLogDelivery(), other.workerLogDelivery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogDelivery").add("WorkerLogDelivery", workerLogDelivery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workerLogDelivery":
            return Optional.ofNullable(clazz.cast(workerLogDelivery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogDelivery, T> g) {
        return obj -> g.apply((LogDelivery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogDelivery> {
        /**
         * <p>
         * The workers can send worker logs to different destination types. This configuration specifies the details of
         * these destinations.
         * </p>
         * 
         * @param workerLogDelivery
         *        The workers can send worker logs to different destination types. This configuration specifies the
         *        details of these destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerLogDelivery(WorkerLogDelivery workerLogDelivery);

        /**
         * <p>
         * The workers can send worker logs to different destination types. This configuration specifies the details of
         * these destinations.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkerLogDelivery.Builder} avoiding the need to
         * create one manually via {@link WorkerLogDelivery#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkerLogDelivery.Builder#build()} is called immediately and its
         * result is passed to {@link #workerLogDelivery(WorkerLogDelivery)}.
         * 
         * @param workerLogDelivery
         *        a consumer that will call methods on {@link WorkerLogDelivery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerLogDelivery(WorkerLogDelivery)
         */
        default Builder workerLogDelivery(Consumer<WorkerLogDelivery.Builder> workerLogDelivery) {
            return workerLogDelivery(WorkerLogDelivery.builder().applyMutation(workerLogDelivery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WorkerLogDelivery workerLogDelivery;

        private BuilderImpl() {
        }

        private BuilderImpl(LogDelivery model) {
            workerLogDelivery(model.workerLogDelivery);
        }

        public final WorkerLogDelivery.Builder getWorkerLogDelivery() {
            return workerLogDelivery != null ? workerLogDelivery.toBuilder() : null;
        }

        public final void setWorkerLogDelivery(WorkerLogDelivery.BuilderImpl workerLogDelivery) {
            this.workerLogDelivery = workerLogDelivery != null ? workerLogDelivery.build() : null;
        }

        @Override
        @Transient
        public final Builder workerLogDelivery(WorkerLogDelivery workerLogDelivery) {
            this.workerLogDelivery = workerLogDelivery;
            return this;
        }

        @Override
        public LogDelivery build() {
            return new LogDelivery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
