/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about delivering logs to Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3LogDelivery implements SdkPojo, Serializable, ToCopyableBuilder<S3LogDelivery.Builder, S3LogDelivery> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("bucket")
            .getter(getter(S3LogDelivery::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(S3LogDelivery::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(S3LogDelivery::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, ENABLED_FIELD,
            PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final Boolean enabled;

    private final String prefix;

    private S3LogDelivery(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.enabled = builder.enabled;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * The name of the S3 bucket that is the destination for log delivery.
     * </p>
     * 
     * @return The name of the S3 bucket that is the destination for log delivery.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * Specifies whether connector logs get sent to the specified Amazon S3 destination.
     * </p>
     * 
     * @return Specifies whether connector logs get sent to the specified Amazon S3 destination.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The S3 prefix that is the destination for log delivery.
     * </p>
     * 
     * @return The S3 prefix that is the destination for log delivery.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogDelivery)) {
            return false;
        }
        S3LogDelivery other = (S3LogDelivery) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3LogDelivery").add("Bucket", bucket()).add("Enabled", enabled()).add("Prefix", prefix())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3LogDelivery, T> g) {
        return obj -> g.apply((S3LogDelivery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3LogDelivery> {
        /**
         * <p>
         * The name of the S3 bucket that is the destination for log delivery.
         * </p>
         * 
         * @param bucket
         *        The name of the S3 bucket that is the destination for log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * Specifies whether connector logs get sent to the specified Amazon S3 destination.
         * </p>
         * 
         * @param enabled
         *        Specifies whether connector logs get sent to the specified Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The S3 prefix that is the destination for log delivery.
         * </p>
         * 
         * @param prefix
         *        The S3 prefix that is the destination for log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private Boolean enabled;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogDelivery model) {
            bucket(model.bucket);
            enabled(model.enabled);
            prefix(model.prefix);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        @Transient
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public S3LogDelivery build() {
            return new S3LogDelivery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
