/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the worker configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerConfigurationDescription.Builder, WorkerConfigurationDescription> {
    private static final SdkField<Long> REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("revision")
            .getter(getter(WorkerConfigurationDescription::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerConfigurationArn").getter(getter(WorkerConfigurationDescription::workerConfigurationArn))
            .setter(setter(Builder::workerConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_FIELD,
            WORKER_CONFIGURATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long revision;

    private final String workerConfigurationArn;

    private WorkerConfigurationDescription(BuilderImpl builder) {
        this.revision = builder.revision;
        this.workerConfigurationArn = builder.workerConfigurationArn;
    }

    /**
     * <p>
     * The revision of the worker configuration.
     * </p>
     * 
     * @return The revision of the worker configuration.
     */
    public final Long revision() {
        return revision;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the worker configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the worker configuration.
     */
    public final String workerConfigurationArn() {
        return workerConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(workerConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerConfigurationDescription)) {
            return false;
        }
        WorkerConfigurationDescription other = (WorkerConfigurationDescription) obj;
        return Objects.equals(revision(), other.revision())
                && Objects.equals(workerConfigurationArn(), other.workerConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerConfigurationDescription").add("Revision", revision())
                .add("WorkerConfigurationArn", workerConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "workerConfigurationArn":
            return Optional.ofNullable(clazz.cast(workerConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerConfigurationDescription, T> g) {
        return obj -> g.apply((WorkerConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerConfigurationDescription> {
        /**
         * <p>
         * The revision of the worker configuration.
         * </p>
         * 
         * @param revision
         *        The revision of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Long revision);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the worker configuration.
         * </p>
         * 
         * @param workerConfigurationArn
         *        The Amazon Resource Name (ARN) of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfigurationArn(String workerConfigurationArn);
    }

    static final class BuilderImpl implements Builder {
        private Long revision;

        private String workerConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerConfigurationDescription model) {
            revision(model.revision);
            workerConfigurationArn(model.workerConfigurationArn);
        }

        public final Long getRevision() {
            return revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        @Transient
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public final String getWorkerConfigurationArn() {
            return workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        @Transient
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        @Override
        public WorkerConfigurationDescription build() {
            return new WorkerConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
