/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the worker configuration revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerConfigurationRevisionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerConfigurationRevisionDescription.Builder, WorkerConfigurationRevisionDescription> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(WorkerConfigurationRevisionDescription::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(WorkerConfigurationRevisionDescription::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PROPERTIES_FILE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertiesFileContent").getter(getter(WorkerConfigurationRevisionDescription::propertiesFileContent))
            .setter(setter(Builder::propertiesFileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertiesFileContent").build())
            .build();

    private static final SdkField<Long> REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("revision")
            .getter(getter(WorkerConfigurationRevisionDescription::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            DESCRIPTION_FIELD, PROPERTIES_FILE_CONTENT_FIELD, REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String description;

    private final String propertiesFileContent;

    private final Long revision;

    private WorkerConfigurationRevisionDescription(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.propertiesFileContent = builder.propertiesFileContent;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The time that the worker configuration was created.
     * </p>
     * 
     * @return The time that the worker configuration was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the worker configuration revision.
     * </p>
     * 
     * @return The description of the worker configuration revision.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Base64 encoded contents of the connect-distributed.properties file.
     * </p>
     * 
     * @return Base64 encoded contents of the connect-distributed.properties file.
     */
    public final String propertiesFileContent() {
        return propertiesFileContent;
    }

    /**
     * <p>
     * The description of a revision of the worker configuration.
     * </p>
     * 
     * @return The description of a revision of the worker configuration.
     */
    public final Long revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(propertiesFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerConfigurationRevisionDescription)) {
            return false;
        }
        WorkerConfigurationRevisionDescription other = (WorkerConfigurationRevisionDescription) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(propertiesFileContent(), other.propertiesFileContent())
                && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerConfigurationRevisionDescription").add("CreationTime", creationTime())
                .add("Description", description()).add("PropertiesFileContent", propertiesFileContent())
                .add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "propertiesFileContent":
            return Optional.ofNullable(clazz.cast(propertiesFileContent()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerConfigurationRevisionDescription, T> g) {
        return obj -> g.apply((WorkerConfigurationRevisionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerConfigurationRevisionDescription> {
        /**
         * <p>
         * The time that the worker configuration was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the worker configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the worker configuration revision.
         * </p>
         * 
         * @param description
         *        The description of the worker configuration revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Base64 encoded contents of the connect-distributed.properties file.
         * </p>
         * 
         * @param propertiesFileContent
         *        Base64 encoded contents of the connect-distributed.properties file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesFileContent(String propertiesFileContent);

        /**
         * <p>
         * The description of a revision of the worker configuration.
         * </p>
         * 
         * @param revision
         *        The description of a revision of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Long revision);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String description;

        private String propertiesFileContent;

        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerConfigurationRevisionDescription model) {
            creationTime(model.creationTime);
            description(model.description);
            propertiesFileContent(model.propertiesFileContent);
            revision(model.revision);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPropertiesFileContent() {
            return propertiesFileContent;
        }

        public final void setPropertiesFileContent(String propertiesFileContent) {
            this.propertiesFileContent = propertiesFileContent;
        }

        @Override
        @Transient
        public final Builder propertiesFileContent(String propertiesFileContent) {
            this.propertiesFileContent = propertiesFileContent;
            return this;
        }

        public final Long getRevision() {
            return revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        @Transient
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public WorkerConfigurationRevisionDescription build() {
            return new WorkerConfigurationRevisionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
