/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Workers can send worker logs to different destination types. This configuration specifies the details of these
 * destinations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerLogDeliveryDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerLogDeliveryDescription.Builder, WorkerLogDeliveryDescription> {
    private static final SdkField<CloudWatchLogsLogDeliveryDescription> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogsLogDeliveryDescription> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(WorkerLogDeliveryDescription::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogsLogDeliveryDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<FirehoseLogDeliveryDescription> FIREHOSE_FIELD = SdkField
            .<FirehoseLogDeliveryDescription> builder(MarshallingType.SDK_POJO).memberName("firehose")
            .getter(getter(WorkerLogDeliveryDescription::firehose)).setter(setter(Builder::firehose))
            .constructor(FirehoseLogDeliveryDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()).build();

    private static final SdkField<S3LogDeliveryDescription> S3_FIELD = SdkField
            .<S3LogDeliveryDescription> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(WorkerLogDeliveryDescription::s3)).setter(setter(Builder::s3))
            .constructor(S3LogDeliveryDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            FIREHOSE_FIELD, S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogsLogDeliveryDescription cloudWatchLogs;

    private final FirehoseLogDeliveryDescription firehose;

    private final S3LogDeliveryDescription s3;

    private WorkerLogDeliveryDescription(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * Details about delivering logs to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return Details about delivering logs to Amazon CloudWatch Logs.
     */
    public final CloudWatchLogsLogDeliveryDescription cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Details about delivering logs to Amazon Kinesis Data Firehose.
     * </p>
     * 
     * @return Details about delivering logs to Amazon Kinesis Data Firehose.
     */
    public final FirehoseLogDeliveryDescription firehose() {
        return firehose;
    }

    /**
     * <p>
     * Details about delivering logs to Amazon S3.
     * </p>
     * 
     * @return Details about delivering logs to Amazon S3.
     */
    public final S3LogDeliveryDescription s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(firehose());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerLogDeliveryDescription)) {
            return false;
        }
        WorkerLogDeliveryDescription other = (WorkerLogDeliveryDescription) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(firehose(), other.firehose())
                && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerLogDeliveryDescription").add("CloudWatchLogs", cloudWatchLogs())
                .add("Firehose", firehose()).add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "firehose":
            return Optional.ofNullable(clazz.cast(firehose()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerLogDeliveryDescription, T> g) {
        return obj -> g.apply((WorkerLogDeliveryDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerLogDeliveryDescription> {
        /**
         * <p>
         * Details about delivering logs to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param cloudWatchLogs
         *        Details about delivering logs to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogsLogDeliveryDescription cloudWatchLogs);

        /**
         * <p>
         * Details about delivering logs to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLogsLogDeliveryDescription.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsLogDeliveryDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLogsLogDeliveryDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogs(CloudWatchLogsLogDeliveryDescription)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogsLogDeliveryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogsLogDeliveryDescription)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogsLogDeliveryDescription.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogsLogDeliveryDescription.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * Details about delivering logs to Amazon Kinesis Data Firehose.
         * </p>
         * 
         * @param firehose
         *        Details about delivering logs to Amazon Kinesis Data Firehose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(FirehoseLogDeliveryDescription firehose);

        /**
         * <p>
         * Details about delivering logs to Amazon Kinesis Data Firehose.
         * </p>
         * This is a convenience that creates an instance of the {@link FirehoseLogDeliveryDescription.Builder} avoiding
         * the need to create one manually via {@link FirehoseLogDeliveryDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirehoseLogDeliveryDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #firehose(FirehoseLogDeliveryDescription)}.
         * 
         * @param firehose
         *        a consumer that will call methods on {@link FirehoseLogDeliveryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehose(FirehoseLogDeliveryDescription)
         */
        default Builder firehose(Consumer<FirehoseLogDeliveryDescription.Builder> firehose) {
            return firehose(FirehoseLogDeliveryDescription.builder().applyMutation(firehose).build());
        }

        /**
         * <p>
         * Details about delivering logs to Amazon S3.
         * </p>
         * 
         * @param s3
         *        Details about delivering logs to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3LogDeliveryDescription s3);

        /**
         * <p>
         * Details about delivering logs to Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3LogDeliveryDescription.Builder} avoiding the
         * need to create one manually via {@link S3LogDeliveryDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3LogDeliveryDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #s3(S3LogDeliveryDescription)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3LogDeliveryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3LogDeliveryDescription)
         */
        default Builder s3(Consumer<S3LogDeliveryDescription.Builder> s3) {
            return s3(S3LogDeliveryDescription.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogsLogDeliveryDescription cloudWatchLogs;

        private FirehoseLogDeliveryDescription firehose;

        private S3LogDeliveryDescription s3;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerLogDeliveryDescription model) {
            cloudWatchLogs(model.cloudWatchLogs);
            firehose(model.firehose);
            s3(model.s3);
        }

        public final CloudWatchLogsLogDeliveryDescription.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsLogDeliveryDescription.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogs(CloudWatchLogsLogDeliveryDescription cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final FirehoseLogDeliveryDescription.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseLogDeliveryDescription.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        @Transient
        public final Builder firehose(FirehoseLogDeliveryDescription firehose) {
            this.firehose = firehose;
            return this;
        }

        public final S3LogDeliveryDescription.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3LogDeliveryDescription.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        @Transient
        public final Builder s3(S3LogDeliveryDescription s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public WorkerLogDeliveryDescription build() {
            return new WorkerLogDeliveryDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
