/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.kafkaconnect.model.BadRequestException;
import software.amazon.awssdk.services.kafkaconnect.model.ConflictException;
import software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ForbiddenException;
import software.amazon.awssdk.services.kafkaconnect.model.InternalServerErrorException;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectException;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.NotFoundException;
import software.amazon.awssdk.services.kafkaconnect.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kafkaconnect.model.TooManyRequestsException;
import software.amazon.awssdk.services.kafkaconnect.model.UnauthorizedException;
import software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsIterable;
import software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsIterable;
import software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsIterable;

/**
 * Service client for accessing Kafka Connect. This can be created using the static {@link #builder()} method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KafkaConnectClient extends SdkClient {
    String SERVICE_NAME = "kafkaconnect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kafkaconnect";

    /**
     * Create a {@link KafkaConnectClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KafkaConnectClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KafkaConnectClient}.
     */
    static KafkaConnectClientBuilder builder() {
        return new DefaultKafkaConnectClientBuilder();
    }

    /**
     * <p>
     * Creates a connector using the specified properties.
     * </p>
     *
     * @param createConnectorRequest
     * @return Result of the CreateConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another
     *         name.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConnectorResponse createConnector(CreateConnectorRequest createConnectorRequest) throws NotFoundException,
            ConflictException, BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connector using the specified properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectorRequest#builder()}
     * </p>
     *
     * @param createConnectorRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorRequest.Builder} to create a request.
     * @return Result of the CreateConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another
     *         name.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConnectorResponse createConnector(Consumer<CreateConnectorRequest.Builder> createConnectorRequest)
            throws NotFoundException, ConflictException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return createConnector(CreateConnectorRequest.builder().applyMutation(createConnectorRequest).build());
    }

    /**
     * <p>
     * Creates a custom plugin using the specified properties.
     * </p>
     *
     * @param createCustomPluginRequest
     * @return Result of the CreateCustomPlugin operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another
     *         name.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.CreateCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomPluginResponse createCustomPlugin(CreateCustomPluginRequest createCustomPluginRequest)
            throws NotFoundException, ConflictException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom plugin using the specified properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomPluginRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomPluginRequest#builder()}
     * </p>
     *
     * @param createCustomPluginRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomPluginRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCustomPlugin operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another
     *         name.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.CreateCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomPluginResponse createCustomPlugin(Consumer<CreateCustomPluginRequest.Builder> createCustomPluginRequest)
            throws NotFoundException, ConflictException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return createCustomPlugin(CreateCustomPluginRequest.builder().applyMutation(createCustomPluginRequest).build());
    }

    /**
     * <p>
     * Creates a worker configuration using the specified properties.
     * </p>
     *
     * @param createWorkerConfigurationRequest
     * @return Result of the CreateWorkerConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another
     *         name.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.CreateWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkerConfigurationResponse createWorkerConfiguration(
            CreateWorkerConfigurationRequest createWorkerConfigurationRequest) throws NotFoundException, ConflictException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a worker configuration using the specified properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkerConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWorkerConfigurationRequest#builder()}
     * </p>
     *
     * @param createWorkerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkerConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorkerConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws ConflictException
     *         HTTP Status Code 409: Conflict. A resource with this name already exists. Retry your request with another
     *         name.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.CreateWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/CreateWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkerConfigurationResponse createWorkerConfiguration(
            Consumer<CreateWorkerConfigurationRequest.Builder> createWorkerConfigurationRequest) throws NotFoundException,
            ConflictException, BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        return createWorkerConfiguration(CreateWorkerConfigurationRequest.builder()
                .applyMutation(createWorkerConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified connector.
     * </p>
     *
     * @param deleteConnectorRequest
     * @return Result of the DeleteConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConnectorResponse deleteConnector(DeleteConnectorRequest deleteConnectorRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectorRequest#builder()}
     * </p>
     *
     * @param deleteConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectorRequest.Builder} to create a request.
     * @return Result of the DeleteConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConnectorResponse deleteConnector(Consumer<DeleteConnectorRequest.Builder> deleteConnectorRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return deleteConnector(DeleteConnectorRequest.builder().applyMutation(deleteConnectorRequest).build());
    }

    /**
     * <p>
     * Deletes a custom plugin.
     * </p>
     *
     * @param deleteCustomPluginRequest
     * @return Result of the DeleteCustomPlugin operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DeleteCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomPluginResponse deleteCustomPlugin(DeleteCustomPluginRequest deleteCustomPluginRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomPluginRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomPluginRequest#builder()}
     * </p>
     *
     * @param deleteCustomPluginRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomPluginRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCustomPlugin operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DeleteCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DeleteCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomPluginResponse deleteCustomPlugin(Consumer<DeleteCustomPluginRequest.Builder> deleteCustomPluginRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return deleteCustomPlugin(DeleteCustomPluginRequest.builder().applyMutation(deleteCustomPluginRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the connector.
     * </p>
     *
     * @param describeConnectorRequest
     * @return Result of the DescribeConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorResponse describeConnector(DescribeConnectorRequest describeConnectorRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeConnectorRequest#builder()}
     * </p>
     *
     * @param describeConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorRequest.Builder} to create a request.
     * @return Result of the DescribeConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectorResponse describeConnector(Consumer<DescribeConnectorRequest.Builder> describeConnectorRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return describeConnector(DescribeConnectorRequest.builder().applyMutation(describeConnectorRequest).build());
    }

    /**
     * <p>
     * A summary description of the custom plugin.
     * </p>
     *
     * @param describeCustomPluginRequest
     * @return Result of the DescribeCustomPlugin operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DescribeCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomPluginResponse describeCustomPlugin(DescribeCustomPluginRequest describeCustomPluginRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A summary description of the custom plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomPluginRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCustomPluginRequest#builder()}
     * </p>
     *
     * @param describeCustomPluginRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomPluginRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCustomPlugin operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DescribeCustomPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeCustomPlugin"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomPluginResponse describeCustomPlugin(
            Consumer<DescribeCustomPluginRequest.Builder> describeCustomPluginRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        return describeCustomPlugin(DescribeCustomPluginRequest.builder().applyMutation(describeCustomPluginRequest).build());
    }

    /**
     * <p>
     * Returns information about a worker configuration.
     * </p>
     *
     * @param describeWorkerConfigurationRequest
     * @return Result of the DescribeWorkerConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DescribeWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkerConfigurationResponse describeWorkerConfiguration(
            DescribeWorkerConfigurationRequest describeWorkerConfigurationRequest) throws NotFoundException, BadRequestException,
            ForbiddenException, ServiceUnavailableException, TooManyRequestsException, UnauthorizedException,
            InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a worker configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkerConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWorkerConfigurationRequest#builder()}
     * </p>
     *
     * @param describeWorkerConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkerConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeWorkerConfiguration operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.DescribeWorkerConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/DescribeWorkerConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorkerConfigurationResponse describeWorkerConfiguration(
            Consumer<DescribeWorkerConfigurationRequest.Builder> describeWorkerConfigurationRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        return describeWorkerConfiguration(DescribeWorkerConfigurationRequest.builder()
                .applyMutation(describeWorkerConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     *
     * @param listConnectorsRequest
     * @return Result of the ListConnectors operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsResponse listConnectors(ListConnectorsRequest listConnectorsRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorsRequest.Builder} to create a request.
     * @return Result of the ListConnectors operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsResponse listConnectors(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return listConnectors(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsIterable responses = client
     *             .listConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation.</b>
     * </p>
     *
     * @param listConnectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsIterable listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name
     * starts with the specified prefix. The response also includes a description of each of the listed connectors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsIterable responses = client
     *             .listConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListConnectors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsIterable listConnectorsPaginator(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return listConnectorsPaginator(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     *
     * @param listCustomPluginsRequest
     * @return Result of the ListCustomPlugins operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomPluginsResponse listCustomPlugins(ListCustomPluginsRequest listCustomPluginsRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomPluginsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomPluginsRequest#builder()}
     * </p>
     *
     * @param listCustomPluginsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomPluginsRequest.Builder} to create a request.
     * @return Result of the ListCustomPlugins operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomPluginsResponse listCustomPlugins(Consumer<ListCustomPluginsRequest.Builder> listCustomPluginsRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return listCustomPlugins(ListCustomPluginsRequest.builder().applyMutation(listCustomPluginsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsIterable responses = client.listCustomPluginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsIterable responses = client
     *             .listCustomPluginsPaginator(request);
     *     for (software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsIterable responses = client.listCustomPluginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomPluginsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomPluginsIterable listCustomPluginsPaginator(ListCustomPluginsRequest listCustomPluginsRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the custom plugins in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsIterable responses = client.listCustomPluginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsIterable responses = client
     *             .listCustomPluginsPaginator(request);
     *     for (software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListCustomPluginsIterable responses = client.listCustomPluginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomPlugins(software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomPluginsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomPluginsRequest#builder()}
     * </p>
     *
     * @param listCustomPluginsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomPluginsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListCustomPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListCustomPlugins"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomPluginsIterable listCustomPluginsPaginator(
            Consumer<ListCustomPluginsRequest.Builder> listCustomPluginsRequest) throws NotFoundException, BadRequestException,
            ForbiddenException, ServiceUnavailableException, TooManyRequestsException, UnauthorizedException,
            InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        return listCustomPluginsPaginator(ListCustomPluginsRequest.builder().applyMutation(listCustomPluginsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     * @return Result of the ListWorkerConfigurations operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerConfigurationsResponse listWorkerConfigurations(
            ListWorkerConfigurationsRequest listWorkerConfigurationsRequest) throws NotFoundException, BadRequestException,
            ForbiddenException, ServiceUnavailableException, TooManyRequestsException, UnauthorizedException,
            InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkerConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkerConfigurations operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerConfigurationsResponse listWorkerConfigurations(
            Consumer<ListWorkerConfigurationsRequest.Builder> listWorkerConfigurationsRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        return listWorkerConfigurations(ListWorkerConfigurationsRequest.builder().applyMutation(listWorkerConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsIterable responses = client.listWorkerConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsIterable responses = client
     *             .listWorkerConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsIterable responses = client.listWorkerConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerConfigurationsIterable listWorkerConfigurationsPaginator(
            ListWorkerConfigurationsRequest listWorkerConfigurationsRequest) throws NotFoundException, BadRequestException,
            ForbiddenException, ServiceUnavailableException, TooManyRequestsException, UnauthorizedException,
            InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the worker configurations in this account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsIterable responses = client.listWorkerConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsIterable responses = client
     *             .listWorkerConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafkaconnect.paginators.ListWorkerConfigurationsIterable responses = client.listWorkerConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerConfigurations(software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorkerConfigurationsRequest#builder()}
     * </p>
     *
     * @param listWorkerConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkerConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.ListWorkerConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/ListWorkerConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerConfigurationsIterable listWorkerConfigurationsPaginator(
            Consumer<ListWorkerConfigurationsRequest.Builder> listWorkerConfigurationsRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        return listWorkerConfigurationsPaginator(ListWorkerConfigurationsRequest.builder()
                .applyMutation(listWorkerConfigurationsRequest).build());
    }

    /**
     * <p>
     * Updates the specified connector.
     * </p>
     *
     * @param updateConnectorRequest
     * @return Result of the UpdateConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/UpdateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateConnectorResponse updateConnector(UpdateConnectorRequest updateConnectorRequest) throws NotFoundException,
            BadRequestException, ForbiddenException, ServiceUnavailableException, TooManyRequestsException,
            UnauthorizedException, InternalServerErrorException, AwsServiceException, SdkClientException, KafkaConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectorRequest#builder()}
     * </p>
     *
     * @param updateConnectorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectorRequest.Builder} to create a request.
     * @return Result of the UpdateConnector operation returned by the service.
     * @throws NotFoundException
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     * @throws BadRequestException
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     * @throws ForbiddenException
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     * @throws ServiceUnavailableException
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     * @throws TooManyRequestsException
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     * @throws UnauthorizedException
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     * @throws InternalServerErrorException
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KafkaConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KafkaConnectClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafkaconnect-2021-09-14/UpdateConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateConnectorResponse updateConnector(Consumer<UpdateConnectorRequest.Builder> updateConnectorRequest)
            throws NotFoundException, BadRequestException, ForbiddenException, ServiceUnavailableException,
            TooManyRequestsException, UnauthorizedException, InternalServerErrorException, AwsServiceException,
            SdkClientException, KafkaConnectException {
        return updateConnector(UpdateConnectorRequest.builder().applyMutation(updateConnectorRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
