/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the revision of a custom plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPluginRevisionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomPluginRevisionSummary.Builder, CustomPluginRevisionSummary> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(CustomPluginRevisionSummary::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(CustomPluginRevisionSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CustomPluginRevisionSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<CustomPluginFileDescription> FILE_DESCRIPTION_FIELD = SdkField
            .<CustomPluginFileDescription> builder(MarshallingType.SDK_POJO).memberName("fileDescription")
            .getter(getter(CustomPluginRevisionSummary::fileDescription)).setter(setter(Builder::fileDescription))
            .constructor(CustomPluginFileDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileDescription").build()).build();

    private static final SdkField<CustomPluginLocationDescription> LOCATION_FIELD = SdkField
            .<CustomPluginLocationDescription> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(CustomPluginRevisionSummary::location)).setter(setter(Builder::location))
            .constructor(CustomPluginLocationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Long> REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("revision")
            .getter(getter(CustomPluginRevisionSummary::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CREATION_TIME_FIELD, DESCRIPTION_FIELD, FILE_DESCRIPTION_FIELD, LOCATION_FIELD, REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentType;

    private final Instant creationTime;

    private final String description;

    private final CustomPluginFileDescription fileDescription;

    private final CustomPluginLocationDescription location;

    private final Long revision;

    private CustomPluginRevisionSummary(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.fileDescription = builder.fileDescription;
        this.location = builder.location;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The format of the plugin file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CustomPluginContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The format of the plugin file.
     * @see CustomPluginContentType
     */
    public final CustomPluginContentType contentType() {
        return CustomPluginContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The format of the plugin file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CustomPluginContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The format of the plugin file.
     * @see CustomPluginContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * The time that the custom plugin was created.
     * </p>
     * 
     * @return The time that the custom plugin was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the custom plugin.
     * </p>
     * 
     * @return The description of the custom plugin.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Details about the custom plugin file.
     * </p>
     * 
     * @return Details about the custom plugin file.
     */
    public final CustomPluginFileDescription fileDescription() {
        return fileDescription;
    }

    /**
     * <p>
     * Information about the location of the custom plugin.
     * </p>
     * 
     * @return Information about the location of the custom plugin.
     */
    public final CustomPluginLocationDescription location() {
        return location;
    }

    /**
     * <p>
     * The revision of the custom plugin.
     * </p>
     * 
     * @return The revision of the custom plugin.
     */
    public final Long revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(fileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPluginRevisionSummary)) {
            return false;
        }
        CustomPluginRevisionSummary other = (CustomPluginRevisionSummary) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(fileDescription(), other.fileDescription()) && Objects.equals(location(), other.location())
                && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPluginRevisionSummary").add("ContentType", contentTypeAsString())
                .add("CreationTime", creationTime()).add("Description", description()).add("FileDescription", fileDescription())
                .add("Location", location()).add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "fileDescription":
            return Optional.ofNullable(clazz.cast(fileDescription()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomPluginRevisionSummary, T> g) {
        return obj -> g.apply((CustomPluginRevisionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPluginRevisionSummary> {
        /**
         * <p>
         * The format of the plugin file.
         * </p>
         * 
         * @param contentType
         *        The format of the plugin file.
         * @see CustomPluginContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The format of the plugin file.
         * </p>
         * 
         * @param contentType
         *        The format of the plugin file.
         * @see CustomPluginContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginContentType
         */
        Builder contentType(CustomPluginContentType contentType);

        /**
         * <p>
         * The time that the custom plugin was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the custom plugin was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the custom plugin.
         * </p>
         * 
         * @param description
         *        The description of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Details about the custom plugin file.
         * </p>
         * 
         * @param fileDescription
         *        Details about the custom plugin file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileDescription(CustomPluginFileDescription fileDescription);

        /**
         * <p>
         * Details about the custom plugin file.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPluginFileDescription.Builder}
         * avoiding the need to create one manually via {@link CustomPluginFileDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomPluginFileDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #fileDescription(CustomPluginFileDescription)}.
         * 
         * @param fileDescription
         *        a consumer that will call methods on {@link CustomPluginFileDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileDescription(CustomPluginFileDescription)
         */
        default Builder fileDescription(Consumer<CustomPluginFileDescription.Builder> fileDescription) {
            return fileDescription(CustomPluginFileDescription.builder().applyMutation(fileDescription).build());
        }

        /**
         * <p>
         * Information about the location of the custom plugin.
         * </p>
         * 
         * @param location
         *        Information about the location of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(CustomPluginLocationDescription location);

        /**
         * <p>
         * Information about the location of the custom plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPluginLocationDescription.Builder}
         * avoiding the need to create one manually via {@link CustomPluginLocationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomPluginLocationDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #location(CustomPluginLocationDescription)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link CustomPluginLocationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(CustomPluginLocationDescription)
         */
        default Builder location(Consumer<CustomPluginLocationDescription.Builder> location) {
            return location(CustomPluginLocationDescription.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The revision of the custom plugin.
         * </p>
         * 
         * @param revision
         *        The revision of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Long revision);
    }

    static final class BuilderImpl implements Builder {
        private String contentType;

        private Instant creationTime;

        private String description;

        private CustomPluginFileDescription fileDescription;

        private CustomPluginLocationDescription location;

        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPluginRevisionSummary model) {
            contentType(model.contentType);
            creationTime(model.creationTime);
            description(model.description);
            fileDescription(model.fileDescription);
            location(model.location);
            revision(model.revision);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(CustomPluginContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CustomPluginFileDescription.Builder getFileDescription() {
            return fileDescription != null ? fileDescription.toBuilder() : null;
        }

        public final void setFileDescription(CustomPluginFileDescription.BuilderImpl fileDescription) {
            this.fileDescription = fileDescription != null ? fileDescription.build() : null;
        }

        @Override
        public final Builder fileDescription(CustomPluginFileDescription fileDescription) {
            this.fileDescription = fileDescription;
            return this;
        }

        public final CustomPluginLocationDescription.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(CustomPluginLocationDescription.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(CustomPluginLocationDescription location) {
            this.location = location;
            return this;
        }

        public final Long getRevision() {
            return revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public CustomPluginRevisionSummary build() {
            return new CustomPluginRevisionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
