/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<DescribeConnectorResponse.Builder, DescribeConnectorResponse> {
    private static final SdkField<CapacityDescription> CAPACITY_FIELD = SdkField
            .<CapacityDescription> builder(MarshallingType.SDK_POJO).memberName("capacity")
            .getter(getter(DescribeConnectorResponse::capacity)).setter(setter(Builder::capacity))
            .constructor(CapacityDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorArn").getter(getter(DescribeConnectorResponse::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()).build();

    private static final SdkField<Map<String, String>> CONNECTOR_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("connectorConfiguration")
            .getter(getter(DescribeConnectorResponse::connectorConfiguration))
            .setter(setter(Builder::connectorConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorDescription").getter(getter(DescribeConnectorResponse::connectorDescription))
            .setter(setter(Builder::connectorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build())
            .build();

    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorName").getter(getter(DescribeConnectorResponse::connectorName))
            .setter(setter(Builder::connectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()).build();

    private static final SdkField<String> CONNECTOR_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorState").getter(getter(DescribeConnectorResponse::connectorStateAsString))
            .setter(setter(Builder::connectorState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorState").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(DescribeConnectorResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentVersion").getter(getter(DescribeConnectorResponse::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<KafkaClusterDescription> KAFKA_CLUSTER_FIELD = SdkField
            .<KafkaClusterDescription> builder(MarshallingType.SDK_POJO).memberName("kafkaCluster")
            .getter(getter(DescribeConnectorResponse::kafkaCluster)).setter(setter(Builder::kafkaCluster))
            .constructor(KafkaClusterDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaCluster").build()).build();

    private static final SdkField<KafkaClusterClientAuthenticationDescription> KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD = SdkField
            .<KafkaClusterClientAuthenticationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("kafkaClusterClientAuthentication")
            .getter(getter(DescribeConnectorResponse::kafkaClusterClientAuthentication))
            .setter(setter(Builder::kafkaClusterClientAuthentication))
            .constructor(KafkaClusterClientAuthenticationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterClientAuthentication")
                    .build()).build();

    private static final SdkField<KafkaClusterEncryptionInTransitDescription> KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD = SdkField
            .<KafkaClusterEncryptionInTransitDescription> builder(MarshallingType.SDK_POJO)
            .memberName("kafkaClusterEncryptionInTransit")
            .getter(getter(DescribeConnectorResponse::kafkaClusterEncryptionInTransit))
            .setter(setter(Builder::kafkaClusterEncryptionInTransit))
            .constructor(KafkaClusterEncryptionInTransitDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterEncryptionInTransit")
                    .build()).build();

    private static final SdkField<String> KAFKA_CONNECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kafkaConnectVersion").getter(getter(DescribeConnectorResponse::kafkaConnectVersion))
            .setter(setter(Builder::kafkaConnectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaConnectVersion").build())
            .build();

    private static final SdkField<LogDeliveryDescription> LOG_DELIVERY_FIELD = SdkField
            .<LogDeliveryDescription> builder(MarshallingType.SDK_POJO).memberName("logDelivery")
            .getter(getter(DescribeConnectorResponse::logDelivery)).setter(setter(Builder::logDelivery))
            .constructor(LogDeliveryDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDelivery").build()).build();

    private static final SdkField<List<PluginDescription>> PLUGINS_FIELD = SdkField
            .<List<PluginDescription>> builder(MarshallingType.LIST)
            .memberName("plugins")
            .getter(getter(DescribeConnectorResponse::plugins))
            .setter(setter(Builder::plugins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plugins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PluginDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PluginDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceExecutionRoleArn").getter(getter(DescribeConnectorResponse::serviceExecutionRoleArn))
            .setter(setter(Builder::serviceExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build())
            .build();

    private static final SdkField<StateDescription> STATE_DESCRIPTION_FIELD = SdkField
            .<StateDescription> builder(MarshallingType.SDK_POJO).memberName("stateDescription")
            .getter(getter(DescribeConnectorResponse::stateDescription)).setter(setter(Builder::stateDescription))
            .constructor(StateDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDescription").build()).build();

    private static final SdkField<WorkerConfigurationDescription> WORKER_CONFIGURATION_FIELD = SdkField
            .<WorkerConfigurationDescription> builder(MarshallingType.SDK_POJO).memberName("workerConfiguration")
            .getter(getter(DescribeConnectorResponse::workerConfiguration)).setter(setter(Builder::workerConfiguration))
            .constructor(WorkerConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            CONNECTOR_ARN_FIELD, CONNECTOR_CONFIGURATION_FIELD, CONNECTOR_DESCRIPTION_FIELD, CONNECTOR_NAME_FIELD,
            CONNECTOR_STATE_FIELD, CREATION_TIME_FIELD, CURRENT_VERSION_FIELD, KAFKA_CLUSTER_FIELD,
            KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD, KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD, KAFKA_CONNECT_VERSION_FIELD,
            LOG_DELIVERY_FIELD, PLUGINS_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD, STATE_DESCRIPTION_FIELD,
            WORKER_CONFIGURATION_FIELD));

    private final CapacityDescription capacity;

    private final String connectorArn;

    private final Map<String, String> connectorConfiguration;

    private final String connectorDescription;

    private final String connectorName;

    private final String connectorState;

    private final Instant creationTime;

    private final String currentVersion;

    private final KafkaClusterDescription kafkaCluster;

    private final KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication;

    private final KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit;

    private final String kafkaConnectVersion;

    private final LogDeliveryDescription logDelivery;

    private final List<PluginDescription> plugins;

    private final String serviceExecutionRoleArn;

    private final StateDescription stateDescription;

    private final WorkerConfigurationDescription workerConfiguration;

    private DescribeConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.connectorArn = builder.connectorArn;
        this.connectorConfiguration = builder.connectorConfiguration;
        this.connectorDescription = builder.connectorDescription;
        this.connectorName = builder.connectorName;
        this.connectorState = builder.connectorState;
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.kafkaCluster = builder.kafkaCluster;
        this.kafkaClusterClientAuthentication = builder.kafkaClusterClientAuthentication;
        this.kafkaClusterEncryptionInTransit = builder.kafkaClusterEncryptionInTransit;
        this.kafkaConnectVersion = builder.kafkaConnectVersion;
        this.logDelivery = builder.logDelivery;
        this.plugins = builder.plugins;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.stateDescription = builder.stateDescription;
        this.workerConfiguration = builder.workerConfiguration;
    }

    /**
     * <p>
     * Information about the capacity of the connector, whether it is auto scaled or provisioned.
     * </p>
     * 
     * @return Information about the capacity of the connector, whether it is auto scaled or provisioned.
     */
    public final CapacityDescription capacity() {
        return capacity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorConfiguration() {
        return connectorConfiguration != null && !(connectorConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of keys to values that represent the configuration for the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorConfiguration} method.
     * </p>
     * 
     * @return A map of keys to values that represent the configuration for the connector.
     */
    public final Map<String, String> connectorConfiguration() {
        return connectorConfiguration;
    }

    /**
     * <p>
     * A summary description of the connector.
     * </p>
     * 
     * @return A summary description of the connector.
     */
    public final String connectorDescription() {
        return connectorDescription;
    }

    /**
     * <p>
     * The name of the connector.
     * </p>
     * 
     * @return The name of the connector.
     */
    public final String connectorName() {
        return connectorName;
    }

    /**
     * <p>
     * The state of the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorState}
     * will return {@link ConnectorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStateAsString}.
     * </p>
     * 
     * @return The state of the connector.
     * @see ConnectorState
     */
    public final ConnectorState connectorState() {
        return ConnectorState.fromValue(connectorState);
    }

    /**
     * <p>
     * The state of the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorState}
     * will return {@link ConnectorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStateAsString}.
     * </p>
     * 
     * @return The state of the connector.
     * @see ConnectorState
     */
    public final String connectorStateAsString() {
        return connectorState;
    }

    /**
     * <p>
     * The time the connector was created.
     * </p>
     * 
     * @return The time the connector was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The current version of the connector.
     * </p>
     * 
     * @return The current version of the connector.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The Apache Kafka cluster that the connector is connected to.
     * </p>
     * 
     * @return The Apache Kafka cluster that the connector is connected to.
     */
    public final KafkaClusterDescription kafkaCluster() {
        return kafkaCluster;
    }

    /**
     * <p>
     * The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client
     * authentication is used.
     * </p>
     * 
     * @return The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no
     *         client authentication is used.
     */
    public final KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication() {
        return kafkaClusterClientAuthentication;
    }

    /**
     * <p>
     * Details of encryption in transit to the Apache Kafka cluster.
     * </p>
     * 
     * @return Details of encryption in transit to the Apache Kafka cluster.
     */
    public final KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit() {
        return kafkaClusterEncryptionInTransit;
    }

    /**
     * <p>
     * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the
     * plugins.
     * </p>
     * 
     * @return The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and
     *         the plugins.
     */
    public final String kafkaConnectVersion() {
        return kafkaConnectVersion;
    }

    /**
     * <p>
     * Details about delivering logs to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return Details about delivering logs to Amazon CloudWatch Logs.
     */
    public final LogDeliveryDescription logDelivery() {
        return logDelivery;
    }

    /**
     * For responses, this returns true if the service returned a value for the Plugins property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPlugins() {
        return plugins != null && !(plugins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies which plugins were used for this connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlugins} method.
     * </p>
     * 
     * @return Specifies which plugins were used for this connector.
     */
    public final List<PluginDescription> plugins() {
        return plugins;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services
     *         resources.
     */
    public final String serviceExecutionRoleArn() {
        return serviceExecutionRoleArn;
    }

    /**
     * <p>
     * Details about the state of a connector.
     * </p>
     * 
     * @return Details about the state of a connector.
     */
    public final StateDescription stateDescription() {
        return stateDescription;
    }

    /**
     * <p>
     * Specifies which worker configuration was used for the connector.
     * </p>
     * 
     * @return Specifies which worker configuration was used for the connector.
     */
    public final WorkerConfigurationDescription workerConfiguration() {
        return workerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorConfiguration() ? connectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaCluster());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaClusterClientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaClusterEncryptionInTransit());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaConnectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(logDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlugins() ? plugins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(workerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorResponse)) {
            return false;
        }
        DescribeConnectorResponse other = (DescribeConnectorResponse) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(connectorArn(), other.connectorArn())
                && hasConnectorConfiguration() == other.hasConnectorConfiguration()
                && Objects.equals(connectorConfiguration(), other.connectorConfiguration())
                && Objects.equals(connectorDescription(), other.connectorDescription())
                && Objects.equals(connectorName(), other.connectorName())
                && Objects.equals(connectorStateAsString(), other.connectorStateAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(kafkaCluster(), other.kafkaCluster())
                && Objects.equals(kafkaClusterClientAuthentication(), other.kafkaClusterClientAuthentication())
                && Objects.equals(kafkaClusterEncryptionInTransit(), other.kafkaClusterEncryptionInTransit())
                && Objects.equals(kafkaConnectVersion(), other.kafkaConnectVersion())
                && Objects.equals(logDelivery(), other.logDelivery()) && hasPlugins() == other.hasPlugins()
                && Objects.equals(plugins(), other.plugins())
                && Objects.equals(serviceExecutionRoleArn(), other.serviceExecutionRoleArn())
                && Objects.equals(stateDescription(), other.stateDescription())
                && Objects.equals(workerConfiguration(), other.workerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorResponse").add("Capacity", capacity()).add("ConnectorArn", connectorArn())
                .add("ConnectorConfiguration", connectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectorDescription", connectorDescription()).add("ConnectorName", connectorName())
                .add("ConnectorState", connectorStateAsString()).add("CreationTime", creationTime())
                .add("CurrentVersion", currentVersion()).add("KafkaCluster", kafkaCluster())
                .add("KafkaClusterClientAuthentication", kafkaClusterClientAuthentication())
                .add("KafkaClusterEncryptionInTransit", kafkaClusterEncryptionInTransit())
                .add("KafkaConnectVersion", kafkaConnectVersion()).add("LogDelivery", logDelivery())
                .add("Plugins", hasPlugins() ? plugins() : null).add("ServiceExecutionRoleArn", serviceExecutionRoleArn())
                .add("StateDescription", stateDescription()).add("WorkerConfiguration", workerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "connectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "connectorConfiguration":
            return Optional.ofNullable(clazz.cast(connectorConfiguration()));
        case "connectorDescription":
            return Optional.ofNullable(clazz.cast(connectorDescription()));
        case "connectorName":
            return Optional.ofNullable(clazz.cast(connectorName()));
        case "connectorState":
            return Optional.ofNullable(clazz.cast(connectorStateAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "currentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "kafkaCluster":
            return Optional.ofNullable(clazz.cast(kafkaCluster()));
        case "kafkaClusterClientAuthentication":
            return Optional.ofNullable(clazz.cast(kafkaClusterClientAuthentication()));
        case "kafkaClusterEncryptionInTransit":
            return Optional.ofNullable(clazz.cast(kafkaClusterEncryptionInTransit()));
        case "kafkaConnectVersion":
            return Optional.ofNullable(clazz.cast(kafkaConnectVersion()));
        case "logDelivery":
            return Optional.ofNullable(clazz.cast(logDelivery()));
        case "plugins":
            return Optional.ofNullable(clazz.cast(plugins()));
        case "serviceExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(serviceExecutionRoleArn()));
        case "stateDescription":
            return Optional.ofNullable(clazz.cast(stateDescription()));
        case "workerConfiguration":
            return Optional.ofNullable(clazz.cast(workerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorResponse, T> g) {
        return obj -> g.apply((DescribeConnectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorResponse> {
        /**
         * <p>
         * Information about the capacity of the connector, whether it is auto scaled or provisioned.
         * </p>
         * 
         * @param capacity
         *        Information about the capacity of the connector, whether it is auto scaled or provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(CapacityDescription capacity);

        /**
         * <p>
         * Information about the capacity of the connector, whether it is auto scaled or provisioned.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityDescription.Builder} avoiding the
         * need to create one manually via {@link CapacityDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacityDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #capacity(CapacityDescription)}.
         * 
         * @param capacity
         *        a consumer that will call methods on {@link CapacityDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacity(CapacityDescription)
         */
        default Builder capacity(Consumer<CapacityDescription.Builder> capacity) {
            return capacity(CapacityDescription.builder().applyMutation(capacity).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * A map of keys to values that represent the configuration for the connector.
         * </p>
         * 
         * @param connectorConfiguration
         *        A map of keys to values that represent the configuration for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorConfiguration(Map<String, String> connectorConfiguration);

        /**
         * <p>
         * A summary description of the connector.
         * </p>
         * 
         * @param connectorDescription
         *        A summary description of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDescription(String connectorDescription);

        /**
         * <p>
         * The name of the connector.
         * </p>
         * 
         * @param connectorName
         *        The name of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorName(String connectorName);

        /**
         * <p>
         * The state of the connector.
         * </p>
         * 
         * @param connectorState
         *        The state of the connector.
         * @see ConnectorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorState
         */
        Builder connectorState(String connectorState);

        /**
         * <p>
         * The state of the connector.
         * </p>
         * 
         * @param connectorState
         *        The state of the connector.
         * @see ConnectorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorState
         */
        Builder connectorState(ConnectorState connectorState);

        /**
         * <p>
         * The time the connector was created.
         * </p>
         * 
         * @param creationTime
         *        The time the connector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The current version of the connector.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The Apache Kafka cluster that the connector is connected to.
         * </p>
         * 
         * @param kafkaCluster
         *        The Apache Kafka cluster that the connector is connected to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaCluster(KafkaClusterDescription kafkaCluster);

        /**
         * <p>
         * The Apache Kafka cluster that the connector is connected to.
         * </p>
         * This is a convenience method that creates an instance of the {@link KafkaClusterDescription.Builder} avoiding
         * the need to create one manually via {@link KafkaClusterDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KafkaClusterDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #kafkaCluster(KafkaClusterDescription)}.
         * 
         * @param kafkaCluster
         *        a consumer that will call methods on {@link KafkaClusterDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaCluster(KafkaClusterDescription)
         */
        default Builder kafkaCluster(Consumer<KafkaClusterDescription.Builder> kafkaCluster) {
            return kafkaCluster(KafkaClusterDescription.builder().applyMutation(kafkaCluster).build());
        }

        /**
         * <p>
         * The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no
         * client authentication is used.
         * </p>
         * 
         * @param kafkaClusterClientAuthentication
         *        The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when
         *        no client authentication is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication);

        /**
         * <p>
         * The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no
         * client authentication is used.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KafkaClusterClientAuthenticationDescription.Builder} avoiding the need to create one manually via
         * {@link KafkaClusterClientAuthenticationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KafkaClusterClientAuthenticationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationDescription)}.
         * 
         * @param kafkaClusterClientAuthentication
         *        a consumer that will call methods on {@link KafkaClusterClientAuthenticationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationDescription)
         */
        default Builder kafkaClusterClientAuthentication(
                Consumer<KafkaClusterClientAuthenticationDescription.Builder> kafkaClusterClientAuthentication) {
            return kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationDescription.builder()
                    .applyMutation(kafkaClusterClientAuthentication).build());
        }

        /**
         * <p>
         * Details of encryption in transit to the Apache Kafka cluster.
         * </p>
         * 
         * @param kafkaClusterEncryptionInTransit
         *        Details of encryption in transit to the Apache Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit);

        /**
         * <p>
         * Details of encryption in transit to the Apache Kafka cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KafkaClusterEncryptionInTransitDescription.Builder} avoiding the need to create one manually via
         * {@link KafkaClusterEncryptionInTransitDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KafkaClusterEncryptionInTransitDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitDescription)}.
         * 
         * @param kafkaClusterEncryptionInTransit
         *        a consumer that will call methods on {@link KafkaClusterEncryptionInTransitDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitDescription)
         */
        default Builder kafkaClusterEncryptionInTransit(
                Consumer<KafkaClusterEncryptionInTransitDescription.Builder> kafkaClusterEncryptionInTransit) {
            return kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitDescription.builder()
                    .applyMutation(kafkaClusterEncryptionInTransit).build());
        }

        /**
         * <p>
         * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the
         * plugins.
         * </p>
         * 
         * @param kafkaConnectVersion
         *        The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and
         *        the plugins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaConnectVersion(String kafkaConnectVersion);

        /**
         * <p>
         * Details about delivering logs to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param logDelivery
         *        Details about delivering logs to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDelivery(LogDeliveryDescription logDelivery);

        /**
         * <p>
         * Details about delivering logs to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryDescription.Builder} avoiding
         * the need to create one manually via {@link LogDeliveryDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogDeliveryDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #logDelivery(LogDeliveryDescription)}.
         * 
         * @param logDelivery
         *        a consumer that will call methods on {@link LogDeliveryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDelivery(LogDeliveryDescription)
         */
        default Builder logDelivery(Consumer<LogDeliveryDescription.Builder> logDelivery) {
            return logDelivery(LogDeliveryDescription.builder().applyMutation(logDelivery).build());
        }

        /**
         * <p>
         * Specifies which plugins were used for this connector.
         * </p>
         * 
         * @param plugins
         *        Specifies which plugins were used for this connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plugins(Collection<PluginDescription> plugins);

        /**
         * <p>
         * Specifies which plugins were used for this connector.
         * </p>
         * 
         * @param plugins
         *        Specifies which plugins were used for this connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plugins(PluginDescription... plugins);

        /**
         * <p>
         * Specifies which plugins were used for this connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PluginDescription>.Builder} avoiding
         * the need to create one manually via {@link List<PluginDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PluginDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #plugins(List<PluginDescription>)}.
         * 
         * @param plugins
         *        a consumer that will call methods on {@link List<PluginDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plugins(List<PluginDescription>)
         */
        Builder plugins(Consumer<PluginDescription.Builder>... plugins);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
         * </p>
         * 
         * @param serviceExecutionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceExecutionRoleArn(String serviceExecutionRoleArn);

        /**
         * <p>
         * Details about the state of a connector.
         * </p>
         * 
         * @param stateDescription
         *        Details about the state of a connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateDescription(StateDescription stateDescription);

        /**
         * <p>
         * Details about the state of a connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link StateDescription.Builder} avoiding the
         * need to create one manually via {@link StateDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #stateDescription(StateDescription)}.
         * 
         * @param stateDescription
         *        a consumer that will call methods on {@link StateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateDescription(StateDescription)
         */
        default Builder stateDescription(Consumer<StateDescription.Builder> stateDescription) {
            return stateDescription(StateDescription.builder().applyMutation(stateDescription).build());
        }

        /**
         * <p>
         * Specifies which worker configuration was used for the connector.
         * </p>
         * 
         * @param workerConfiguration
         *        Specifies which worker configuration was used for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfiguration(WorkerConfigurationDescription workerConfiguration);

        /**
         * <p>
         * Specifies which worker configuration was used for the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkerConfigurationDescription.Builder}
         * avoiding the need to create one manually via {@link WorkerConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkerConfigurationDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #workerConfiguration(WorkerConfigurationDescription)}.
         * 
         * @param workerConfiguration
         *        a consumer that will call methods on {@link WorkerConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerConfiguration(WorkerConfigurationDescription)
         */
        default Builder workerConfiguration(Consumer<WorkerConfigurationDescription.Builder> workerConfiguration) {
            return workerConfiguration(WorkerConfigurationDescription.builder().applyMutation(workerConfiguration).build());
        }
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private CapacityDescription capacity;

        private String connectorArn;

        private Map<String, String> connectorConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String connectorDescription;

        private String connectorName;

        private String connectorState;

        private Instant creationTime;

        private String currentVersion;

        private KafkaClusterDescription kafkaCluster;

        private KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication;

        private KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit;

        private String kafkaConnectVersion;

        private LogDeliveryDescription logDelivery;

        private List<PluginDescription> plugins = DefaultSdkAutoConstructList.getInstance();

        private String serviceExecutionRoleArn;

        private StateDescription stateDescription;

        private WorkerConfigurationDescription workerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorResponse model) {
            super(model);
            capacity(model.capacity);
            connectorArn(model.connectorArn);
            connectorConfiguration(model.connectorConfiguration);
            connectorDescription(model.connectorDescription);
            connectorName(model.connectorName);
            connectorState(model.connectorState);
            creationTime(model.creationTime);
            currentVersion(model.currentVersion);
            kafkaCluster(model.kafkaCluster);
            kafkaClusterClientAuthentication(model.kafkaClusterClientAuthentication);
            kafkaClusterEncryptionInTransit(model.kafkaClusterEncryptionInTransit);
            kafkaConnectVersion(model.kafkaConnectVersion);
            logDelivery(model.logDelivery);
            plugins(model.plugins);
            serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            stateDescription(model.stateDescription);
            workerConfiguration(model.workerConfiguration);
        }

        public final CapacityDescription.Builder getCapacity() {
            return capacity != null ? capacity.toBuilder() : null;
        }

        public final void setCapacity(CapacityDescription.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(CapacityDescription capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Map<String, String> getConnectorConfiguration() {
            if (connectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectorConfiguration;
        }

        public final void setConnectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = SyntheticDescribeConnectorResponse__mapOf__stringCopier.copy(connectorConfiguration);
        }

        @Override
        public final Builder connectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = SyntheticDescribeConnectorResponse__mapOf__stringCopier.copy(connectorConfiguration);
            return this;
        }

        public final String getConnectorDescription() {
            return connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorName() {
            return connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorState() {
            return connectorState;
        }

        public final void setConnectorState(String connectorState) {
            this.connectorState = connectorState;
        }

        @Override
        public final Builder connectorState(String connectorState) {
            this.connectorState = connectorState;
            return this;
        }

        @Override
        public final Builder connectorState(ConnectorState connectorState) {
            this.connectorState(connectorState == null ? null : connectorState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final KafkaClusterDescription.Builder getKafkaCluster() {
            return kafkaCluster != null ? kafkaCluster.toBuilder() : null;
        }

        public final void setKafkaCluster(KafkaClusterDescription.BuilderImpl kafkaCluster) {
            this.kafkaCluster = kafkaCluster != null ? kafkaCluster.build() : null;
        }

        @Override
        public final Builder kafkaCluster(KafkaClusterDescription kafkaCluster) {
            this.kafkaCluster = kafkaCluster;
            return this;
        }

        public final KafkaClusterClientAuthenticationDescription.Builder getKafkaClusterClientAuthentication() {
            return kafkaClusterClientAuthentication != null ? kafkaClusterClientAuthentication.toBuilder() : null;
        }

        public final void setKafkaClusterClientAuthentication(
                KafkaClusterClientAuthenticationDescription.BuilderImpl kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication != null ? kafkaClusterClientAuthentication
                    .build() : null;
        }

        @Override
        public final Builder kafkaClusterClientAuthentication(
                KafkaClusterClientAuthenticationDescription kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication;
            return this;
        }

        public final KafkaClusterEncryptionInTransitDescription.Builder getKafkaClusterEncryptionInTransit() {
            return kafkaClusterEncryptionInTransit != null ? kafkaClusterEncryptionInTransit.toBuilder() : null;
        }

        public final void setKafkaClusterEncryptionInTransit(
                KafkaClusterEncryptionInTransitDescription.BuilderImpl kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit != null ? kafkaClusterEncryptionInTransit
                    .build() : null;
        }

        @Override
        public final Builder kafkaClusterEncryptionInTransit(
                KafkaClusterEncryptionInTransitDescription kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit;
            return this;
        }

        public final String getKafkaConnectVersion() {
            return kafkaConnectVersion;
        }

        public final void setKafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
        }

        @Override
        public final Builder kafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
            return this;
        }

        public final LogDeliveryDescription.Builder getLogDelivery() {
            return logDelivery != null ? logDelivery.toBuilder() : null;
        }

        public final void setLogDelivery(LogDeliveryDescription.BuilderImpl logDelivery) {
            this.logDelivery = logDelivery != null ? logDelivery.build() : null;
        }

        @Override
        public final Builder logDelivery(LogDeliveryDescription logDelivery) {
            this.logDelivery = logDelivery;
            return this;
        }

        public final List<PluginDescription.Builder> getPlugins() {
            List<PluginDescription.Builder> result = ___listOfPluginDescriptionCopier.copyToBuilder(this.plugins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlugins(Collection<PluginDescription.BuilderImpl> plugins) {
            this.plugins = ___listOfPluginDescriptionCopier.copyFromBuilder(plugins);
        }

        @Override
        public final Builder plugins(Collection<PluginDescription> plugins) {
            this.plugins = ___listOfPluginDescriptionCopier.copy(plugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(PluginDescription... plugins) {
            plugins(Arrays.asList(plugins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(Consumer<PluginDescription.Builder>... plugins) {
            plugins(Stream.of(plugins).map(c -> PluginDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final StateDescription.Builder getStateDescription() {
            return stateDescription != null ? stateDescription.toBuilder() : null;
        }

        public final void setStateDescription(StateDescription.BuilderImpl stateDescription) {
            this.stateDescription = stateDescription != null ? stateDescription.build() : null;
        }

        @Override
        public final Builder stateDescription(StateDescription stateDescription) {
            this.stateDescription = stateDescription;
            return this;
        }

        public final WorkerConfigurationDescription.Builder getWorkerConfiguration() {
            return workerConfiguration != null ? workerConfiguration.toBuilder() : null;
        }

        public final void setWorkerConfiguration(WorkerConfigurationDescription.BuilderImpl workerConfiguration) {
            this.workerConfiguration = workerConfiguration != null ? workerConfiguration.build() : null;
        }

        @Override
        public final Builder workerConfiguration(WorkerConfigurationDescription workerConfiguration) {
            this.workerConfiguration = workerConfiguration;
            return this;
        }

        @Override
        public DescribeConnectorResponse build() {
            return new DescribeConnectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
